/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.drools;

import java.util.List;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.ExecutionResults;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.util.KieServerUtils;

public class RulesExecutionService {
    private KieServerRegistry context;
    private List<AgendaEventListener> agendaEventListeners;
    private List<RuleRuntimeEventListener> ruleRuntimeEventListeners;

    public RulesExecutionService(KieServerRegistry context) {
        this.context = context;
    }

    public ExecutionResults call(KieContainerInstance kci, BatchExecutionCommand executionCommand) {
        BatchExecutionCommandImpl command = (BatchExecutionCommandImpl)executionCommand;
        if (kci != null && kci.getKieContainer() != null) {
            CommandExecutor ks = null;
            ks = command.getLookup() != null ? this.context.getKieSessionLookupManager().lookup(command.getLookup(), kci, this.context) : KieServerUtils.getDefaultKieSession((KieContainerInstanceImpl)((KieContainerInstanceImpl)kci));
            if (ks != null) {
                this.applyListeners(ks);
                ExecutionResults results = (ExecutionResults)ks.execute((Command)command);
                return results;
            }
            throw new IllegalStateException("Session '" + command.getLookup() + "' not found on container '" + kci.getContainerId() + "'.");
        }
        throw new IllegalStateException("Unable to execute command " + command);
    }

    protected void applyListeners(CommandExecutor ks) {
        if (this.ruleRuntimeEventListeners != null) {
            this.ruleRuntimeEventListeners.forEach(listener -> ((KieRuntimeEventManager)ks).addEventListener(listener));
        }
        if (this.agendaEventListeners != null) {
            this.agendaEventListeners.forEach(listener -> ((KieRuntimeEventManager)ks).addEventListener(listener));
        }
    }

    public List<AgendaEventListener> getAgendaEventListeners() {
        return this.agendaEventListeners;
    }

    public void setAgendaEventListeners(List<AgendaEventListener> agendaEventListeners) {
        this.agendaEventListeners = agendaEventListeners;
    }

    public List<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        return this.ruleRuntimeEventListeners;
    }

    public void setRuleRuntimeEventListeners(List<RuleRuntimeEventListener> ruleRuntimeEventListeners) {
        this.ruleRuntimeEventListeners = ruleRuntimeEventListeners;
    }
}

