/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.metadata.backend.infinispan.exceptions.RetryException;

public class Retry {
    private int retries;
    private Runnable runnable;
    private boolean finished = false;
    private Logger logger = LoggerFactory.getLogger(Retry.class);

    public Retry(int retries, Runnable runnable) {
        this.retries = retries;
        this.runnable = runnable;
    }

    public Retry run() {
        int maxRetries = this.retries;
        while (this.retries > 0 && !this.finished) {
            try {
                this.runnable.run();
                this.finished = true;
            }
            catch (Exception e) {
                --this.retries;
                this.logger.error("Error found. Retrying", (Throwable)e);
                if (this.retries > 0) continue;
                throw new RetryException("Retried " + maxRetries + " times but exception found", e);
            }
        }
        return this;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getRemainingRetries() {
        return this.retries;
    }
}

