/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.base.ValueType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.NetworkNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSinkNodeList;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.SingleObjectSinkAdapter;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.ReadAccessor;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.drools.core.util.ObjectHashMap;
import org.drools.core.util.index.AlphaRangeIndex;
import org.drools.core.util.index.IndexUtil;

public class CompositeObjectSinkAdapter
implements ObjectSinkPropagator {
    private static final long serialVersionUID = 510L;
    private ObjectSinkNodeList otherSinks;
    private ObjectSinkNodeList hashableSinks;
    private ObjectSinkNodeList rangeIndexableSinks;
    private LinkedList<FieldIndex> hashedFieldIndexes;
    private LinkedList<FieldIndex> rangeIndexedFieldIndexes;
    private ObjectHashMap hashedSinkMap;
    private Map<FieldIndex, AlphaRangeIndex> rangeIndexMap;
    private int alphaNodeHashingThreshold;
    private int alphaNodeRangeIndexThreshold;
    private ObjectSink[] sinks;
    private Map<NetworkNode, NetworkNode> sinksMap;

    public CompositeObjectSinkAdapter() {
        this(3, 3);
    }

    public CompositeObjectSinkAdapter(int alphaNodeHashingThreshold, int alphaNodeRangeIndexThreshold) {
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
        this.alphaNodeRangeIndexThreshold = alphaNodeRangeIndexThreshold;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.otherSinks = (ObjectSinkNodeList)in.readObject();
        this.hashableSinks = (ObjectSinkNodeList)in.readObject();
        this.rangeIndexableSinks = (ObjectSinkNodeList)in.readObject();
        this.hashedFieldIndexes = (LinkedList)in.readObject();
        this.rangeIndexedFieldIndexes = (LinkedList)in.readObject();
        this.hashedSinkMap = (ObjectHashMap)in.readObject();
        this.rangeIndexMap = (Map)in.readObject();
        this.alphaNodeHashingThreshold = in.readInt();
        this.alphaNodeRangeIndexThreshold = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.otherSinks);
        out.writeObject(this.hashableSinks);
        out.writeObject(this.rangeIndexableSinks);
        out.writeObject(this.hashedFieldIndexes);
        out.writeObject(this.rangeIndexedFieldIndexes);
        out.writeObject(this.hashedSinkMap);
        out.writeObject(this.rangeIndexMap);
        out.writeInt(this.alphaNodeHashingThreshold);
        out.writeInt(this.alphaNodeRangeIndexThreshold);
    }

    public ObjectSinkNodeList getOthers() {
        return this.otherSinks;
    }

    public ObjectSinkNodeList getHashableSinks() {
        return this.hashableSinks;
    }

    public ObjectHashMap getHashedSinkMap() {
        return this.hashedSinkMap;
    }

    public ObjectSinkNodeList getRangeIndexableSinks() {
        return this.rangeIndexableSinks;
    }

    public Map<FieldIndex, AlphaRangeIndex> getRangeIndexMap() {
        return this.rangeIndexMap;
    }

    public ObjectSinkPropagator addObjectSink(ObjectSink sink) {
        return this.addObjectSink(sink, 0, 0);
    }

    @Override
    public ObjectSinkPropagator addObjectSink(ObjectSink sink, int alphaNodeHashingThreshold, int alphaNodeRangeIndexThreshold) {
        this.sinks = null;
        if (this.sinksMap != null) {
            this.sinksMap.put(sink, sink);
        }
        if (sink.getType() == 40) {
            AlphaNode alphaNode = (AlphaNode)sink;
            InternalReadAccessor readAccessor = CompositeObjectSinkAdapter.getHashableAccessor(alphaNode);
            if (readAccessor != null) {
                int index = readAccessor.getIndex();
                FieldIndex fieldIndex = this.registerFieldIndex(index, readAccessor);
                FieldValue value = ((IndexableConstraint)((Object)alphaNode.getConstraint())).getField();
                if (fieldIndex.getCount() >= this.alphaNodeHashingThreshold && this.alphaNodeHashingThreshold != 0 && !value.isNull()) {
                    if (!fieldIndex.isHashed()) {
                        this.hashSinks(fieldIndex);
                    }
                    this.hashedSinkMap.put(new HashKey(index, value, fieldIndex.getFieldExtractor()), alphaNode, false);
                } else {
                    if (this.hashableSinks == null) {
                        this.hashableSinks = new ObjectSinkNodeList();
                    }
                    this.hashableSinks.add(alphaNode);
                }
                return this;
            }
            if (this.isRangeIndexable(alphaNode)) {
                IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)alphaNode.getConstraint());
                InternalReadAccessor internalReadAccessor = indexableConstraint.getFieldExtractor();
                int index = internalReadAccessor.getIndex();
                FieldIndex fieldIndex = this.registerFieldIndexForRange(index, internalReadAccessor);
                FieldValue value = indexableConstraint.getField();
                if (fieldIndex.getCount() >= this.alphaNodeRangeIndexThreshold && this.alphaNodeRangeIndexThreshold != 0 && !value.isNull()) {
                    if (!fieldIndex.isRangeIndexed()) {
                        this.rangeIndexSinks(fieldIndex);
                    }
                    this.rangeIndexMap.get(fieldIndex).add(alphaNode);
                } else {
                    if (this.rangeIndexableSinks == null) {
                        this.rangeIndexableSinks = new ObjectSinkNodeList();
                    }
                    this.rangeIndexableSinks.add(alphaNode);
                }
                return this;
            }
        }
        if (this.otherSinks == null) {
            this.otherSinks = new ObjectSinkNodeList();
        }
        this.otherSinks.add((ObjectSinkNode)sink);
        return this;
    }

    static InternalReadAccessor getHashableAccessor(AlphaNode alphaNode) {
        IndexableConstraint indexableConstraint;
        AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
        if (fieldConstraint instanceof IndexableConstraint && CompositeObjectSinkAdapter.isHashable(indexableConstraint = (IndexableConstraint)((Object)fieldConstraint))) {
            return indexableConstraint.getFieldExtractor();
        }
        return null;
    }

    private static boolean isHashable(IndexableConstraint indexableConstraint) {
        return indexableConstraint.getConstraintType() == IndexUtil.ConstraintType.EQUAL && indexableConstraint.getField() != null && indexableConstraint.getFieldExtractor().getValueType() != ValueType.OBJECT_TYPE && indexableConstraint.getFieldExtractor().getIndex() >= 0;
    }

    @Override
    public ObjectSinkPropagator removeObjectSink(ObjectSink sink) {
        AlphaNode alphaNode;
        AlphaNodeFieldConstraint fieldConstraint;
        this.sinks = null;
        if (this.sinksMap != null) {
            this.sinksMap.remove(sink);
        }
        if (sink.getType() == 40 && (fieldConstraint = (alphaNode = (AlphaNode)sink).getConstraint()) instanceof IndexableConstraint) {
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)fieldConstraint);
            FieldValue value = indexableConstraint.getField();
            if (CompositeObjectSinkAdapter.isHashable(indexableConstraint)) {
                InternalReadAccessor fieldAccessor = indexableConstraint.getFieldExtractor();
                int index = fieldAccessor.getIndex();
                FieldIndex fieldIndex = this.unregisterFieldIndex(index);
                if (fieldIndex != null && fieldIndex.isHashed()) {
                    HashKey hashKey = new HashKey(index, value, fieldAccessor);
                    this.hashedSinkMap.remove(hashKey);
                    if (fieldIndex.getCount() <= this.alphaNodeHashingThreshold - 1) {
                        this.unHashSinks(fieldIndex);
                    }
                } else {
                    this.hashableSinks.remove(alphaNode);
                }
                if (this.hashableSinks != null && this.hashableSinks.isEmpty()) {
                    this.hashableSinks = null;
                }
                return this.size() == 1 ? new SingleObjectSinkAdapter(this.getSinks()[0]) : this;
            }
            if (this.isRangeIndexable(alphaNode)) {
                InternalReadAccessor fieldAccessor = indexableConstraint.getFieldExtractor();
                int index = fieldAccessor.getIndex();
                FieldIndex fieldIndex = this.unregisterFieldIndexForRange(index);
                if (fieldIndex.isRangeIndexed()) {
                    AlphaRangeIndex alphaRangeIndex = this.rangeIndexMap.get(fieldIndex);
                    alphaRangeIndex.remove(alphaNode);
                    if (fieldIndex.getCount() <= this.alphaNodeRangeIndexThreshold - 1) {
                        this.unRangeIndexSinks(fieldIndex, alphaRangeIndex);
                    }
                } else {
                    this.rangeIndexableSinks.remove(alphaNode);
                }
                if (this.rangeIndexableSinks != null && this.rangeIndexableSinks.isEmpty()) {
                    this.rangeIndexableSinks = null;
                }
                return this.size() == 1 ? new SingleObjectSinkAdapter(this.getSinks()[0]) : this;
            }
        }
        this.otherSinks.remove((ObjectSinkNode)sink);
        if (this.otherSinks.isEmpty()) {
            this.otherSinks = null;
        }
        return this.size() == 1 ? new SingleObjectSinkAdapter(this.getSinks()[0]) : this;
    }

    void hashSinks(FieldIndex fieldIndex) {
        if (this.hashedSinkMap == null) {
            this.hashedSinkMap = new ObjectHashMap();
        }
        int index = fieldIndex.getIndex();
        InternalReadAccessor fieldReader = fieldIndex.getFieldExtractor();
        for (ObjectSinkNode currentSink = this.hashableSinks.getFirst(); currentSink != null; currentSink = currentSink.getNextObjectSinkNode()) {
            AlphaNode alphaNode = (AlphaNode)currentSink;
            AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)fieldConstraint);
            if (index != indexableConstraint.getFieldExtractor().getIndex()) continue;
            FieldValue value = indexableConstraint.getField();
            this.hashedSinkMap.put(new HashKey(index, value, fieldReader), alphaNode);
            this.hashableSinks.remove(alphaNode);
        }
        if (this.hashableSinks.isEmpty()) {
            this.hashableSinks = null;
        }
        fieldIndex.setHashed(true);
    }

    void unHashSinks(FieldIndex fieldIndex) {
        int index = fieldIndex.getIndex();
        ArrayList<HashKey> unhashedSinks = new ArrayList<HashKey>();
        Iterator iter = this.hashedSinkMap.newIterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)iter.next();
        while (entry != null) {
            AlphaNode alphaNode = (AlphaNode)entry.getValue();
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)alphaNode.getConstraint());
            if (index == indexableConstraint.getFieldExtractor().getIndex()) {
                FieldValue value = indexableConstraint.getField();
                if (this.hashableSinks == null) {
                    this.hashableSinks = new ObjectSinkNodeList();
                }
                this.hashableSinks.add(alphaNode);
                unhashedSinks.add(new HashKey(index, value, fieldIndex.getFieldExtractor()));
            }
            entry = (ObjectHashMap.ObjectEntry)iter.next();
        }
        for (HashKey hashKey : unhashedSinks) {
            this.hashedSinkMap.remove(hashKey);
        }
        if (this.hashedSinkMap.isEmpty()) {
            this.hashedSinkMap = null;
        }
        fieldIndex.setHashed(false);
    }

    private FieldIndex registerFieldIndex(int index, InternalReadAccessor fieldExtractor) {
        FieldIndex fieldIndex = null;
        if (this.hashedFieldIndexes == null) {
            this.hashedFieldIndexes = new LinkedList();
            fieldIndex = new FieldIndex(index, fieldExtractor);
            this.hashedFieldIndexes.add(fieldIndex);
        }
        if (fieldIndex == null) {
            fieldIndex = this.findFieldIndex(index);
        }
        if (fieldIndex == null) {
            fieldIndex = new FieldIndex(index, fieldExtractor);
            this.hashedFieldIndexes.add(fieldIndex);
        }
        fieldIndex.increaseCounter();
        return fieldIndex;
    }

    private FieldIndex unregisterFieldIndex(int index) {
        FieldIndex fieldIndex = this.findFieldIndex(index);
        if (fieldIndex == null) {
            throw new IllegalStateException("Cannot find field index for index " + index + "!");
        }
        if (fieldIndex != null) {
            fieldIndex.decreaseCounter();
            if (fieldIndex.getCount() == 0) {
                this.hashedFieldIndexes.remove(fieldIndex);
                if (this.hashedFieldIndexes.isEmpty()) {
                    this.hashedFieldIndexes = null;
                }
            }
        }
        return fieldIndex;
    }

    private FieldIndex findFieldIndex(int index) {
        for (FieldIndex node = this.hashedFieldIndexes.getFirst(); node != null; node = node.getNext()) {
            if (node.getIndex() != index) continue;
            return node;
        }
        return null;
    }

    void rangeIndexSinks(FieldIndex fieldIndex) {
        if (this.rangeIndexMap == null) {
            this.rangeIndexMap = new HashMap<FieldIndex, AlphaRangeIndex>();
        }
        AlphaRangeIndex alphaRangeIndex = this.rangeIndexMap.computeIfAbsent(fieldIndex, AlphaRangeIndex::new);
        int index = fieldIndex.getIndex();
        if (this.rangeIndexableSinks != null) {
            for (ObjectSinkNode currentSink = this.rangeIndexableSinks.getFirst(); currentSink != null; currentSink = currentSink.getNextObjectSinkNode()) {
                AlphaNode alphaNode = (AlphaNode)currentSink;
                AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
                IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)fieldConstraint);
                if (index != indexableConstraint.getFieldExtractor().getIndex()) continue;
                alphaRangeIndex.add(alphaNode);
                this.rangeIndexableSinks.remove(alphaNode);
            }
            if (this.rangeIndexableSinks.isEmpty()) {
                this.rangeIndexableSinks = null;
            }
        }
        fieldIndex.setRangeIndexed(true);
    }

    void unRangeIndexSinks(FieldIndex fieldIndex, AlphaRangeIndex alphaRangeIndex) {
        if (this.rangeIndexableSinks == null) {
            this.rangeIndexableSinks = new ObjectSinkNodeList();
        }
        alphaRangeIndex.getAllValues().forEach(alphaNode -> this.rangeIndexableSinks.add((ObjectSinkNode)alphaNode));
        alphaRangeIndex.clear();
        this.rangeIndexMap.remove(fieldIndex);
        if (this.rangeIndexMap.isEmpty()) {
            this.rangeIndexMap = null;
        }
        fieldIndex.setRangeIndexed(false);
    }

    private boolean isRangeIndexable(AlphaNode alphaNode) {
        IndexableConstraint indexableConstraint;
        IndexUtil.ConstraintType constraintType;
        AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
        return fieldConstraint instanceof IndexableConstraint && ((constraintType = (indexableConstraint = (IndexableConstraint)((Object)fieldConstraint)).getConstraintType()).isAscending() || constraintType.isDescending()) && indexableConstraint.getField() != null && !indexableConstraint.getField().isNull() && indexableConstraint.getFieldExtractor().getValueType() != ValueType.OBJECT_TYPE && indexableConstraint.getFieldExtractor().getIndex() >= 0;
    }

    private FieldIndex registerFieldIndexForRange(int index, InternalReadAccessor fieldExtractor) {
        FieldIndex fieldIndex;
        if (this.rangeIndexedFieldIndexes == null) {
            this.rangeIndexedFieldIndexes = new LinkedList();
        }
        if ((fieldIndex = this.findFieldIndexForRange(index)) == null) {
            fieldIndex = new FieldIndex(index, fieldExtractor);
            this.rangeIndexedFieldIndexes.add(fieldIndex);
        }
        fieldIndex.increaseCounter();
        return fieldIndex;
    }

    private FieldIndex unregisterFieldIndexForRange(int index) {
        FieldIndex fieldIndex = this.findFieldIndexForRange(index);
        if (fieldIndex == null) {
            throw new IllegalStateException("Cannot find field index for index " + index + "!");
        }
        fieldIndex.decreaseCounter();
        if (fieldIndex.getCount() == 0) {
            this.rangeIndexedFieldIndexes.remove(fieldIndex);
        }
        if (this.rangeIndexedFieldIndexes.isEmpty()) {
            this.rangeIndexedFieldIndexes = null;
        }
        return fieldIndex;
    }

    private FieldIndex findFieldIndexForRange(int index) {
        if (this.rangeIndexedFieldIndexes == null) {
            return null;
        }
        for (FieldIndex node = this.rangeIndexedFieldIndexes.getFirst(); node != null; node = node.getNext()) {
            if (node.getIndex() != index) continue;
            return node;
        }
        return null;
    }

    @Override
    public void propagateAssertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectSinkNode sink;
        FieldIndex fieldIndex;
        Object object = factHandle.getObject();
        if (this.hashedFieldIndexes != null) {
            for (fieldIndex = this.hashedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = fieldIndex.getNext()) {
                AlphaNode sink2;
                if (!fieldIndex.isHashed() || (sink2 = (AlphaNode)this.hashedSinkMap.get(new HashKey(fieldIndex, object))) == null) continue;
                sink2.getObjectSinkPropagator().propagateAssertObject(factHandle, context, workingMemory);
            }
        }
        if (this.rangeIndexedFieldIndexes != null) {
            for (fieldIndex = this.rangeIndexedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = fieldIndex.getNext()) {
                if (!fieldIndex.isRangeIndexed()) continue;
                AlphaRangeIndex alphaRangeIndex = this.rangeIndexMap.get(fieldIndex);
                Collection<AlphaNode> alphaNodes = alphaRangeIndex.getMatchingAlphaNodes(object);
                for (AlphaNode sink3 : alphaNodes) {
                    sink3.getObjectSinkPropagator().propagateAssertObject(factHandle, context, workingMemory);
                }
            }
        }
        if (this.hashableSinks != null) {
            for (sink = this.hashableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.doPropagateAssertObject(factHandle, context, workingMemory, sink);
            }
        }
        if (this.rangeIndexableSinks != null) {
            for (sink = this.rangeIndexableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.doPropagateAssertObject(factHandle, context, workingMemory, sink);
            }
        }
        if (this.otherSinks != null) {
            for (sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.doPropagateAssertObject(factHandle, context, workingMemory, sink);
            }
        }
    }

    @Override
    public void propagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectSinkNode sink;
        FieldIndex fieldIndex;
        Object object = factHandle.getObject();
        if (this.hashedFieldIndexes != null) {
            for (fieldIndex = this.hashedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = fieldIndex.getNext()) {
                AlphaNode sink2;
                if (!fieldIndex.isHashed() || (sink2 = (AlphaNode)this.hashedSinkMap.get(new HashKey(fieldIndex, object))) == null) continue;
                sink2.getObjectSinkPropagator().propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
        if (this.rangeIndexedFieldIndexes != null) {
            for (fieldIndex = this.rangeIndexedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = fieldIndex.getNext()) {
                if (!fieldIndex.isRangeIndexed()) continue;
                AlphaRangeIndex alphaRangeIndex = this.rangeIndexMap.get(fieldIndex);
                Collection<AlphaNode> alphaNodes = alphaRangeIndex.getMatchingAlphaNodes(object);
                for (AlphaNode sink3 : alphaNodes) {
                    sink3.getObjectSinkPropagator().propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
                }
            }
        }
        if (this.hashableSinks != null) {
            for (sink = this.hashableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.doPropagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory, sink);
            }
        }
        if (this.rangeIndexableSinks != null) {
            for (sink = this.rangeIndexableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.doPropagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory, sink);
            }
        }
        if (this.otherSinks != null) {
            for (sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.doPropagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory, sink);
            }
        }
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectSinkNode sink;
        FieldIndex fieldIndex;
        Object object = factHandle.getObject();
        if (this.hashedFieldIndexes != null) {
            for (fieldIndex = this.hashedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = fieldIndex.getNext()) {
                AlphaNode sink2;
                if (!fieldIndex.isHashed() || (sink2 = (AlphaNode)this.hashedSinkMap.get(new HashKey(fieldIndex, object))) == null) continue;
                sink2.getObjectSinkPropagator().byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
        if (this.rangeIndexedFieldIndexes != null) {
            for (fieldIndex = this.rangeIndexedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = fieldIndex.getNext()) {
                if (!fieldIndex.isRangeIndexed()) continue;
                AlphaRangeIndex alphaRangeIndex = this.rangeIndexMap.get(fieldIndex);
                Collection<AlphaNode> alphaNodes = alphaRangeIndex.getMatchingAlphaNodes(object);
                for (AlphaNode sink3 : alphaNodes) {
                    sink3.getObjectSinkPropagator().byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
                }
            }
        }
        if (this.hashableSinks != null) {
            for (sink = this.hashableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                ((AlphaNode)sink).getObjectSinkPropagator().byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
        if (this.rangeIndexableSinks != null) {
            for (sink = this.rangeIndexableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                ((AlphaNode)sink).getObjectSinkPropagator().byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
        if (this.otherSinks != null) {
            for (sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
    }

    protected void doPropagateAssertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory, ObjectSink sink) {
        sink.assertObject(factHandle, context, workingMemory);
    }

    protected void doPropagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory, ObjectSink sink) {
        sink.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public BaseNode getMatchingNode(BaseNode candidate) {
        if (this.sinksMap == null) {
            this.reIndexNodes();
        }
        return (BaseNode)this.sinksMap.get(candidate);
    }

    public void reIndexNodes() {
        ObjectSinkNode sink2;
        this.sinksMap = new HashMap<NetworkNode, NetworkNode>();
        if (this.otherSinks != null) {
            for (sink2 = this.otherSinks.getFirst(); sink2 != null; sink2 = sink2.getNextObjectSinkNode()) {
                this.sinksMap.put(sink2, sink2);
            }
        }
        if (this.hashableSinks != null) {
            for (sink2 = this.hashableSinks.getFirst(); sink2 != null; sink2 = sink2.getNextObjectSinkNode()) {
                this.sinksMap.put(sink2, sink2);
            }
        }
        if (this.rangeIndexableSinks != null) {
            for (sink2 = this.rangeIndexableSinks.getFirst(); sink2 != null; sink2 = sink2.getNextObjectSinkNode()) {
                this.sinksMap.put(sink2, sink2);
            }
        }
        if (this.hashedSinkMap != null) {
            Iterator it = this.hashedSinkMap.newIterator();
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                ObjectSink sink3 = (ObjectSink)entry.getValue();
                this.sinksMap.put(sink3, sink3);
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
        }
        if (this.rangeIndexMap != null) {
            Collection<AlphaRangeIndex> alphaRangeIndexes = this.rangeIndexMap.values();
            for (AlphaRangeIndex alphaRangeIndex : alphaRangeIndexes) {
                Collection<AlphaNode> alphaNodes = alphaRangeIndex.getAllValues();
                alphaNodes.forEach(sink -> this.sinksMap.put((NetworkNode)sink, (NetworkNode)sink));
            }
        }
    }

    @Override
    public ObjectSink[] getSinks() {
        ObjectSinkNode sink;
        FieldIndex fieldIndex;
        if (this.sinks != null) {
            return this.sinks;
        }
        ObjectSink[] newSinks = new ObjectSink[this.size()];
        int at = 0;
        if (this.hashedFieldIndexes != null) {
            for (fieldIndex = this.hashedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = fieldIndex.getNext()) {
                if (!fieldIndex.isHashed()) continue;
                int index = fieldIndex.getIndex();
                Iterator it = this.hashedSinkMap.newIterator();
                ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
                while (entry != null) {
                    HashKey hashKey = (HashKey)entry.getKey();
                    if (hashKey.getIndex() == index) {
                        newSinks[at++] = (ObjectSink)entry.getValue();
                    }
                    entry = (ObjectHashMap.ObjectEntry)it.next();
                }
            }
        }
        if (this.rangeIndexedFieldIndexes != null) {
            for (fieldIndex = this.rangeIndexedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = fieldIndex.getNext()) {
                if (!fieldIndex.isRangeIndexed()) continue;
                Collection<AlphaNode> alphaNodes = this.rangeIndexMap.get(fieldIndex).getAllValues();
                for (AlphaNode sink2 : alphaNodes) {
                    newSinks[at++] = sink2;
                }
            }
        }
        if (this.hashableSinks != null) {
            for (sink = this.hashableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                newSinks[at++] = sink;
            }
        }
        if (this.rangeIndexableSinks != null) {
            for (sink = this.rangeIndexableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                newSinks[at++] = sink;
            }
        }
        if (this.otherSinks != null) {
            for (sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                newSinks[at++] = sink;
            }
        }
        this.sinks = newSinks;
        return newSinks;
    }

    @Override
    public void doLinkRiaNode(InternalWorkingMemory wm) {
        if (this.otherSinks != null) {
            for (ObjectSinkNode sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                SingleObjectSinkAdapter.staticDoLinkRiaNode(sink, wm);
            }
        }
    }

    @Override
    public void doUnlinkRiaNode(InternalWorkingMemory wm) {
        if (this.otherSinks != null) {
            for (ObjectSinkNode sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                SingleObjectSinkAdapter.staticDoUnlinkRiaNode(sink, wm);
            }
        }
    }

    @Override
    public int size() {
        return (this.otherSinks != null ? this.otherSinks.size() : 0) + (this.hashableSinks != null ? this.hashableSinks.size() : 0) + (this.hashedSinkMap != null ? this.hashedSinkMap.size() : 0) + (this.rangeIndexableSinks != null ? this.rangeIndexableSinks.size() : 0) + (this.rangeIndexMap != null ? this.rangeIndexMap.values().stream().map(AlphaRangeIndex::size).reduce(0, Integer::sum) : 0);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public ObjectSinkNodeList getOtherSinks() {
        return this.otherSinks;
    }

    public LinkedList<FieldIndex> getHashedFieldIndexes() {
        return this.hashedFieldIndexes;
    }

    public static class FieldIndex
    implements LinkedListNode<FieldIndex>,
    Externalizable {
        private static final long serialVersionUID = 510L;
        private int index;
        private InternalReadAccessor fieldExtactor;
        private int count;
        private boolean hashed;
        private boolean rangeIndexed;
        private FieldIndex previous;
        private FieldIndex next;

        public FieldIndex() {
        }

        public FieldIndex(int index, InternalReadAccessor fieldExtractor) {
            this.index = index;
            this.fieldExtactor = fieldExtractor;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index = in.readInt();
            this.fieldExtactor = (InternalReadAccessor)in.readObject();
            this.count = in.readInt();
            this.hashed = in.readBoolean();
            this.rangeIndexed = in.readBoolean();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.index);
            out.writeObject(this.fieldExtactor);
            out.writeInt(this.count);
            out.writeBoolean(this.hashed);
            out.writeBoolean(this.rangeIndexed);
        }

        public InternalReadAccessor getFieldExtractor() {
            return this.fieldExtactor;
        }

        public int getIndex() {
            return this.index;
        }

        public int getCount() {
            return this.count;
        }

        public ReadAccessor getFieldExtactor() {
            return this.fieldExtactor;
        }

        public boolean isHashed() {
            return this.hashed;
        }

        public void setHashed(boolean hashed) {
            this.hashed = hashed;
        }

        public boolean isRangeIndexed() {
            return this.rangeIndexed;
        }

        public void setRangeIndexed(boolean rangeIndexed) {
            this.rangeIndexed = rangeIndexed;
        }

        public void increaseCounter() {
            ++this.count;
        }

        public void decreaseCounter() {
            --this.count;
        }

        @Override
        public FieldIndex getNext() {
            return this.next;
        }

        @Override
        public FieldIndex getPrevious() {
            return this.previous;
        }

        @Override
        public void setNext(FieldIndex next) {
            this.next = next;
        }

        @Override
        public void setPrevious(FieldIndex previous) {
            this.previous = previous;
        }

        @Override
        public void nullPrevNext() {
            this.previous = null;
            this.next = null;
        }
    }

    public static class HashKey
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        private static final byte OBJECT = 1;
        private static final byte LONG = 2;
        private static final byte DOUBLE = 3;
        private static final byte BOOL = 4;
        private int index;
        private byte type;
        private Object ovalue;
        private long lvalue;
        private boolean bvalue;
        private double dvalue;
        private boolean isNull;
        private int hashCode;

        public HashKey() {
        }

        public HashKey(FieldIndex fieldIndex, Object value) {
            this.setValue(fieldIndex.getIndex(), value, fieldIndex.getFieldExtractor());
        }

        public HashKey(int index, FieldValue value, InternalReadAccessor extractor) {
            this.setValue(index, extractor, value);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index = in.readInt();
            this.type = in.readByte();
            this.ovalue = in.readObject();
            this.lvalue = in.readLong();
            this.bvalue = in.readBoolean();
            this.dvalue = in.readDouble();
            this.isNull = in.readBoolean();
            this.hashCode = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.index);
            out.writeByte(this.type);
            out.writeObject(this.ovalue);
            out.writeLong(this.lvalue);
            out.writeBoolean(this.bvalue);
            out.writeDouble(this.dvalue);
            out.writeBoolean(this.isNull);
            out.writeInt(this.hashCode);
        }

        public int getIndex() {
            return this.index;
        }

        public void setValue(int index, Object value, InternalReadAccessor extractor) {
            this.index = index;
            ValueType vtype = extractor.getValueType();
            this.isNull = extractor.isNullValue(null, value);
            if (vtype.isBoolean()) {
                this.type = (byte)4;
                if (!this.isNull) {
                    this.bvalue = extractor.getBooleanValue(null, value);
                    this.setHashCode(this.bvalue ? 1231 : 1237);
                } else {
                    this.setHashCode(0);
                }
            } else if (vtype.isIntegerNumber() || vtype.isChar()) {
                this.type = (byte)2;
                if (!this.isNull) {
                    this.lvalue = extractor.getLongValue(null, value);
                    this.setHashCode((int)(this.lvalue ^ this.lvalue >>> 32));
                } else {
                    this.setHashCode(0);
                }
            } else if (vtype.isFloatNumber()) {
                this.type = (byte)3;
                if (!this.isNull) {
                    this.dvalue = extractor.getDoubleValue(null, value);
                    long temp = Double.doubleToLongBits(this.dvalue);
                    this.setHashCode((int)(temp ^ temp >>> 32));
                } else {
                    this.setHashCode(0);
                }
            } else {
                this.type = 1;
                if (!this.isNull) {
                    this.ovalue = extractor.getValue(null, value);
                    this.setHashCode(this.ovalue != null ? this.ovalue.hashCode() : 0);
                } else {
                    this.setHashCode(0);
                }
            }
        }

        public void setValue(int index, InternalReadAccessor extractor, FieldValue value) {
            this.index = index;
            this.isNull = value.isNull();
            ValueType vtype = extractor.getValueType();
            if (vtype.isBoolean()) {
                this.type = (byte)4;
                if (!this.isNull) {
                    this.bvalue = value.getBooleanValue();
                    this.setHashCode(this.bvalue ? 1231 : 1237);
                } else {
                    this.setHashCode(0);
                }
            } else if (vtype.isIntegerNumber()) {
                this.type = (byte)2;
                if (!this.isNull) {
                    this.lvalue = value.getLongValue();
                    this.setHashCode((int)(this.lvalue ^ this.lvalue >>> 32));
                } else {
                    this.setHashCode(0);
                }
            } else if (vtype.isFloatNumber()) {
                this.type = (byte)3;
                if (!this.isNull) {
                    this.dvalue = value.getDoubleValue();
                    long temp = Double.doubleToLongBits(this.dvalue);
                    this.setHashCode((int)(temp ^ temp >>> 32));
                } else {
                    this.setHashCode(0);
                }
            } else {
                this.type = 1;
                if (!this.isNull) {
                    this.ovalue = vtype.coerce(value.getValue());
                    this.setHashCode(this.ovalue != null ? this.ovalue.hashCode() : 0);
                } else {
                    this.setHashCode(0);
                }
            }
        }

        private void setHashCode(int hashSeed) {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + hashSeed;
            this.hashCode = result = 31 * result + this.index;
        }

        public boolean getBooleanValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue;
                }
                case 1: {
                    if (this.ovalue == null) {
                        return false;
                    }
                    if (this.ovalue instanceof Boolean) {
                        return (Boolean)this.ovalue;
                    }
                    if (this.ovalue instanceof String) {
                        return Boolean.valueOf((String)this.ovalue);
                    }
                    throw new ClassCastException("Can't convert " + this.ovalue.getClass() + " to a boolean value.");
                }
                case 2: {
                    throw new ClassCastException("Can't convert long to a boolean value.");
                }
                case 3: {
                    throw new ClassCastException("Can't convert double to a boolean value.");
                }
            }
            return false;
        }

        public long getLongValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue ? 1L : 0L;
                }
                case 1: {
                    if (this.ovalue == null) {
                        return 0L;
                    }
                    if (this.ovalue instanceof Number) {
                        return ((Number)this.ovalue).longValue();
                    }
                    if (this.ovalue instanceof String) {
                        return Long.parseLong((String)this.ovalue);
                    }
                    throw new ClassCastException("Can't convert " + this.ovalue.getClass() + " to a long value.");
                }
                case 2: {
                    return this.lvalue;
                }
                case 3: {
                    return (long)this.dvalue;
                }
            }
            return 0L;
        }

        public double getDoubleValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue ? 1.0 : 0.0;
                }
                case 1: {
                    if (this.ovalue == null) {
                        return 0.0;
                    }
                    if (this.ovalue instanceof Number) {
                        return ((Number)this.ovalue).doubleValue();
                    }
                    if (this.ovalue instanceof String) {
                        return Double.parseDouble((String)this.ovalue);
                    }
                    throw new ClassCastException("Can't convert " + this.ovalue.getClass() + " to a double value.");
                }
                case 2: {
                    return this.lvalue;
                }
                case 3: {
                    return this.dvalue;
                }
            }
            return 0.0;
        }

        public Object getObjectValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue ? Boolean.TRUE : Boolean.FALSE;
                }
                case 1: {
                    return this.ovalue;
                }
                case 2: {
                    return this.lvalue;
                }
                case 3: {
                    return this.dvalue;
                }
            }
            return null;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof HashKey)) {
                return false;
            }
            HashKey other = (HashKey)object;
            if (this.isNull != other.isNull || this.index != other.index) {
                return false;
            }
            switch (this.type) {
                case 4: {
                    return this.bvalue == other.getBooleanValue();
                }
                case 2: {
                    return this.lvalue == other.getLongValue();
                }
                case 3: {
                    return this.dvalue == other.getDoubleValue();
                }
                case 1: {
                    Object otherValue = other.getObjectValue();
                    return this.ovalue == null ? otherValue == null : this.ovalue.equals(otherValue);
                }
            }
            return false;
        }
    }
}

