/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageBatch;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;

public class ActiveSpaceConfigStorageBatchContextRegistry {
    private static Map<Long, SpaceConfigStorageBatchContextImpl> activeContexts = new ConcurrentHashMap<Long, SpaceConfigStorageBatchContextImpl>();

    public static SpaceConfigStorageBatch.SpaceConfigStorageBatchContext getCurrentBatch(SpaceConfigStorage spaceConfigStorage, SpaceConfigStorageBatch ownerBatch) {
        return activeContexts.computeIfAbsent(ActiveSpaceConfigStorageBatchContextRegistry.getContextId(), contextId -> new SpaceConfigStorageBatchContextImpl(spaceConfigStorage, ownerBatch));
    }

    public static void clearCurrentBatch() {
        activeContexts.remove(ActiveSpaceConfigStorageBatchContextRegistry.getContextId());
    }

    private static Long getContextId() {
        return Thread.currentThread().getId();
    }

    private static class SpaceConfigStorageBatchContextImpl
    implements SpaceConfigStorageBatch.SpaceConfigStorageBatchContext {
        private final SpaceConfigStorage spaceConfigStorage;
        private final Object owner;
        private SpaceInfo info;

        public SpaceConfigStorageBatchContextImpl(SpaceConfigStorage spaceConfigStorage, Object owner) {
            this.spaceConfigStorage = spaceConfigStorage;
            this.owner = owner;
        }

        public SpaceInfo getSpaceInfo() {
            if (this.info == null) {
                this.info = this.spaceConfigStorage.loadSpaceInfo();
            }
            return this.info;
        }

        public Object getOwner() {
            return this.owner;
        }

        public void saveSpaceInfo() {
            this.spaceConfigStorage.saveSpaceInfo(this.info);
        }
    }
}

