/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AbstractBasicFileAttributeView;
import org.uberfire.java.nio.base.FileTimeImpl;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileTime;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.model.CommitHistory;
import org.uberfire.java.nio.fs.jgit.util.model.PathInfo;
import org.uberfire.java.nio.fs.jgit.util.model.PathType;

public class JGitBasicAttributeView
extends AbstractBasicFileAttributeView<JGitPathImpl> {
    private BasicFileAttributes attrs = null;

    public JGitBasicAttributeView(JGitPathImpl path) {
        super((Path)path);
    }

    public BasicFileAttributes readAttributes() throws IOException {
        if (this.attrs == null) {
            this.attrs = this.buildAttrs((JGitFileSystem)((JGitPathImpl)this.path).getFileSystem(), ((JGitPathImpl)this.path).getRefTree(), ((JGitPathImpl)this.path).getPath());
        }
        return this.attrs;
    }

    public Class<? extends BasicFileAttributeView>[] viewTypes() {
        return new Class[]{BasicFileAttributeView.class, JGitBasicAttributeView.class};
    }

    private BasicFileAttributes buildAttrs(JGitFileSystem fs, String branchName, String path) {
        final PathInfo pathInfo = fs.getGit().getPathInfo(branchName, path);
        if (pathInfo == null || pathInfo.getPathType().equals((Object)PathType.NOT_FOUND)) {
            throw new NoSuchFileException(path);
        }
        Ref ref = fs.getGit().getRef(branchName);
        final ArrayList<Date> records = new ArrayList<Date>();
        if (ref != null) {
            try {
                CommitHistory history = fs.getGit().listCommits(ref, pathInfo.getPath());
                for (RevCommit commit : history.getCommits()) {
                    records.add(commit.getAuthorIdent().getWhen());
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return new BasicFileAttributes(){

            public FileTime lastModifiedTime() {
                if (!records.isEmpty()) {
                    return new FileTimeImpl(((Date)records.get(0)).getTime());
                }
                return new FileTimeImpl(0L);
            }

            public FileTime lastAccessTime() {
                return this.lastModifiedTime();
            }

            public FileTime creationTime() {
                if (!records.isEmpty()) {
                    return new FileTimeImpl(((Date)records.get(records.size() - 1)).getTime());
                }
                return new FileTimeImpl(0L);
            }

            public boolean isRegularFile() {
                return pathInfo.getPathType().equals((Object)PathType.FILE);
            }

            public boolean isDirectory() {
                return pathInfo.getPathType().equals((Object)PathType.DIRECTORY);
            }

            public boolean isSymbolicLink() {
                return false;
            }

            public boolean isOther() {
                return false;
            }

            public long size() {
                return pathInfo.getSize();
            }

            public Object fileKey() {
                return pathInfo.getObjectId() == null ? null : pathInfo.getObjectId().toString();
            }
        };
    }
}

