/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.BranchUtil;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class ConflictBranchesChecker {
    private final Git git;
    private final String branchA;
    private final String branchB;

    public ConflictBranchesChecker(Git git, String branchA, String branchB) {
        this.git = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.branchA = PortablePreconditions.checkNotEmpty((String)"branchA", (String)branchA);
        this.branchB = PortablePreconditions.checkNotEmpty((String)"branchB", (String)branchB);
    }

    public List<String> execute() {
        BranchUtil.existsBranch(this.git, this.branchA);
        BranchUtil.existsBranch(this.git, this.branchB);
        ArrayList<String> result = new ArrayList<String>();
        try {
            RevCommit commitA = this.git.getLastCommit(this.branchA);
            RevCommit commitB = this.git.getLastCommit(this.branchB);
            RevCommit commonAncestor = this.git.getCommonAncestorCommit(this.branchA, this.branchB);
            ThreeWayMerger merger = MergeStrategy.RECURSIVE.newMerger(this.git.getRepository(), true);
            merger.setBase((AnyObjectId)commonAncestor);
            boolean canMerge = merger.merge(new AnyObjectId[]{commitA, commitB});
            if (!canMerge) {
                ResolveMerger resolveMerger = (ResolveMerger)merger;
                Map mergeResults = resolveMerger.getMergeResults();
                result.addAll(mergeResults.keySet().stream().sorted(String::compareToIgnoreCase).collect(Collectors.toList()));
            }
        }
        catch (IOException e) {
            throw new GitException(String.format("Error when checking for conflicts between branches %s and %s: %s", this.branchA, this.branchB, e));
        }
        return result;
    }
}

