/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.quad;

import java.util.Objects;
import java.util.function.Function;
import org.drools.model.Variable;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupBy;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupByAccumulator;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadGroupBy;

public class DroolsQuadGroupByAccumulator<A, B, C, D, NewA, NewB, NewC, NewD>
extends DroolsAbstractGroupByAccumulator<QuadTuple<A, B, C, D>> {
    private final QuadFunction<A, B, C, D, NewA> groupKeyAMapping;
    private final QuadFunction<A, B, C, D, NewB> groupKeyBMapping;
    private final QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC;
    private final QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD;
    private final Variable<A> aVariable;
    private final Variable<B> bVariable;
    private final Variable<C> cVariable;
    private final Variable<D> dVariable;

    public DroolsQuadGroupByAccumulator(QuadFunction<A, B, C, D, NewA> groupKeyAMapping, QuadFunction<A, B, C, D, NewB> groupKeyBMapping, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC, QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD, Variable<A> aVariable, Variable<B> bVariable, Variable<C> cVariable, Variable<D> dVariable) {
        this.groupKeyAMapping = Objects.requireNonNull(groupKeyAMapping);
        this.groupKeyBMapping = Objects.requireNonNull(groupKeyBMapping);
        this.collectorC = Objects.requireNonNull(collectorC);
        this.collectorD = Objects.requireNonNull(collectorD);
        this.aVariable = Objects.requireNonNull(aVariable);
        this.bVariable = Objects.requireNonNull(bVariable);
        this.cVariable = Objects.requireNonNull(cVariable);
        this.dVariable = Objects.requireNonNull(dVariable);
    }

    @Override
    protected DroolsAbstractGroupBy<QuadTuple<A, B, C, D>, ?> newContext() {
        return new DroolsQuadGroupBy<A, B, C, D, NewA, NewB, NewC, NewD>(this.groupKeyAMapping, this.groupKeyBMapping, this.collectorC, this.collectorD);
    }

    @Override
    protected <X> QuadTuple<A, B, C, D> createInput(Function<Variable<X>, X> valueFinder) {
        A a = DroolsQuadGroupByAccumulator.materialize(this.aVariable, valueFinder);
        B b = DroolsQuadGroupByAccumulator.materialize(this.bVariable, valueFinder);
        C c = DroolsQuadGroupByAccumulator.materialize(this.cVariable, valueFinder);
        D d = DroolsQuadGroupByAccumulator.materialize(this.dVariable, valueFinder);
        return new QuadTuple<A, B, C, D>(a, b, c, d);
    }
}

