/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.audit;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;

@Entity
@SequenceGenerator(name="caseRoleAssignLogIdSeq", sequenceName="CASE_ROLE_ASSIGN_LOG_ID_SEQ", allocationSize=1)
public class CaseRoleAssignmentLog
implements Serializable {
    private static final long serialVersionUID = 5757703502285633210L;
    private static final int USER_TYPE = 1;
    private static final int GROUP_TYPE = 2;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="caseRoleAssignLogIdSeq")
    private long id;
    private long processInstanceId;
    private String caseId;
    private String roleName;
    private String entityId;
    private int type;

    public CaseRoleAssignmentLog() {
    }

    public CaseRoleAssignmentLog(long processInstanceId, String caseId, String roleName, OrganizationalEntity entity) {
        this.processInstanceId = processInstanceId;
        this.caseId = caseId;
        this.roleName = roleName;
        this.entityId = entity.getId();
        if (entity instanceof User) {
            this.type = 1;
        } else if (entity instanceof Group) {
            this.type = 2;
        }
    }

    public long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getCaseId() {
        return this.caseId;
    }

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.caseId == null ? 0 : this.caseId.hashCode());
        result = 31 * result + (this.entityId == null ? 0 : this.entityId.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.processInstanceId ^ this.processInstanceId >>> 32);
        result = 31 * result + (this.roleName == null ? 0 : this.roleName.hashCode());
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CaseRoleAssignmentLog other = (CaseRoleAssignmentLog)obj;
        if (this.caseId == null ? other.caseId != null : !this.caseId.equals(other.caseId)) {
            return false;
        }
        if (this.entityId == null ? other.entityId != null : !this.entityId.equals(other.entityId)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.processInstanceId != other.processInstanceId) {
            return false;
        }
        if (this.roleName == null ? other.roleName != null : !this.roleName.equals(other.roleName)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "CaseRoleAssignmentLog [processInstanceId=" + this.processInstanceId + ", caseId=" + this.caseId + ", roleName=" + this.roleName + ", entityId=" + this.entityId + ", type=" + this.type + "]";
    }
}

