/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.List;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.TupleSets;
import org.drools.core.common.TupleSetsImpl;
import org.drools.core.phreak.PhreakAccumulateNode;
import org.drools.core.phreak.PhreakAsyncReceiveNode;
import org.drools.core.phreak.PhreakAsyncSendNode;
import org.drools.core.phreak.PhreakBranchNode;
import org.drools.core.phreak.PhreakEvalNode;
import org.drools.core.phreak.PhreakExistsNode;
import org.drools.core.phreak.PhreakFromNode;
import org.drools.core.phreak.PhreakJoinNode;
import org.drools.core.phreak.PhreakNetworkNodeFactory;
import org.drools.core.phreak.PhreakNotNode;
import org.drools.core.phreak.PhreakQueryNode;
import org.drools.core.phreak.PhreakQueryTerminalNode;
import org.drools.core.phreak.PhreakReactiveFromNode;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.SegmentPropagator;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.AsyncSendNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.ReactiveFromNode;
import org.drools.core.reteoo.RiaPathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.Tuple;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleNetworkEvaluator {
    private static final Logger log = LoggerFactory.getLogger(RuleNetworkEvaluator.class);
    public static final RuleNetworkEvaluator INSTANCE = new RuleNetworkEvaluator();
    private static final PhreakJoinNode pJoinNode = PhreakNetworkNodeFactory.Factory.get().createPhreakJoinNode();
    private static final PhreakEvalNode pEvalNode = PhreakNetworkNodeFactory.Factory.get().createPhreakEvalNode();
    private static final PhreakFromNode pFromNode = PhreakNetworkNodeFactory.Factory.get().createPhreakFromNode();
    private static final PhreakReactiveFromNode pReactiveFromNode = PhreakNetworkNodeFactory.Factory.get().createPhreakReactiveFromNode();
    private static final PhreakNotNode pNotNode = PhreakNetworkNodeFactory.Factory.get().createPhreakNotNode();
    private static final PhreakExistsNode pExistsNode = PhreakNetworkNodeFactory.Factory.get().createPhreakExistsNode();
    private static final PhreakAccumulateNode pAccNode = PhreakNetworkNodeFactory.Factory.get().createPhreakAccumulateNode();
    private static final PhreakBranchNode pBranchNode = PhreakNetworkNodeFactory.Factory.get().createPhreakBranchNode();
    private static final PhreakQueryNode pQueryNode = PhreakNetworkNodeFactory.Factory.get().createPhreakQueryNode();
    private static final PhreakTimerNode pTimerNode = PhreakNetworkNodeFactory.Factory.get().createPhreakTimerNode();
    private static final PhreakAsyncSendNode pSendNode = PhreakNetworkNodeFactory.Factory.get().createPhreakAsyncSendNode();
    private static final PhreakAsyncReceiveNode pReceiveNode = PhreakNetworkNodeFactory.Factory.get().createPhreakAsyncReceiveNode();
    private static final PhreakRuleTerminalNode pRtNode = PhreakNetworkNodeFactory.Factory.get().createPhreakRuleTerminalNode();
    private static PhreakQueryTerminalNode pQtNode = PhreakNetworkNodeFactory.Factory.get().createPhreakQueryTerminalNode();
    private static int cycle = 0;

    private RuleNetworkEvaluator() {
    }

    public void evaluateNetwork(PathMemory pmem, RuleExecutor executor, InternalWorkingMemory wm) {
        this.evaluateNetwork(pmem, executor, pmem.getActualAgenda(wm));
    }

    public void evaluateNetwork(PathMemory pmem, RuleExecutor executor, InternalAgenda agenda) {
        Memory nodeMem;
        LeftTupleNode node;
        boolean firstSegmentIsOnlyLia;
        SegmentMemory[] smems = pmem.getSegmentMemories();
        SegmentMemory smem = smems[0];
        if (smem == null) {
            return;
        }
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)smem.getRootNode();
        LinkedList<StackEntry> stack = new LinkedList<StackEntry>();
        boolean bl = firstSegmentIsOnlyLia = liaNode == smem.getTipNode();
        if (firstSegmentIsOnlyLia) {
            smem = smems[1];
            node = smem.getRootNode();
            nodeMem = smem.getNodeMemories().getFirst();
        } else {
            node = liaNode.getSinkPropagator().getFirstLeftTupleSink();
            nodeMem = (Memory)smem.getNodeMemories().getFirst().getNext();
        }
        TupleSets<LeftTuple> srcTuples = smem.getStagedLeftTuples();
        if (log.isTraceEnabled()) {
            log.trace("Rule[name={}] segments={} {}", new Object[]{((TerminalNode)((Object)pmem.getPathEndNode())).getRule().getName(), smems.length, srcTuples.toStringSizes()});
        }
        this.outerEval(pmem, node, firstSegmentIsOnlyLia ? 1L : 2L, nodeMem, smems, firstSegmentIsOnlyLia ? 1 : 0, srcTuples, agenda, stack, true, executor);
    }

    public static String indent(int size) {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sbuilder.append("  ");
        }
        return sbuilder.toString();
    }

    public static int getOffset(NetworkNode node) {
        LeftTupleSource lt;
        int offset = 1;
        if (NodeTypeEnums.isTerminalNode(node)) {
            lt = ((TerminalNode)node).getLeftTupleSource();
            ++offset;
        } else {
            lt = node.getType() == 71 ? ((RightInputAdapterNode)node).getLeftTupleSource() : (LeftTupleSource)node;
        }
        while (lt.getType() != 120) {
            ++offset;
            lt = lt.getLeftTupleSource();
        }
        return offset;
    }

    public void outerEval(PathMemory pmem, NetworkNode node, long bit, Memory nodeMem, SegmentMemory[] smems, int smemIndex, TupleSets<LeftTuple> trgTuples, InternalAgenda agenda, LinkedList<StackEntry> stack, boolean processRian, RuleExecutor executor) {
        this.innerEval(pmem, node, bit, nodeMem, smems, smemIndex, trgTuples, agenda, stack, processRian, executor);
        while (!stack.isEmpty()) {
            StackEntry entry = stack.removeLast();
            this.evalStackEntry(entry, stack, executor, agenda);
        }
    }

    public void evalStackEntry(StackEntry entry, LinkedList<StackEntry> stack, RuleExecutor executor, InternalAgenda agenda) {
        NetworkNode node = entry.getNode();
        Memory nodeMem = entry.getNodeMem();
        TupleSets<LeftTuple> trgTuples = entry.getTrgTuples();
        if (node.getType() == 165) {
            QueryElementNode.QueryElementNodeMemory qmem = (QueryElementNode.QueryElementNodeMemory)nodeMem;
            qmem.setNodeCleanWithoutNotify();
            qmem.getResultLeftTuples().addTo(trgTuples);
        }
        LeftTupleSinkNode sink = entry.getSink();
        PathMemory pmem = entry.getRmem();
        SegmentMemory[] smems = entry.getSmems();
        int smemIndex = entry.getSmemIndex();
        boolean processRian = entry.isProcessRian();
        long bit = entry.getBit();
        if (entry.isResumeFromNextNode()) {
            SegmentMemory smem = smems[smemIndex];
            if (node != smem.getTipNode()) {
                LeftTupleSinkNode nextSink = sink.getNextLeftTupleSinkNode();
                node = nextSink == null ? sink : nextSink;
                nodeMem = (Memory)nodeMem.getNext();
                bit <<= 1;
            } else {
                SegmentPropagator.propagate(smem, trgTuples, agenda.getWorkingMemory());
                smem = smems[++smemIndex];
                trgTuples = smem.getStagedLeftTuples().takeAll();
                node = smem.getRootNode();
                nodeMem = smem.getNodeMemories().getFirst();
                bit = 1L;
            }
        }
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(node);
            log.trace("{} Resume {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), node.toString(), trgTuples.toStringSizes()});
        }
        this.innerEval(pmem, node, bit, nodeMem, smems, smemIndex, trgTuples, agenda, stack, processRian, executor);
    }

    public void innerEval(PathMemory pmem, NetworkNode node, long bit, Memory nodeMem, SegmentMemory[] smems, int smemIndex, TupleSets<LeftTuple> trgTuples, InternalAgenda agenda, LinkedList<StackEntry> stack, boolean processRian, RuleExecutor executor) {
        SegmentMemory smem = smems[smemIndex];
        TupleSets<LeftTuple> stagedLeftTuples = null;
        while (true) {
            LeftTupleSinkNode sink;
            TupleSets<LeftTuple> srcTuples = trgTuples;
            if (log.isTraceEnabled()) {
                int offset = RuleNetworkEvaluator.getOffset(node);
                log.trace("{} {} {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), ++cycle, node.toString(), srcTuples.toStringSizes()});
            }
            boolean emptySrcTuples = srcTuples.isEmpty();
            if (!NodeTypeEnums.isBetaNode(node) || !((BetaNode)node).isRightInputIsRiaNode()) {
                if (emptySrcTuples && smem.getDirtyNodeMask() == 0L) {
                    boolean foundDirty = false;
                    int length = smems.length;
                    for (int i = ++smemIndex; i < length; ++i) {
                        if (log.isTraceEnabled()) {
                            int offset = RuleNetworkEvaluator.getOffset(node);
                            log.trace("{} Skip Segment {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)(i - 1));
                        }
                        if (smem.isEmpty() && !NodeTypeEnums.isTerminalNode(smem.getTipNode())) {
                            SegmentUtilities.createChildSegments(agenda.getWorkingMemory(), smem, ((LeftTupleSource)smem.getTipNode()).getSinkPropagator());
                        }
                        smem = smems[i];
                        bit = 1L;
                        srcTuples = smem.getStagedLeftTuples().takeAll();
                        emptySrcTuples = srcTuples.isEmpty();
                        node = smem.getRootNode();
                        nodeMem = smem.getNodeMemories().getFirst();
                        if (emptySrcTuples && smem.getDirtyNodeMask() == 0L && (!NodeTypeEnums.isBetaNode(node) || !((BetaNode)node).isRightInputIsRiaNode())) continue;
                        foundDirty = true;
                        smemIndex = i;
                        break;
                    }
                    if (!foundDirty) break;
                }
                if (log.isTraceEnabled()) {
                    int offset = RuleNetworkEvaluator.getOffset(node);
                    log.trace("{} Segment {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)smemIndex);
                    log.trace("{} {} {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), cycle, node.toString(), srcTuples.toStringSizes()});
                }
            }
            long dirtyMask = smem.getDirtyNodeMask();
            if (emptySrcTuples) {
                while (!((dirtyMask & bit) != 0L || node == smem.getTipNode() || NodeTypeEnums.isBetaNode(node) && ((BetaNode)node).isRightInputIsRiaNode())) {
                    if (log.isTraceEnabled()) {
                        int offset = RuleNetworkEvaluator.getOffset(node);
                        log.trace("{} Skip Node {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)node);
                    }
                    bit <<= 1;
                    node = ((LeftTupleSource)node).getSinkPropagator().getFirstLeftTupleSink();
                    nodeMem = (Memory)nodeMem.getNext();
                }
            }
            boolean terminalNode = true;
            switch (node.getType()) {
                case 101: {
                    pRtNode.doNode((TerminalNode)node, agenda, srcTuples, executor);
                    break;
                }
                case 91: {
                    pQtNode.doNode((QueryTerminalNode)node, agenda, srcTuples, stack);
                    break;
                }
                case 71: {
                    this.doRiaNode2(agenda.getWorkingMemory(), srcTuples, (RightInputAdapterNode)node);
                    break;
                }
                default: {
                    terminalNode = false;
                }
            }
            if (terminalNode || (trgTuples = this.evalNode(pmem, node, bit, nodeMem, smems, smemIndex, agenda, stack, processRian, executor, srcTuples, smem, stagedLeftTuples = RuleNetworkEvaluator.getTargetStagedLeftTuples(node, agenda.getWorkingMemory(), smem), sink = ((LeftTupleSource)node).getSinkPropagator().getFirstLeftTupleSink())) == null) break;
            if (node != smem.getTipNode()) {
                node = sink;
                nodeMem = (Memory)nodeMem.getNext();
                bit <<= 1;
            } else {
                ((SegmentMemory)smem.getFirst()).getStagedLeftTuples().addAll(stagedLeftTuples);
                SegmentPropagator.propagate(smem, trgTuples, agenda.getWorkingMemory());
                bit = 1L;
                smem = smems[++smemIndex];
                trgTuples = smem.getStagedLeftTuples().takeAll();
                if (log.isTraceEnabled()) {
                    int offset = RuleNetworkEvaluator.getOffset(node);
                    log.trace("{} Segment {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)smemIndex);
                }
                node = smem.getRootNode();
                nodeMem = smem.getNodeMemories().getFirst();
            }
            processRian = true;
        }
        if (stagedLeftTuples != null && !stagedLeftTuples.isEmpty()) {
            ((SegmentMemory)smem.getFirst()).getStagedLeftTuples().addAll(stagedLeftTuples);
        }
    }

    public TupleSets<LeftTuple> evalNode(PathMemory pmem, NetworkNode node, long bit, Memory nodeMem, SegmentMemory[] smems, int smemIndex, InternalAgenda agenda, LinkedList<StackEntry> stack, boolean processRian, RuleExecutor executor, TupleSets<LeftTuple> srcTuples, SegmentMemory smem, TupleSets<LeftTuple> stagedLeftTuples, LeftTupleSinkNode sink) {
        TupleSetsImpl<LeftTuple> trgTuples = new TupleSetsImpl<LeftTuple>();
        if (NodeTypeEnums.isBetaNode(node)) {
            boolean exitInnerEval = this.evalBetaNode(pmem, node, nodeMem, smems, smemIndex, trgTuples, agenda, stack, processRian, executor, srcTuples, stagedLeftTuples, sink);
            if (exitInnerEval) {
                return null;
            }
        } else {
            boolean exitInnerEval = false;
            switch (node.getType()) {
                case 131: {
                    pEvalNode.doNode((EvalConditionNode)node, (EvalConditionNode.EvalMemory)nodeMem, sink, agenda.getWorkingMemory(), srcTuples, trgTuples, stagedLeftTuples);
                    break;
                }
                case 151: {
                    pFromNode.doNode((FromNode)node, (FromNode.FromMemory)nodeMem, sink, agenda.getWorkingMemory(), srcTuples, trgTuples, stagedLeftTuples);
                    break;
                }
                case 153: {
                    pReactiveFromNode.doNode((ReactiveFromNode)node, (ReactiveFromNode.ReactiveFromMemory)nodeMem, (LeftTupleSink)sink, agenda.getWorkingMemory(), srcTuples, trgTuples, stagedLeftTuples);
                    break;
                }
                case 165: {
                    exitInnerEval = this.evalQueryNode(pmem, node, bit, nodeMem, smems, smemIndex, trgTuples, agenda.getWorkingMemory(), stack, srcTuples, sink, stagedLeftTuples);
                    break;
                }
                case 133: {
                    pTimerNode.doNode((TimerNode)node, (TimerNode.TimerNodeMemory)nodeMem, pmem, smem, sink, agenda, srcTuples, trgTuples, stagedLeftTuples);
                    break;
                }
                case 167: {
                    pBranchNode.doNode((ConditionalBranchNode)node, (ConditionalBranchNode.ConditionalBranchMemory)nodeMem, sink, agenda, srcTuples, trgTuples, stagedLeftTuples, executor);
                    break;
                }
                case 135: {
                    pSendNode.doNode((AsyncSendNode)node, (AsyncSendNode.AsyncSendMemory)nodeMem, agenda.getWorkingMemory(), srcTuples);
                    break;
                }
                case 137: {
                    pReceiveNode.doNode((AsyncReceiveNode)node, (AsyncReceiveNode.AsyncReceiveMemory)nodeMem, sink, agenda.getWorkingMemory(), srcTuples, trgTuples);
                }
            }
            if (exitInnerEval && trgTuples.isEmpty()) {
                return null;
            }
        }
        return trgTuples;
    }

    private static TupleSets<LeftTuple> getTargetStagedLeftTuples(NetworkNode node, InternalWorkingMemory wm, SegmentMemory smem) {
        if (node == smem.getTipNode()) {
            if (smem.isEmpty()) {
                SegmentUtilities.createChildSegments(wm, smem, ((LeftTupleSource)node).getSinkPropagator());
            }
            return ((SegmentMemory)smem.getFirst()).getStagedLeftTuples().takeAll();
        }
        return null;
    }

    private boolean evalQueryNode(PathMemory pmem, NetworkNode node, long bit, Memory nodeMem, SegmentMemory[] smems, int smemIndex, TupleSets<LeftTuple> trgTuples, InternalWorkingMemory wm, LinkedList<StackEntry> stack, TupleSets<LeftTuple> srcTuples, LeftTupleSinkNode sink, TupleSets<LeftTuple> stagedLeftTuples) {
        QueryElementNode.QueryElementNodeMemory qmem = (QueryElementNode.QueryElementNodeMemory)nodeMem;
        if (srcTuples.isEmpty() && qmem.getResultLeftTuples().isEmpty()) {
            return false;
        }
        QueryElementNode qnode = (QueryElementNode)node;
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(node);
            log.trace("{} query result tuples {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)qmem.getResultLeftTuples().toStringSizes());
        }
        qmem.getResultLeftTuples().addTo(trgTuples);
        qmem.setNodeCleanWithoutNotify();
        if (!srcTuples.isEmpty()) {
            StackEntry stackEntry = new StackEntry(node, bit, sink, pmem, nodeMem, smems, smemIndex, trgTuples, true, true);
            stack.add(stackEntry);
            pQueryNode.doNode(qnode, (QueryElementNode.QueryElementNodeMemory)nodeMem, stackEntry, wm, srcTuples, trgTuples, stagedLeftTuples);
            SegmentMemory qsmem = ((QueryElementNode.QueryElementNodeMemory)nodeMem).getQuerySegmentMemory();
            List<PathMemory> qpmems = qsmem.getPathMemories();
            for (int i = 0; i < qpmems.size(); ++i) {
                PathMemory qpmem;
                pmem = qpmem = qpmems.get(i);
                smems = qpmem.getSegmentMemories();
                smemIndex = 0;
                SegmentMemory smem = smems[smemIndex];
                LeftInputAdapterNode liaNode = (LeftInputAdapterNode)qpmem.getPathEndNode().getPathNodes()[0];
                if (liaNode == smem.getTipNode()) {
                    smem = smems[++smemIndex];
                    node = smem.getRootNode();
                    nodeMem = smem.getNodeMemories().getFirst();
                    bit = 1L;
                } else {
                    node = liaNode.getSinkPropagator().getFirstLeftTupleSink();
                    nodeMem = (Memory)smem.getNodeMemories().getFirst().getNext();
                    bit = 2L;
                }
                trgTuples = smem.getStagedLeftTuples().takeAll();
                stackEntry = new StackEntry(node, bit, null, pmem, nodeMem, smems, smemIndex, trgTuples, false, true);
                if (log.isTraceEnabled()) {
                    int offset = RuleNetworkEvaluator.getOffset(stackEntry.getNode());
                    log.trace("{} ORQueue branch={} {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), i, stackEntry.getNode().toString(), trgTuples.toStringSizes()});
                }
                stack.add(stackEntry);
            }
            return true;
        }
        return false;
    }

    private boolean evalBetaNode(PathMemory pmem, NetworkNode node, Memory nodeMem, SegmentMemory[] smems, int smemIndex, TupleSets<LeftTuple> trgTuples, InternalAgenda agenda, LinkedList<StackEntry> stack, boolean processRian, RuleExecutor executor, TupleSets<LeftTuple> srcTuples, TupleSets<LeftTuple> stagedLeftTuples, LeftTupleSinkNode sink) {
        BetaMemory bm;
        BetaNode betaNode = (BetaNode)node;
        AccumulateNode.AccumulateMemory am = null;
        if (211 == node.getType()) {
            am = (AccumulateNode.AccumulateMemory)nodeMem;
            bm = am.getBetaMemory();
        } else {
            bm = (BetaMemory)nodeMem;
        }
        if (processRian && betaNode.isRightInputIsRiaNode()) {
            this.doRiaNode(agenda, pmem, srcTuples, betaNode, sink, smems, smemIndex, nodeMem, bm, stack, executor);
            return true;
        }
        this.switchOnDoBetaNode(node, trgTuples, agenda.getWorkingMemory(), srcTuples, stagedLeftTuples, sink, bm, am);
        return false;
    }

    private void switchOnDoBetaNode(NetworkNode node, TupleSets<LeftTuple> trgTuples, InternalWorkingMemory wm, TupleSets<LeftTuple> srcTuples, TupleSets<LeftTuple> stagedLeftTuples, LeftTupleSinkNode sink, BetaMemory bm, AccumulateNode.AccumulateMemory am) {
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(node);
            log.trace("{} rightTuples {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)bm.getStagedRightTuples().toStringSizes());
        }
        switch (node.getType()) {
            case 181: {
                pJoinNode.doNode((JoinNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                break;
            }
            case 191: {
                pNotNode.doNode((NotNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                break;
            }
            case 201: {
                pExistsNode.doNode((ExistsNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                break;
            }
            case 211: {
                pAccNode.doNode((AccumulateNode)node, sink, am, wm, srcTuples, trgTuples, stagedLeftTuples);
            }
        }
    }

    private void doRiaNode(InternalAgenda agenda, PathMemory pmem, TupleSets<LeftTuple> srcTuples, BetaNode betaNode, LeftTupleSinkNode sink, SegmentMemory[] smems, int smemIndex, Memory nodeMem, BetaMemory bm, LinkedList<StackEntry> stack, RuleExecutor executor) {
        RiaPathMemory pathMem = bm.getRiaRuleMemory();
        SegmentMemory[] subnetworkSmems = pathMem.getSegmentMemories();
        SegmentMemory subSmem = null;
        int i = 0;
        while (subSmem == null) {
            subSmem = subnetworkSmems[i];
            ++i;
        }
        StackEntry stackEntry = new StackEntry(betaNode, bm.getNodePosMaskBit(), sink, pmem, nodeMem, smems, smemIndex, srcTuples, false, false);
        stack.add(stackEntry);
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(betaNode);
            log.trace("{} RiaQueue {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), betaNode.toString(), srcTuples.toStringSizes()});
        }
        TupleSets<LeftTuple> subLts = subSmem.getStagedLeftTuples().takeAll();
        this.innerEval(pathMem, subSmem.getRootNode(), 1L, subSmem.getNodeMemories().getFirst(), subnetworkSmems, subSmem.getPos(), subLts, agenda, stack, true, executor);
    }

    private void doRiaNode2(InternalWorkingMemory wm, TupleSets<LeftTuple> srcTuples, RightInputAdapterNode riaNode) {
        int i;
        SubnetworkTuple next;
        ObjectSink[] sinks = riaNode.getObjectSinkPropagator().getSinks();
        BetaNode betaNode = (BetaNode)sinks[0];
        Object nodeMem = wm.getNodeMemory(betaNode);
        BetaMemory bm = 211 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)nodeMem).getBetaMemory() : (BetaMemory)nodeMem;
        TupleSets<RightTuple> rightTuples = bm.getStagedRightTuples();
        BetaNode[] bns = null;
        BetaMemory[] bms = null;
        int length = sinks.length;
        if (length > 1) {
            bns = new BetaNode[sinks.length - 1];
            bms = new BetaMemory[sinks.length - 1];
            for (int i2 = 1; i2 < length; ++i2) {
                bns[i2 - 1] = (BetaNode)sinks[i2];
                Object nodeMem2 = wm.getNodeMemory(bns[i2 - 1]);
                bms[i2 - 1] = 211 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)nodeMem2).getBetaMemory() : (BetaMemory)nodeMem2;
            }
        }
        --length;
        SubnetworkTuple subnetworkTuple = (SubnetworkTuple)srcTuples.getInsertFirst();
        while (subnetworkTuple != null) {
            next = (SubnetworkTuple)subnetworkTuple.getStagedNext();
            if (bm.getStagedRightTuples().isEmpty()) {
                bm.setNodeDirtyWithoutNotify();
            }
            subnetworkTuple.prepareStagingOnRight();
            rightTuples.addInsert(subnetworkTuple);
            if (bns != null) {
                for (i = 0; i < length; ++i) {
                    if (bms[i].getStagedRightTuples().isEmpty()) {
                        bms[i].setNodeDirtyWithoutNotify();
                    }
                    subnetworkTuple = riaNode.createPeer(subnetworkTuple);
                    bms[i].getStagedRightTuples().addInsert(subnetworkTuple);
                }
            }
            subnetworkTuple = next;
        }
        subnetworkTuple = (SubnetworkTuple)srcTuples.getDeleteFirst();
        while (subnetworkTuple != null) {
            next = (SubnetworkTuple)subnetworkTuple.getStagedNext();
            if (rightTuples.isEmpty()) {
                bm.setNodeDirtyWithoutNotify();
            }
            switch (subnetworkTuple.getStagedTypeOnRight()) {
                case 1: {
                    rightTuples.removeInsert(subnetworkTuple);
                    break;
                }
                case 2: {
                    rightTuples.removeUpdate(subnetworkTuple);
                }
            }
            subnetworkTuple.prepareStagingOnRight();
            rightTuples.addDelete(subnetworkTuple);
            if (bns != null) {
                for (i = 0; i < length; ++i) {
                    subnetworkTuple = (SubnetworkTuple)subnetworkTuple.getPeer();
                    if (bms[i].getStagedRightTuples().isEmpty()) {
                        bms[i].setNodeDirtyWithoutNotify();
                    }
                    bms[i].getStagedRightTuples().addDelete(subnetworkTuple);
                    subnetworkTuple.setStagedOnRight();
                }
            }
            subnetworkTuple = next;
        }
        subnetworkTuple = (SubnetworkTuple)srcTuples.getUpdateFirst();
        while (subnetworkTuple != null) {
            next = (SubnetworkTuple)subnetworkTuple.getStagedNext();
            if (rightTuples.isEmpty()) {
                bm.setNodeDirtyWithoutNotify();
            }
            subnetworkTuple.prepareStagingOnRight();
            rightTuples.addUpdate(subnetworkTuple);
            if (bns != null) {
                for (i = 0; i < length; ++i) {
                    subnetworkTuple = (SubnetworkTuple)subnetworkTuple.getPeer();
                    if (bms[i].getStagedRightTuples().isEmpty()) {
                        bms[i].setNodeDirtyWithoutNotify();
                    }
                    bms[i].getStagedRightTuples().addUpdate(subnetworkTuple);
                    subnetworkTuple.setStagedOnRight();
                }
            }
            subnetworkTuple = next;
        }
        srcTuples.resetAll();
    }

    public static void findLeftTupleBlocker(BetaNode betaNode, TupleMemory rtm, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTuple leftTuple, boolean useLeftMemory) {
        FastIterator it = betaNode.getRightIterator(rtm);
        RightTuple rightTuple = betaNode.getFirstRightTuple(leftTuple, rtm, null, it);
        while (rightTuple != null) {
            RightTuple nextRight = (RightTuple)it.next(rightTuple);
            if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandleForEvaluation())) {
                leftTuple.setBlocker(rightTuple);
                if (useLeftMemory) {
                    rightTuple.addBlocked(leftTuple);
                    break;
                }
                if (!betaNode.isRightInputIsRiaNode()) break;
                rtm.remove(rightTuple);
            }
            rightTuple = nextRight;
        }
    }

    public static void unlinkAndDeleteChildLeftTuple(LeftTuple childLeftTuple, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        RuleNetworkEvaluator.deleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
    }

    public static void deleteChildLeftTuple(LeftTuple childLeftTuple, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        if (childLeftTuple.isStagedOnRight()) {
            ((SubnetworkTuple)childLeftTuple).moveStagingFromRightToLeft();
        } else {
            switch (childLeftTuple.getStagedType()) {
                case 1: {
                    stagedLeftTuples.removeInsert(childLeftTuple);
                    trgLeftTuples.addNormalizedDelete(childLeftTuple);
                    return;
                }
                case 2: {
                    stagedLeftTuples.removeUpdate(childLeftTuple);
                }
            }
        }
        trgLeftTuples.addDelete(childLeftTuple);
    }

    public static void doUpdatesReorderLeftMemory(BetaMemory bm, TupleSets<LeftTuple> srcLeftTuples) {
        LeftTuple leftTuple;
        TupleMemory ltm = bm.getLeftTupleMemory();
        for (leftTuple = srcLeftTuples.getUpdateFirst(); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getStagedNext()) {
            if (leftTuple.getMemory() == null) continue;
            ltm.remove(leftTuple);
        }
        for (leftTuple = srcLeftTuples.getUpdateFirst(); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getStagedNext()) {
            ltm.add(leftTuple);
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                LeftTuple childNext = (LeftTuple)childLeftTuple.getHandleNext();
                childLeftTuple.reAddRight();
                childLeftTuple = childNext;
            }
        }
    }

    public static void doUpdatesExistentialReorderLeftMemory(BetaMemory bm, TupleSets<LeftTuple> srcLeftTuples) {
        LeftTuple leftTuple;
        TupleMemory ltm = bm.getLeftTupleMemory();
        for (leftTuple = srcLeftTuples.getUpdateFirst(); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getStagedNext()) {
            if (leftTuple.getMemory() == null) continue;
            ltm.remove(leftTuple);
        }
        for (leftTuple = srcLeftTuples.getUpdateFirst(); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getStagedNext()) {
            RightTuple blocker = leftTuple.getBlocker();
            if (blocker == null) {
                ltm.add(leftTuple);
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple childNext = (LeftTuple)childLeftTuple.getHandleNext();
                    childLeftTuple.reAddRight();
                    childLeftTuple = childNext;
                }
                continue;
            }
            if (blocker.getStagedType() == 0) continue;
            blocker.removeBlocked(leftTuple);
        }
    }

    public static void doUpdatesReorderRightMemory(BetaMemory bm, TupleSets<RightTuple> srcRightTuples) {
        RightTuple rightTuple;
        TupleMemory rtm = bm.getRightTupleMemory();
        for (rightTuple = srcRightTuples.getUpdateFirst(); rightTuple != null; rightTuple = (RightTuple)rightTuple.getStagedNext()) {
            if (rightTuple.getMemory() == null) continue;
            rightTuple.setTempRightTupleMemory(rightTuple.getMemory());
            rtm.remove(rightTuple);
        }
        for (rightTuple = srcRightTuples.getUpdateFirst(); rightTuple != null; rightTuple = (RightTuple)rightTuple.getStagedNext()) {
            if (rightTuple.getTempRightTupleMemory() == null) continue;
            rtm.add(rightTuple);
            RuleNetworkEvaluator.doUpdatesReorderChildLeftTuple(rightTuple);
        }
    }

    public static void doUpdatesReorderChildLeftTuple(RightTuple rightTuple) {
        LeftTuple childLeftTuple = rightTuple.getFirstChild();
        while (childLeftTuple != null) {
            LeftTuple childNext = childLeftTuple.getRightParentNext();
            childLeftTuple.reAddLeft();
            childLeftTuple = childNext;
        }
    }

    public static void doUpdatesExistentialReorderRightMemory(BetaMemory bm, BetaNode betaNode, TupleSets<RightTuple> srcRightTuples) {
        RightTuple tempRightTuple;
        RightTuple rightTuple;
        boolean resumeFromCurrent;
        TupleMemory rtm = bm.getRightTupleMemory();
        boolean bl = resumeFromCurrent = !betaNode.isIndexedUnificationJoin() && !rtm.getIndexType().isComparison();
        if (rtm.getIndexType() != TupleMemory.IndexType.NONE) {
            for (rightTuple = srcRightTuples.getDeleteFirst(); rightTuple != null; rightTuple = (RightTuple)rightTuple.getStagedNext()) {
                rtm.remove(rightTuple);
            }
        }
        for (rightTuple = srcRightTuples.getUpdateFirst(); rightTuple != null; rightTuple = (RightTuple)rightTuple.getStagedNext()) {
            if (rightTuple.getMemory() == null) continue;
            rightTuple.setTempRightTupleMemory(rightTuple.getMemory());
            if (resumeFromCurrent && rightTuple.getBlocked() != null) {
                for (tempRightTuple = (RightTuple)rightTuple.getNext(); tempRightTuple != null && tempRightTuple.getStagedType() != 0; tempRightTuple = (RightTuple)tempRightTuple.getNext()) {
                }
                if (tempRightTuple == null) {
                    for (tempRightTuple = (RightTuple)rightTuple.getPrevious(); tempRightTuple != null && tempRightTuple.getStagedType() != 0; tempRightTuple = (RightTuple)tempRightTuple.getPrevious()) {
                    }
                }
                rightTuple.setTempNextRightTuple(tempRightTuple);
            }
            rightTuple.setTempBlocked(rightTuple.getBlocked());
            rightTuple.setBlocked(null);
            rtm.remove(rightTuple);
        }
        for (rightTuple = srcRightTuples.getUpdateFirst(); rightTuple != null; rightTuple = (RightTuple)rightTuple.getStagedNext()) {
            rtm.add(rightTuple);
            if (resumeFromCurrent) {
                tempRightTuple = rightTuple.getTempNextRightTuple();
                if (rightTuple.getBlocked() != null && tempRightTuple == null && rightTuple.getMemory() == rightTuple.getTempRightTupleMemory()) {
                    rightTuple.setTempNextRightTuple(rightTuple);
                }
            }
            RuleNetworkEvaluator.doUpdatesReorderChildLeftTuple(rightTuple);
        }
        if (rtm.getIndexType() != TupleMemory.IndexType.NONE) {
            for (rightTuple = srcRightTuples.getDeleteFirst(); rightTuple != null; rightTuple = (RightTuple)rightTuple.getStagedNext()) {
                rtm.add(rightTuple);
            }
        }
    }

    public static boolean useLeftMemory(LeftTupleSource tupleSource, Tuple leftTuple) {
        Object object;
        boolean useLeftMemory = true;
        if (!(tupleSource.isLeftTupleMemoryEnabled() || (object = leftTuple.getRootTuple().getFactHandle().getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        return useLeftMemory;
    }

    public static void normalizeStagedTuples(TupleSets<LeftTuple> stagedLeftTuples, LeftTuple childLeftTuple) {
        if (!childLeftTuple.isStagedOnRight()) {
            switch (childLeftTuple.getStagedType()) {
                case 1: {
                    stagedLeftTuples.removeInsert(childLeftTuple);
                    break;
                }
                case 2: {
                    stagedLeftTuples.removeUpdate(childLeftTuple);
                }
            }
        }
    }
}

