/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import org.drools.core.base.ValueType;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.util.index.IndexUtil;
import org.drools.core.util.index.RangeIndex;

public class AlphaRangeIndex
implements Externalizable {
    private RangeIndex<Comparable, AlphaNode> rangeIndex;
    private CompositeObjectSinkAdapter.FieldIndex fieldIndex;
    private int size;

    public AlphaRangeIndex() {
    }

    public AlphaRangeIndex(CompositeObjectSinkAdapter.FieldIndex fieldIndex) {
        this.fieldIndex = fieldIndex;
        this.rangeIndex = new RangeIndex();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.rangeIndex);
        out.writeObject(this.fieldIndex);
        out.writeInt(this.size);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rangeIndex = (RangeIndex)in.readObject();
        this.fieldIndex = (CompositeObjectSinkAdapter.FieldIndex)in.readObject();
        this.size = in.readInt();
    }

    public void add(AlphaNode alphaNode) {
        IndexableConstraint constraint = (IndexableConstraint)((Object)alphaNode.getConstraint());
        Comparable key = this.extractKey(constraint);
        RangeIndex.IndexType indexType = this.extractIndexType(constraint);
        this.rangeIndex.addIndex(indexType, key, alphaNode);
        ++this.size;
    }

    public void remove(AlphaNode alphaNode) {
        IndexableConstraint constraint = (IndexableConstraint)((Object)alphaNode.getConstraint());
        Comparable key = this.extractKey(constraint);
        RangeIndex.IndexType indexType = this.extractIndexType(constraint);
        this.rangeIndex.removeIndex(indexType, key);
        --this.size;
    }

    private Comparable extractKey(IndexableConstraint constraint) {
        FieldValue field = constraint.getField();
        ValueType valueType = this.fieldIndex.getFieldExtractor().getValueType();
        if (valueType == ValueType.PCHAR_TYPE || valueType == ValueType.CHAR_TYPE) {
            return Character.valueOf(field.getCharValue());
        }
        if (valueType == ValueType.PBYTE_TYPE || valueType == ValueType.BYTE_TYPE) {
            return Byte.valueOf(field.getByteValue());
        }
        if (valueType == ValueType.PSHORT_TYPE || valueType == ValueType.SHORT_TYPE) {
            return Short.valueOf(field.getShortValue());
        }
        if (valueType == ValueType.PINTEGER_TYPE || valueType == ValueType.INTEGER_TYPE) {
            return Integer.valueOf(field.getIntValue());
        }
        if (valueType == ValueType.PLONG_TYPE || valueType == ValueType.LONG_TYPE) {
            return Long.valueOf(field.getLongValue());
        }
        if (valueType == ValueType.PFLOAT_TYPE || valueType == ValueType.FLOAT_TYPE) {
            return Float.valueOf(field.getFloatValue());
        }
        if (valueType == ValueType.PDOUBLE_TYPE || valueType == ValueType.DOUBLE_TYPE) {
            return Double.valueOf(field.getDoubleValue());
        }
        if (valueType == ValueType.PBOOLEAN_TYPE || valueType == ValueType.BOOLEAN_TYPE) {
            return Boolean.valueOf(field.getBooleanValue());
        }
        if (valueType == ValueType.STRING_TYPE) {
            return (Comparable)field.getValue();
        }
        if (valueType.getSimpleType() == 8) {
            return (Comparable)field.getValue();
        }
        if (valueType == ValueType.ARRAY_TYPE) {
            return (Comparable)field.getValue();
        }
        if (valueType == ValueType.OBJECT_TYPE) {
            return (Comparable)field.getValue();
        }
        if (valueType == ValueType.TRAIT_TYPE) {
            return (Comparable)field.getValue();
        }
        if (valueType == ValueType.BIG_DECIMAL_TYPE) {
            return field.getBigDecimalValue();
        }
        if (valueType == ValueType.BIG_INTEGER_TYPE) {
            return field.getBigIntegerValue();
        }
        if (valueType == ValueType.CLASS_TYPE) {
            return (Comparable)field.getValue();
        }
        return (Comparable)field.getValue();
    }

    private RangeIndex.IndexType extractIndexType(IndexableConstraint constraint) {
        IndexUtil.ConstraintType constraintType = constraint.getConstraintType();
        switch (constraintType) {
            case LESS_THAN: {
                return RangeIndex.IndexType.LT;
            }
            case LESS_OR_EQUAL: {
                return RangeIndex.IndexType.LE;
            }
            case GREATER_THAN: {
                return RangeIndex.IndexType.GT;
            }
            case GREATER_OR_EQUAL: {
                return RangeIndex.IndexType.GE;
            }
        }
        throw new RuntimeException("Non relational oparator must not be added to range index : constraint = " + constraint + ", constraintType = " + (Object)((Object)constraintType));
    }

    public int size() {
        return this.size;
    }

    public Collection<AlphaNode> getMatchingAlphaNodes(Object object) {
        Object value = this.fieldIndex.getFieldExtactor().getValue(object);
        if (value == null) {
            return Collections.emptyList();
        }
        return this.rangeIndex.getValues((Comparable)value);
    }

    public Collection<AlphaNode> getAllValues() {
        return this.rangeIndex.getAllValues();
    }

    public void clear() {
        this.rangeIndex = new RangeIndex();
    }
}

