/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.commons.jci.compilers;

import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerSettings;
import org.drools.compiler.compiler.JavaConfiguration;
import org.drools.core.util.ClassUtils;

public enum JavaCompilerFactory {
    INSTANCE;

    private final Map classCache = new HashMap();

    public JavaCompiler createCompiler(String pHint) {
        String className = pHint.indexOf(46) < 0 ? "org.drools.compiler.commons.jci.compilers." + ClassUtils.toJavaCasing((String)pHint) + "JavaCompiler" : pHint;
        Class<?> clazz = (Class<?>)this.classCache.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
                this.classCache.put(className, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            return null;
        }
        try {
            return (JavaCompiler)clazz.newInstance();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public JavaCompiler loadCompiler(JavaConfiguration configuration) {
        return this.loadCompiler(configuration.getCompiler(), configuration.getJavaLanguageLevel());
    }

    public JavaCompiler loadCompiler(JavaConfiguration.CompilerType compilerType, String lngLevel) {
        JavaCompiler compiler;
        switch (compilerType) {
            case NATIVE: {
                compiler = this.createCompiler("native");
                if (compiler == null) {
                    throw new RuntimeException("Instance of native compiler cannot be created!");
                }
                this.updateSettings(compiler.createDefaultSettings(), lngLevel);
                break;
            }
            default: {
                compiler = this.createCompiler("eclipse");
                if (compiler == null) {
                    throw new RuntimeException("Instance of eclipse compiler cannot be created!");
                }
                this.updateSettings(compiler.createDefaultSettings(), lngLevel);
            }
        }
        return compiler;
    }

    private JavaCompilerSettings updateSettings(JavaCompilerSettings settings, String lngLevel) {
        settings.setTargetVersion(lngLevel);
        settings.setSourceVersion(lngLevel);
        return settings;
    }
}

