/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.pillar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.entity.pillar.SubPillarConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.move.generic.SubPillarType;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.AbstractSelector;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultPillarSelector
extends AbstractSelector
implements PillarSelector,
SelectionCacheLifecycleListener {
    protected static final SelectionCacheType CACHE_TYPE = SelectionCacheType.STEP;
    protected final EntitySelector entitySelector;
    protected final List<GenuineVariableDescriptor> variableDescriptors;
    protected final boolean randomSelection;
    protected final SubPillarConfigPolicy subpillarConfigPolicy;
    protected List<List<Object>> cachedBasePillarList = null;

    public DefaultPillarSelector(EntitySelector entitySelector, List<GenuineVariableDescriptor> variableDescriptors, boolean randomSelection, SubPillarConfigPolicy subpillarConfigPolicy) {
        this.entitySelector = entitySelector;
        this.variableDescriptors = variableDescriptors;
        this.randomSelection = randomSelection;
        this.subpillarConfigPolicy = subpillarConfigPolicy;
        Class<?> entityClass = entitySelector.getEntityDescriptor().getEntityClass();
        for (GenuineVariableDescriptor variableDescriptor : variableDescriptors) {
            if (!entityClass.equals(variableDescriptor.getEntityDescriptor().getEntityClass())) {
                throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") with a entityClass (" + variableDescriptor.getEntityDescriptor().getEntityClass() + ") which is not equal to the entitySelector's entityClass (" + entityClass + ").");
            }
            if (!variableDescriptor.isChained()) continue;
            throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") which is chained (" + variableDescriptor.isChained() + ").");
        }
        for (GenuineVariableDescriptor variableDescriptor : variableDescriptors) {
            if (!variableDescriptor.isChained()) continue;
            throw new IllegalStateException("The selector (" + this + ") cannot have a variableDescriptor (" + variableDescriptor + ") which is chained (" + variableDescriptor.isChained() + ").");
        }
        if (entitySelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has an entitySelector (" + entitySelector + ") with neverEnding (" + entitySelector.isNeverEnding() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(CACHE_TYPE, this));
        boolean subPillarEnabled = subpillarConfigPolicy.isSubPillarEnabled();
        if (!randomSelection && subPillarEnabled) {
            throw new IllegalStateException("The selector (" + this + ") with randomSelection  (" + randomSelection + ") does not support non random selection with sub pillars because the number of sub pillars scales exponentially.\nEither set subPillarType to " + (Object)((Object)SubPillarType.NONE) + " or use JIT random selection.");
        }
    }

    private static List<Object> getSingleVariableValueState(Object entity, List<GenuineVariableDescriptor> variableDescriptors) {
        Object value = variableDescriptors.get(0).getValue(entity);
        return Collections.singletonList(value);
    }

    private static List<Object> getMultiVariableValueState(Object entity, List<GenuineVariableDescriptor> variableDescriptors, int variableCount) {
        ArrayList<Object> valueState = new ArrayList<Object>(variableCount);
        for (int i = 0; i < variableCount; ++i) {
            Object value = variableDescriptors.get(i).getValue(entity);
            valueState.add(value);
        }
        return valueState;
    }

    @Override
    public EntityDescriptor getEntityDescriptor() {
        return this.entitySelector.getEntityDescriptor();
    }

    @Override
    public SelectionCacheType getCacheType() {
        return CACHE_TYPE;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        long entitySize = this.entitySelector.getSize();
        if (entitySize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + this + ") has an entitySelector (" + this.entitySelector + ") with entitySize (" + entitySize + ") which is higher than Integer.MAX_VALUE.");
        }
        Stream<Object> entities = StreamSupport.stream(this.entitySelector.spliterator(), false);
        Comparator<?> comparator = this.subpillarConfigPolicy.getEntityComparator();
        if (comparator != null) {
            entities = entities.sorted(comparator);
        }
        LinkedHashMap valueStateToPillarMap = new LinkedHashMap((int)entitySize);
        int variableCount = this.variableDescriptors.size();
        entities.forEach(entity -> {
            List<Object> valueState = variableCount == 1 ? DefaultPillarSelector.getSingleVariableValueState(entity, this.variableDescriptors) : DefaultPillarSelector.getMultiVariableValueState(entity, this.variableDescriptors, variableCount);
            List pillar = valueStateToPillarMap.computeIfAbsent(valueState, key -> new ArrayList());
            pillar.add(entity);
        });
        Collection pillarLists = valueStateToPillarMap.values();
        int minimumSubPillarSize = this.subpillarConfigPolicy.getMinimumSubPillarSize();
        this.cachedBasePillarList = minimumSubPillarSize > 1 ? pillarLists.stream().filter(pillar -> pillar.size() >= minimumSubPillarSize).collect(Collectors.toList()) : new ArrayList(pillarLists);
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.cachedBasePillarList = null;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        if (!this.subpillarConfigPolicy.isSubPillarEnabled()) {
            return this.cachedBasePillarList.size();
        }
        throw new UnsupportedOperationException("The selector (" + this + ") with randomSelection  (" + this.randomSelection + ") and sub pillars does not support getSize() because the number of sub pillars scales exponentially.");
    }

    @Override
    public Iterator<List<Object>> iterator() {
        boolean subPillarEnabled = this.subpillarConfigPolicy.isSubPillarEnabled();
        if (!this.randomSelection) {
            if (!subPillarEnabled) {
                return this.cachedBasePillarList.iterator();
            }
            throw new IllegalStateException(this.getSubPillarExceptionMessage());
        }
        if (!subPillarEnabled) {
            return new CachedListRandomIterator<List<Object>>(this.cachedBasePillarList, this.workingRandom);
        }
        return new RandomSubPillarIterator();
    }

    private String getSubPillarExceptionMessage() {
        return "Impossible state because the constructors fails with randomSelection (" + this.randomSelection + ") and sub pillars.";
    }

    private String getListIteratorExceptionMessage() {
        return "The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").";
    }

    @Override
    public ListIterator<List<Object>> listIterator() {
        boolean subPillarEnabled = this.subpillarConfigPolicy.isSubPillarEnabled();
        if (!this.randomSelection) {
            if (!subPillarEnabled) {
                return this.cachedBasePillarList.listIterator();
            }
            throw new IllegalStateException(this.getSubPillarExceptionMessage());
        }
        throw new IllegalStateException(this.getListIteratorExceptionMessage());
    }

    @Override
    public ListIterator<List<Object>> listIterator(int index) {
        boolean subPillarEnabled = this.subpillarConfigPolicy.isSubPillarEnabled();
        if (!this.randomSelection) {
            if (!subPillarEnabled) {
                return this.cachedBasePillarList.listIterator(index);
            }
            throw new IllegalStateException(this.getSubPillarExceptionMessage());
        }
        throw new IllegalStateException(this.getListIteratorExceptionMessage());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ")";
    }

    private class RandomSubPillarIterator
    extends UpcomingSelectionIterator<List<Object>> {
        public RandomSubPillarIterator() {
            if (DefaultPillarSelector.this.cachedBasePillarList.isEmpty()) {
                this.upcomingSelection = this.noUpcomingSelection();
                this.upcomingCreated = true;
            }
        }

        @Override
        protected List<Object> createUpcomingSelection() {
            List<Object> basePillar = this.selectBasePillar();
            int basePillarSize = basePillar.size();
            if (basePillarSize == 1) {
                return basePillar;
            }
            int min = Math.min(DefaultPillarSelector.this.subpillarConfigPolicy.getMinimumSubPillarSize(), basePillarSize);
            int max = Math.min(DefaultPillarSelector.this.subpillarConfigPolicy.getMaximumSubPillarSize(), basePillarSize);
            int subPillarSize = min + DefaultPillarSelector.this.workingRandom.nextInt(max - min + 1);
            if (subPillarSize == basePillarSize) {
                return basePillar;
            }
            if (subPillarSize == 1) {
                int randomIndex = DefaultPillarSelector.this.workingRandom.nextInt(basePillarSize);
                Object randomElement = basePillar.get(randomIndex);
                return Collections.singletonList(randomElement);
            }
            Comparator<?> comparator = DefaultPillarSelector.this.subpillarConfigPolicy.getEntityComparator();
            if (comparator == null) {
                return this.selectRandom(basePillar, subPillarSize);
            }
            return this.selectSublist(basePillar, subPillarSize);
        }

        private List<Object> selectSublist(List<Object> basePillar, int subPillarSize) {
            int randomStartingIndex = DefaultPillarSelector.this.workingRandom.nextInt(basePillar.size() - subPillarSize);
            return basePillar.subList(randomStartingIndex, randomStartingIndex + subPillarSize);
        }

        private List<Object> selectRandom(List<Object> basePillar, int subPillarSize) {
            Object[] sandboxPillar = basePillar.toArray();
            ArrayList<Object> subPillar = new ArrayList<Object>(subPillarSize);
            for (int i = 0; i < subPillarSize; ++i) {
                int index = i + DefaultPillarSelector.this.workingRandom.nextInt(basePillar.size() - i);
                subPillar.add(sandboxPillar[index]);
                sandboxPillar[index] = sandboxPillar[i];
            }
            return subPillar;
        }

        private List<Object> selectBasePillar() {
            int baseListIndex = DefaultPillarSelector.this.workingRandom.nextInt(DefaultPillarSelector.this.cachedBasePillarList.size());
            return DefaultPillarSelector.this.cachedBasePillarList.get(baseListIndex);
        }
    }
}

