/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.migration.cli;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.apache.commons.cli.ParseException;
import org.jboss.weld.environment.se.Weld;
import org.kie.workbench.common.migration.cli.ContainerHandler;
import org.kie.workbench.common.migration.cli.MigrationSetup;
import org.kie.workbench.common.migration.cli.MigrationTool;
import org.kie.workbench.common.migration.cli.RealSystemAccess;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.migration.cli.TemporaryNiogitService;
import org.kie.workbench.common.migration.cli.ToolConfig;

public class MigrationApp {
    private List<MigrationTool> migrationTools = new ArrayList<MigrationTool>();
    private SystemAccess system = new RealSystemAccess();
    private ToolConfig actualConfig;

    public MigrationApp(String[] args) {
        this.actualConfig = this.parseToolConfigOrExit(args);
        ServiceLoader<MigrationTool> migrationLoader = ServiceLoader.load(MigrationTool.class);
        migrationLoader.forEach(migrationTool -> this.migrationTools.add((MigrationTool)migrationTool));
        Collections.sort(this.migrationTools, Comparator.comparing(MigrationTool::getPriority));
    }

    public void start() {
        this.validateTarget(this.actualConfig.getTarget());
        if (this.isNiogit(this.actualConfig.getTarget())) {
            this.runTasks(this.actualConfig, this.migrationTools.toArray(new MigrationTool[this.migrationTools.size()]), this::exit);
        } else if (this.isGitRepositoryRoot(this.actualConfig.getTarget())) {
            this.setupTmpNiogitAndRunTasks();
        } else {
            this.system.err().println(String.format("The given target [%s] is not a repository root or an niogit directory.", this.actualConfig.getTarget()));
            this.system.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupTmpNiogitAndRunTasks() {
        Path tmpNiogit = this.createTempNiogit();
        try {
            ToolConfig effectiveConfig = new ToolConfig(tmpNiogit, this.actualConfig.isBatch());
            Path outputFolder = this.promptForOutputPath();
            this.importActualTargetIntoNiogit(this.actualConfig.getTarget(), tmpNiogit);
            MigrationTool[] nonSystemTools = (MigrationTool[])this.migrationTools.stream().filter(tool -> !tool.isSystemMigration()).toArray(MigrationTool[]::new);
            this.runTasks(effectiveConfig, nonSystemTools, () -> {
                this.copyBareReposToOutputFolder(tmpNiogit, outputFolder);
                this.deleteTempDirectory(tmpNiogit);
                this.exit();
            });
        }
        finally {
            if (tmpNiogit.toFile().exists()) {
                this.deleteTempDirectory(tmpNiogit);
            }
        }
    }

    private void copyBareReposToOutputFolder(Path tmpNiogit, Path outputFolder) {
        try {
            Path migrationSpace = tmpNiogit.resolve("migrationSpace");
            Optional.ofNullable(migrationSpace.toFile().listFiles()).map(Arrays::stream).orElse(Stream.empty()).filter(file -> file.isDirectory() && file.getName().endsWith(".git")).forEach(gitDir -> {
                Path path = gitDir.toPath();
                try {
                    this.system.copyDirectory(path, outputFolder.resolve(path.getFileName()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Throwable t) {
            this.system.err().println("Unable to output migrated projects.");
            t.printStackTrace(this.system.err());
            this.system.exit(1);
        }
    }

    private Path promptForOutputPath() {
        Path rawPath = Paths.get(this.system.console().readLine("Enter location for migrated repository output: ", new Object[0]), new String[0]);
        if (rawPath.isAbsolute()) {
            return rawPath;
        }
        return this.system.currentWorkingDirectory().resolve(rawPath).normalize();
    }

    private void deleteTempDirectory(Path tmpNiogit) {
        try {
            this.system.recursiveDelete(tmpNiogit);
        }
        catch (IOException ex) {
            this.system.err().println(String.format("Unable to delete temporary niogit directory [%s].", tmpNiogit));
        }
    }

    private boolean isGitRepositoryRoot(Path target) {
        return target.resolve(".git").toFile().exists();
    }

    private void importActualTargetIntoNiogit(Path actualTarget, Path tmpNiogit) {
        MigrationSetup.configureProperties(this.system, tmpNiogit);
        ContainerHandler container = new ContainerHandler(() -> new Weld().initialize());
        this.system.out().printf("Loading target [%s] into temporary niogit [%s].\n", actualTarget, tmpNiogit);
        container.run(TemporaryNiogitService.class, service -> service.importProjects(actualTarget), error -> {
            this.system.err().println(String.format("Failed to load project at given path [%s].", error));
            error.printStackTrace(this.system.err());
            container.close();
            this.system.exit(1);
        });
        container.close();
    }

    private Path createTempNiogit() {
        try {
            return this.system.createTemporaryDirectory("niogit", new FileAttribute[0]);
        }
        catch (IOException e) {
            this.system.err().println("Unable to create temporary niogit directory. Exiting.");
            return (Path)this.system.exit(1);
        }
    }

    private boolean isNiogit(Path target) {
        Path legacySystemGit = target.resolve("system.git");
        Path systemGit = target.resolve("system").resolve("system.git");
        return legacySystemGit.toFile().exists() || systemGit.toFile().exists();
    }

    private void runTasks(ToolConfig effectiveConfig, MigrationTool[] tools, Runnable exitAction) {
        if (!effectiveConfig.isBatch()) {
            while (true) {
                this.printWizard(effectiveConfig, tools, exitAction);
            }
        }
        this.execute(effectiveConfig, exitAction, tools);
        exitAction.run();
    }

    private void printWizard(ToolConfig config, MigrationTool[] tools, Runnable exitAction) {
        String response;
        Integer n;
        Object tool;
        this.system.out().println("\n");
        this.system.out().println("Kie Workbench Migration Tool");
        this.system.out().println("============================\n");
        SystemAccess.Console console = this.system.console();
        HashMap<String, Runnable> menuOptions = new HashMap<String, Runnable>();
        Integer index = 1;
        while (index <= tools.length) {
            tool = tools[index - 1];
            console.format("%s) %s (%s)\n", index, tool.getTitle().toUpperCase(), tool.getDescription());
            menuOptions.put(index.toString(), () -> this.lambda$printWizard$9(config, exitAction, (MigrationTool)tool));
            tool = index;
            n = index = Integer.valueOf(index + 1);
        }
        console.format("%s) ALL\n", index);
        menuOptions.put(index.toString(), () -> this.execute(config, exitAction, tools));
        tool = index;
        n = index = Integer.valueOf(index + 1);
        console.format("%s) EXIT\n\n", index);
        menuOptions.put(index.toString(), exitAction);
        while (!menuOptions.containsKey(response = console.readLine("Choose one option [1-" + index + "]: ", new Object[0]).toLowerCase())) {
        }
        ((Runnable)menuOptions.get(response)).run();
    }

    private void execute(ToolConfig config, Runnable exitAction, MigrationTool ... tools) {
        for (MigrationTool tool : tools) {
            tool.run(config, this.system);
        }
    }

    private void exit() {
        this.system.out().println("\nGoodbye!");
        this.system.exit(0);
    }

    private ToolConfig parseToolConfigOrExit(String[] args) {
        ToolConfig.DefaultFactory configFactory = new ToolConfig.DefaultFactory();
        ToolConfig config = null;
        try {
            config = configFactory.parse(args);
        }
        catch (ParseException e) {
            this.system.err().printf("Could not parse arguments: %s\n", e.getMessage());
            configFactory.printHelp(this.system.err(), "migration-tool");
            this.system.exit(1);
        }
        return config;
    }

    private void validateTarget(Path target) {
        Optional<String> errorMessage = Optional.empty();
        try {
            File dirFile = target.toFile();
            if (!dirFile.exists()) {
                errorMessage = Optional.of(String.format("The target path does not exist: %s", target));
            } else if (!dirFile.isDirectory()) {
                errorMessage = Optional.of(String.format("The target path is not a directory: %s", target));
            }
        }
        catch (UnsupportedOperationException e) {
            errorMessage = Optional.of(String.format("The target path must be a file: %s", target));
        }
        errorMessage.ifPresent(msg -> {
            this.system.err().println((String)msg);
            this.system.exit(1);
        });
    }

    private /* synthetic */ void lambda$printWizard$9(ToolConfig config, Runnable exitAction, MigrationTool tool) {
        this.execute(config, exitAction, tool);
    }
}

