/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions;

import java.io.Serializable;
import org.drools.model.functions.IntrospectableLambda;
import org.drools.model.functions.PredicateInformation;

public interface Predicate4<A, B, C, D>
extends Serializable {
    public boolean test(A var1, B var2, C var3, D var4) throws Exception;

    default public Predicate4<A, B, C, D> negate() {
        return (a, b, c, d) -> !this.test(a, b, c, d);
    }

    default public PredicateInformation predicateInformation() {
        return PredicateInformation.EMPTY_PREDICATE_INFORMATION;
    }

    public static class Impl<A, B, C, D>
    extends IntrospectableLambda
    implements Predicate4<A, B, C, D> {
        private final Predicate4<A, B, C, D> predicate;

        public Impl(Predicate4<A, B, C, D> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(A a, B b, C c, D d) throws Exception {
            return this.predicate.test(a, b, c, d);
        }

        @Override
        public Object getLambda() {
            return this.predicate;
        }

        @Override
        public PredicateInformation predicateInformation() {
            return this.predicate.predicateInformation();
        }
    }
}

