/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions;

import java.util.function.Supplier;
import org.drools.model.functions.HashedExpression;
import org.drools.model.functions.LambdaPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IntrospectableLambda
implements Supplier<Object> {
    private static final Logger logger = LoggerFactory.getLogger(IntrospectableLambda.class);
    private String lambdaFingerprint;
    static boolean IS_NATIVE_IMAGE = System.getProperty("org.graalvm.nativeimage.imagecode") != null;

    public abstract Object getLambda();

    @Override
    public final Object get() {
        return this.getLambda();
    }

    public String toString() {
        if (this.lambdaFingerprint == null) {
            this.lambdaFingerprint = this.generateFingerprint();
        }
        return this.lambdaFingerprint;
    }

    private String generateFingerprint() {
        if (this.getLambda() instanceof HashedExpression) {
            logger.debug("The constraint supports org.drools.model.functions.HashedExpression, node sharing is enabled and compile-time fingerprint is used");
            return ((HashedExpression)this.getLambda()).getExpressionHash();
        }
        if (!IS_NATIVE_IMAGE) {
            logger.debug("No HashedExpression provided, generating fingerprint using reflection via org.drools.mvel.asm.LambdaIntrospector, node sharing enabled");
            return LambdaPrinter.print(this.getLambda());
        }
        logger.debug("No HashedExpression provided, using Object.class.toString(), node sharing might not work correctly");
        return super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntrospectableLambda)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

