/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.visitor.GenericVisitor;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.function.Supplier;
import org.drools.mvel.parser.ast.visitor.DrlGenericVisitor;
import org.drools.mvelcompiler.ast.BigDecimalConvertedExprT;
import org.drools.mvelcompiler.ast.IntegerLiteralExpressionT;
import org.drools.mvelcompiler.ast.LongLiteralExpressionT;
import org.drools.mvelcompiler.ast.TypedExpression;
import org.drools.mvelcompiler.ast.UnalteredTypedExpression;
import org.drools.mvelcompiler.context.MvelCompilerContext;

public class ReProcessRHSPhase
implements DrlGenericVisitor<Optional<TypedExpression>, Void> {
    private TypedExpression lhs;
    private MvelCompilerContext mvelCompilerContext;

    ReProcessRHSPhase(MvelCompilerContext mvelCompilerContext) {
        this.mvelCompilerContext = mvelCompilerContext;
    }

    public Optional<TypedExpression> invoke(TypedExpression rhs, TypedExpression lhs) {
        this.lhs = lhs;
        return Optional.ofNullable(rhs).flatMap(r -> (Optional)r.toJavaExpression().accept((GenericVisitor)this, null));
    }

    public Optional<TypedExpression> defaultMethod(Node n, Void context) {
        return Optional.empty();
    }

    public Optional<TypedExpression> visit(IntegerLiteralExpr n, Void arg) {
        return this.convertWhenLHSISBigDecimal(() -> new IntegerLiteralExpressionT(n));
    }

    public Optional<TypedExpression> visit(LongLiteralExpr n, Void arg) {
        return this.convertWhenLHSISBigDecimal(() -> new LongLiteralExpressionT(n));
    }

    public Optional<TypedExpression> visit(NameExpr n, Void arg) {
        if (this.mvelCompilerContext.findDeclarations(n.toString()).filter(d -> d.getClazz() != BigDecimal.class).isPresent()) {
            return this.convertWhenLHSISBigDecimal(() -> new UnalteredTypedExpression((Node)n));
        }
        return Optional.empty();
    }

    private Optional<TypedExpression> convertWhenLHSISBigDecimal(Supplier<TypedExpression> conversionFunction) {
        return this.lhs.getType().filter(BigDecimal.class::equals).flatMap(t -> Optional.of(new BigDecimalConvertedExprT((TypedExpression)conversionFunction.get())));
    }
}

