/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jbpm.services.task.identity.AbstractUserGroupInfo;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;

public class DefaultUserInfo
extends AbstractUserGroupInfo
implements UserInfo {
    protected Map<String, Map<String, Object>> registry = new HashMap<String, Map<String, Object>>();
    protected static final String DEFAULT_USER_PROPS_LOCATION = "classpath:/userinfo.properties";

    public DefaultUserInfo(boolean activate) {
        try {
            Properties registryProps = this.readProperties(DEFAULT_USER_PROPS_LOCATION, DEFAULT_USER_PROPS_LOCATION);
            this.buildRegistry(registryProps);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem loading userinfo properties", e);
        }
    }

    public DefaultUserInfo(Properties registryProps) {
        this.buildRegistry(registryProps);
    }

    public String getDisplayName(OrganizationalEntity entity) {
        Map<String, Object> entityInfo = this.registry.get(entity.getId());
        if (entityInfo != null) {
            return (String)entityInfo.get("name");
        }
        return null;
    }

    public Iterator<OrganizationalEntity> getMembersForGroup(Group group) {
        Map<String, Object> entityInfo = this.registry.get(group.getId());
        if (entityInfo != null && entityInfo.get("members") != null) {
            return ((List)entityInfo.get("members")).iterator();
        }
        return null;
    }

    public boolean hasEmail(Group group) {
        Map<String, Object> entityInfo = this.registry.get(group.getId());
        if (entityInfo != null) {
            return entityInfo.containsKey("email");
        }
        return false;
    }

    public String getEmailForEntity(OrganizationalEntity entity) {
        Map<String, Object> entityInfo = this.registry.get(entity.getId());
        if (entityInfo != null) {
            return (String)entityInfo.get("email");
        }
        return null;
    }

    public String getLanguageForEntity(OrganizationalEntity entity) {
        Map<String, Object> entityInfo = this.registry.get(entity.getId());
        if (entityInfo != null) {
            return (String)entityInfo.get("locale");
        }
        return null;
    }

    public String getEntityForEmail(String email) {
        for (Map.Entry<String, Map<String, Object>> entry : this.registry.entrySet()) {
            if (!entry.getValue().get("email").equals(email)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected void buildRegistry(Properties registryProps) {
        if (registryProps != null) {
            for (String string : registryProps.keySet()) {
                String propertyValue = registryProps.getProperty(string);
                String[] elems = propertyValue.split(":");
                HashMap<String, Object> entityInfo = new HashMap<String, Object>();
                entityInfo.put("email", elems[0]);
                entityInfo.put("locale", elems[1]);
                entityInfo.put("name", elems[2]);
                if (elems.length == 4 && elems[3] != null) {
                    String memberList = elems[3];
                    if (memberList.startsWith("[")) {
                        memberList = memberList.substring(1);
                    }
                    if (memberList.endsWith("]")) {
                        memberList = memberList.substring(0, memberList.length() - 1);
                    }
                    String[] members = memberList.split(",");
                    ArrayList<User> membersList = new ArrayList<User>();
                    for (String member : members) {
                        User user = TaskModelProvider.getFactory().newUser();
                        ((InternalOrganizationalEntity)user).setId(member);
                        membersList.add(user);
                    }
                    entityInfo.put("members", membersList);
                }
                this.registry.put(string, entityInfo);
            }
        }
    }
}

