/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DataAssociationFactory {
    protected static final String LANG_EXPRESSION_ATTR = "language";
    protected static final String DEFAULT_DIALECT = "XPath";
    protected static final String USE_DEFINITION_LANGUAGE_PROPERTY = "org.kie.jbpm.bpmn2.useDefinitionLanguage";
    private static final Logger logger = LoggerFactory.getLogger(DataAssociationFactory.class);
    private static Map<String, Pattern> dialectPatterns = DataAssociationFactory.buildDialectPatterns(ProcessDialectRegistry.getDialects());

    private DataAssociationFactory() {
    }

    public static DataAssociation readDataOutputAssociation(Node xmlNode, Map<String, String> dataOutputs) {
        NodeList nodeList = xmlNode.getChildNodes();
        String source = null;
        String target = null;
        Transformation transformation = null;
        ArrayList<Assignment> assignment = new ArrayList<Assignment>();
        block12: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node subNode = nodeList.item(i);
            switch (subNode.getNodeName()) {
                case "sourceRef": {
                    source = subNode.getTextContent();
                    if (!dataOutputs.containsKey(source)) {
                        logger.warn("Data outputs in this node {} does not contain source {}", (Object)xmlNode.getAttributes().getNamedItem("id"), (Object)source);
                    }
                    source = dataOutputs.get(source);
                    continue block12;
                }
                case "targetRef": {
                    target = subNode.getTextContent();
                    continue block12;
                }
                case "transformation": {
                    String lang = subNode.getAttributes().getNamedItem(LANG_EXPRESSION_ATTR).getNodeValue();
                    String expression = subNode.getTextContent();
                    transformation = new Transformation(lang, expression, source);
                    continue block12;
                }
                case "assignment": {
                    assignment.add(DataAssociationFactory.readAssignment(subNode));
                }
            }
        }
        return new DataAssociation(source, target, assignment, transformation);
    }

    public static List<Assignment> readAssignments(Node subNode) {
        LinkedList<Assignment> assignments = new LinkedList<Assignment>();
        while (subNode != null) {
            assignments.add(DataAssociationFactory.readAssignment(subNode));
            subNode = subNode.getNextSibling();
        }
        return assignments;
    }

    public static Assignment readAssignment(Node xmlNode) {
        Node from = xmlNode.getFirstChild();
        if (from == null) {
            throw new IllegalArgumentException("missing from for assignment");
        }
        Node to = from.getNextSibling();
        if (to == null) {
            throw new IllegalArgumentException("missing to for assignment");
        }
        return new Assignment(DataAssociationFactory.getDialect(xmlNode, from, to), from.getTextContent(), to.getTextContent());
    }

    protected static String getDialect(Node node, Node from, Node to) {
        String dialect;
        Collection dialects = ProcessDialectRegistry.getDialects();
        if (!dialects.equals(dialectPatterns.keySet())) {
            dialectPatterns = DataAssociationFactory.buildDialectPatterns(dialects);
        }
        if ((dialect = DataAssociationFactory.findDialect(from.getAttributes().getNamedItem(LANG_EXPRESSION_ATTR))) == null) {
            dialect = DataAssociationFactory.findDialect(to.getAttributes().getNamedItem(LANG_EXPRESSION_ATTR));
        }
        if (dialect == null && Boolean.getBoolean(USE_DEFINITION_LANGUAGE_PROPERTY)) {
            Node parentNode;
            for (parentNode = node.getParentNode(); parentNode != null && !parentNode.getLocalName().equals("Definitions"); parentNode = parentNode.getParentNode()) {
            }
            if (parentNode != null) {
                dialect = DataAssociationFactory.findDialect(parentNode.getAttributes().getNamedItem("expressionLanguage"));
            }
        }
        if (dialect == null && (PatternConstants.PARAMETER_MATCHER.matcher(from.getTextContent()).matches() || PatternConstants.PARAMETER_MATCHER.matcher(to.getTextContent()).matches())) {
            dialect = "mvel";
        }
        return dialect == null ? DEFAULT_DIALECT : dialect;
    }

    private static String findDialect(Node languageAttr) {
        if (languageAttr != null) {
            for (Map.Entry<String, Pattern> dialect : dialectPatterns.entrySet()) {
                if (!dialect.getValue().matcher(languageAttr.getNodeValue()).find()) continue;
                return dialect.getKey();
            }
        }
        return null;
    }

    private static Map<String, Pattern> buildDialectPatterns(Collection<String> dialects) {
        return dialects.stream().collect(Collectors.toMap(x -> x, dialect -> Pattern.compile("\\b" + dialect + "\\b", 2)));
    }
}

