/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.kafka;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

class CloudEvent<T> {
    private static ObjectMapper mapper = new ObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat(System.getProperty("org.kie.server.jbpm-kafka.ext.json.date_format", System.getProperty("org.kie.server.json.date_format", "yyyy-MM-dd'T'HH:mm:ss.SSSZ")))).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    private static final String SOURCE_FORMATTER = "/process/%s/%s";
    private String specversion;
    private Date time;
    private String id;
    private String type;
    private String source;
    private T data;

    public static byte[] write(String processId, long processInstanceId, Object value) throws IOException {
        CloudEvent event = new CloudEvent();
        event.type = value != null ? value.getClass().getTypeName() : "empty";
        event.source = String.format(SOURCE_FORMATTER, processId, processInstanceId);
        event.specversion = "1.0";
        event.time = new Date();
        event.id = UUID.randomUUID().toString();
        event.data = value;
        return mapper.writeValueAsBytes(event);
    }

    public static <T> CloudEvent<T> read(byte[] bytes, Class<T> type) throws IOException, ParseException {
        JsonNode node = mapper.readTree(bytes);
        CloudEvent<T> cloudEvent = new CloudEvent<T>();
        if (node.has("id")) {
            cloudEvent.id = node.get("id").asText();
        }
        if (node.has("source")) {
            cloudEvent.source = node.get("source").asText();
        }
        if (node.has("type")) {
            cloudEvent.type = node.get("type").asText();
        }
        if (node.has("specversion")) {
            cloudEvent.specversion = node.get("specversion").asText();
        }
        if (node.has("time")) {
            cloudEvent.time = mapper.getDateFormat().parse(node.get("time").asText());
        }
        if (node.has("data")) {
            cloudEvent.data = mapper.treeToValue((TreeNode)node.get("data"), type);
        }
        return cloudEvent;
    }

    private CloudEvent() {
    }

    public String getSpecversion() {
        return this.specversion;
    }

    public Date getTime() {
        return this.time;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getSource() {
        return this.source;
    }

    public T getData() {
        return this.data;
    }

    public String toString() {
        return "CloudEvent [specversion=" + this.specversion + ", time=" + this.time + ", id=" + this.id + ", type=" + this.type + ", source=" + this.source + ", data=" + this.data + "]";
    }
}

