/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.kafka;

import java.io.IOException;
import java.text.ParseException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ListenerSupport;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.model.DeployedAsset;
import org.jbpm.services.api.model.MessageDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.SignalDesc;
import org.jbpm.services.api.model.SignalDescBase;
import org.kie.api.event.process.MessageEvent;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.process.SignalEvent;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.InternalRegisterableItemsFactory;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.jbpm.kafka.CloudEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaServerExtension
implements KieServerExtension,
DeploymentEventListener,
ProcessEventListener,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(KafkaServerExtension.class);
    public static final String EXTENSION_NAME = "Kafka";
    static final String KAFKA_EXTENSION_PREFIX = "org.kie.server.jbpm-kafka.ext.";
    static final String TOPIC_PREFIX = "org.kie.server.jbpm-kafka.ext.topics.";
    static final String SIGNAL_MAPPING_PROPERTY = "org.kie.server.jbpm-kafka.ext.signals.mapping";
    static final String MESSAGE_MAPPING_PROPERTY = "org.kie.server.jbpm-kafka.ext.message.mapping";
    private static final Mapping SIGNAL_MAPPING_DEFAULT = Mapping.NONE;
    private static final Mapping MESSAGE_MAPPING_DEFAULT = Mapping.AUTO;
    private AtomicBoolean initialized = new AtomicBoolean();
    private Consumer<String, byte[]> consumer;
    private Producer<String, byte[]> producer;
    private ListenerSupport deploymentService;
    private ProcessService processService;
    private AtomicReference<ExecutorService> notifyService = new AtomicReference();
    private Map<String, Map<SignalDesc, Collection<String>>> topic2Signal = new HashMap<String, Map<SignalDesc, Collection<String>>>();
    private Map<String, Map<MessageDesc, Collection<String>>> topic2Message = new HashMap<String, Map<MessageDesc, Collection<String>>>();
    private Map<String, Collection<Class<?>>> classes = new ConcurrentHashMap();
    private AtomicBoolean consumerReady = new AtomicBoolean();
    private AtomicBoolean producerReady = new AtomicBoolean();
    private Lock changeRegistrationLock = new ReentrantLock();
    private Lock consumerLock = new ReentrantLock();
    private Condition isSubscribedCond = this.changeRegistrationLock.newCondition();
    private Signaller messageSignaller = (deployment, signalName, data) -> this.signalEvent(deployment, "Message-" + signalName, data);

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public boolean isActive() {
        return !Boolean.parseBoolean(System.getProperty("org.kie.kafka.server.ext.disabled", "true"));
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        if (this.initialized.get()) {
            logger.warn("Kafka extension already initialized");
            return;
        }
        KieServerExtension jbpmExt = registry.getServerExtension("jBPM");
        if (jbpmExt == null) {
            logger.warn("Extension jBPM is required");
            return;
        }
        for (Object service : jbpmExt.getServices()) {
            if (this.deploymentService == null && DeploymentService.class.isAssignableFrom(service.getClass())) {
                this.deploymentService = (ListenerSupport)service;
            } else if (this.processService == null && ProcessService.class.isAssignableFrom(service.getClass())) {
                this.processService = (ProcessService)service;
            }
            if (this.deploymentService == null || this.processService == null) continue;
            break;
        }
        if (this.deploymentService == null) {
            throw new IllegalStateException("Cannot find deployment service");
        }
        if (this.processService == null) {
            throw new IllegalStateException("Cannot find process service");
        }
        this.deploymentService.addListener((DeploymentEventListener)this);
        this.initialized.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
        if (this.deploymentService != null) {
            this.deploymentService.removeListener((DeploymentEventListener)this);
        }
        Duration duration = Duration.ofSeconds(Long.getLong("org.kie.server.jbpm-kafka.ext.close.timeout", 30L));
        if (this.producerReady.compareAndSet(true, false)) {
            this.producer.close(duration);
        }
        this.changeRegistrationLock.lock();
        try {
            this.topic2Signal.clear();
            this.topic2Message.clear();
            this.isSubscribedCond.signal();
            if (this.consumerReady.compareAndSet(true, false)) {
                ((ExecutorService)this.notifyService.getAndSet(null)).shutdownNow();
                this.unsubscribe();
                this.consumer.close(duration);
                this.consumer = null;
            }
        }
        finally {
            this.changeRegistrationLock.unlock();
        }
        this.classes.clear();
        this.processService = null;
        this.deploymentService = null;
        this.initialized.set(false);
    }

    protected Consumer<String, byte[]> getKafkaConsumer() {
        Map<String, Object> props = this.initCommonConfig();
        props.put("isolation.level", IsolationLevel.READ_COMMITTED.toString().toLowerCase());
        String autoCreateTopics = System.getProperty("org.kie.server.jbpm-kafka.ext.allow.auto.create.topics");
        if (autoCreateTopics != null) {
            props.put("allow.auto.create.topics", Boolean.parseBoolean(autoCreateTopics));
        }
        props.put("group.id", System.getProperty("org.kie.server.jbpm-kafka.ext.group.id", "jbpm-consumer"));
        return new KafkaConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    protected Producer<String, byte[]> getKafkaProducer() {
        Map<String, Object> props = this.initCommonConfig();
        String acks = System.getProperty("org.kie.server.jbpm-kafka.ext.acks");
        if (acks != null) {
            props.put("acks", acks);
        }
        props.put("max.block.ms", Long.getLong("org.kie.server.jbpm-kafka.ext.max.block.ms", 2000L));
        return new KafkaProducer(props, (Serializer)new StringSerializer(), (Serializer)new ByteArraySerializer());
    }

    private Map<String, Object> initCommonConfig() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("bootstrap.servers", System.getProperty("org.kie.server.jbpm-kafka.ext.bootstrap.servers", "localhost:9092"));
        String clientId = System.getProperty("org.kie.server.jbpm-kafka.ext.client.id");
        if (clientId != null) {
            configs.put("client.id", clientId);
        }
        return configs;
    }

    public void onDeploy(DeploymentEvent event) {
        ((InternalRegisterableItemsFactory)((InternalRuntimeManager)event.getDeployedUnit().getRuntimeManager()).getEnvironment().getRegisterableItemsFactory()).addProcessListener((ProcessEventListener)this);
        this.updateRegistration(event, this::updateTopics);
    }

    public void onUnDeploy(DeploymentEvent event) {
        this.updateRegistration(event, this::removeTopics);
    }

    public void onActivate(DeploymentEvent event) {
        this.updateRegistration(event, this::updateTopics);
    }

    public void onDeactivate(DeploymentEvent event) {
        this.updateRegistration(event, this::removeTopics);
    }

    private void updateTopics(String deploymentId, ProcessDefinition processDefinition) {
        if (KafkaServerExtension.processSignals()) {
            this.updateTopics(this.topic2Signal, deploymentId, processDefinition.getSignalsDesc());
        }
        if (KafkaServerExtension.processMessages()) {
            this.updateTopics(this.topic2Message, deploymentId, processDefinition.getMessagesDesc());
        }
    }

    private void removeTopics(String deploymentId, ProcessDefinition processDefinition) {
        this.removeTopics(this.topic2Signal, deploymentId, processDefinition.getSignalsDesc());
        this.removeTopics(this.topic2Message, deploymentId, processDefinition.getMessagesDesc());
    }

    private <T extends SignalDescBase> void updateTopics(Map<String, Map<T, Collection<String>>> topic2SignalBase, String deploymentId, Collection<T> signals) {
        for (SignalDescBase signal : signals) {
            if (signal.getIncomingNodes().isEmpty()) continue;
            topic2SignalBase.computeIfAbsent(KafkaServerExtension.topicFromSignal(signal), k -> new HashMap()).computeIfAbsent(signal, k -> new ArrayList()).add(deploymentId);
        }
    }

    private <T extends SignalDescBase> void removeTopics(Map<String, Map<T, Collection<String>>> topic2SignalBase, String deploymentId, Collection<T> signalsDesc) {
        for (SignalDescBase signal : signalsDesc) {
            Collection<String> deploymentIds;
            String topic = KafkaServerExtension.topicFromSignal(signal);
            Map<T, Collection<String>> signals = topic2SignalBase.get(topic);
            if (signals == null || (deploymentIds = signals.get(signal)) == null) continue;
            deploymentIds.remove(deploymentId);
            if (!deploymentIds.isEmpty()) continue;
            signals.remove(signal);
            if (!signals.isEmpty()) continue;
            topic2SignalBase.remove(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRegistration(DeploymentEvent event, BiConsumer<String, ProcessDefinition> updater) {
        this.classes.put(event.getDeploymentId(), event.getDeployedUnit().getDeployedClasses());
        HashSet<String> topic2Register = new HashSet<String>();
        this.changeRegistrationLock.lock();
        try {
            for (DeployedAsset asset : event.getDeployedUnit().getDeployedAssets()) {
                updater.accept(event.getDeploymentId(), (ProcessDefinition)asset);
            }
            topic2Register.addAll(this.topic2Signal.keySet());
            topic2Register.addAll(this.topic2Message.keySet());
            if (topic2Register.isEmpty()) {
                if (this.consumerReady.get()) {
                    this.unsubscribe();
                }
            } else if (this.consumerReady.compareAndSet(false, true)) {
                logger.trace("Creating kafka consumer");
                this.consumer = this.getKafkaConsumer();
                this.subscribe(topic2Register);
                this.notifyService.set(new ThreadPoolExecutor(1, Integer.getInteger("org.kie.server.jbpm-kafka.ext.maxNotifyThreads", 10), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
                new Thread(this).start();
            } else {
                this.consumer.wakeup();
                this.subscribe(topic2Register);
                this.isSubscribedCond.signal();
            }
        }
        finally {
            this.changeRegistrationLock.unlock();
        }
    }

    private void subscribe(Set<String> topic2Register) {
        this.consumerLock.lock();
        try {
            this.consumer.subscribe(topic2Register);
        }
        finally {
            this.consumerLock.unlock();
        }
        logger.debug("Updated kafka subscription list to these topics {}", topic2Register);
    }

    private void unsubscribe() {
        this.consumer.wakeup();
        this.consumerLock.lock();
        try {
            this.consumer.unsubscribe();
        }
        finally {
            this.consumerLock.unlock();
        }
        logger.debug("All topics unsubscribed");
    }

    private static <T extends SignalDescBase> String topicFromSignal(T signal) {
        return KafkaServerExtension.topicFromSignal(signal.getName());
    }

    private static String topicFromSignal(String name) {
        return System.getProperty(TOPIC_PREFIX + name, name);
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public String getImplementedCapability() {
        return "BPM-KAFKA";
    }

    public List<Object> getServices() {
        return Collections.emptyList();
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 20;
    }

    public String toString() {
        return "Kafka KIE Server extension";
    }

    @Override
    public void run() {
        Duration duration = Duration.ofSeconds(Long.getLong("org.kie.server.jbpm-kafka.ext.poll.interval", 10L));
        logger.trace("Start polling kafka consumer every {} seconds", (Object)duration.getSeconds());
        try {
            while (this.consumerReady.get()) {
                this.checkSubscribed();
                this.dispatchEvents(this.pollEvents(duration));
            }
        }
        catch (InterruptedException e) {
            logger.warn("Polling thread interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.error("Polling thread unexpectedly finished", (Throwable)e);
        }
        logger.trace("Kafka polling stopped");
    }

    private void checkSubscribed() throws InterruptedException {
        this.changeRegistrationLock.lock();
        try {
            while (this.consumerReady.get() && this.topic2Signal.isEmpty() && this.topic2Message.isEmpty()) {
                this.isSubscribedCond.await();
            }
        }
        finally {
            this.changeRegistrationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerRecords<String, byte[]> pollEvents(Duration duration) {
        ConsumerRecords events = ConsumerRecords.empty();
        if (this.consumerReady.get()) {
            try {
                this.consumerLock.lock();
                events = this.consumer.poll(duration);
            }
            catch (WakeupException ex) {
                logger.trace("Kafka wait interrupted");
            }
            catch (Exception ex) {
                logger.error("Error polling Kafka consumer", (Throwable)ex);
            }
            finally {
                this.consumerLock.unlock();
            }
        }
        return events;
    }

    private void dispatchEvents(ConsumerRecords<String, byte[]> events) {
        if (this.consumerReady.get() && !events.isEmpty()) {
            if (logger.isDebugEnabled()) {
                this.printEventsLog(events);
            }
            for (ConsumerRecord event : events) {
                this.notifyService.get().submit(() -> this.processEvent((ConsumerRecord<String, byte[]>)event));
            }
        }
    }

    private void printEventsLog(ConsumerRecords<String, byte[]> events) {
        HashMap<String, Integer> eventsPerTopic = new HashMap<String, Integer>();
        for (ConsumerRecord event : events) {
            eventsPerTopic.compute(event.topic(), (k, v) -> {
                int n;
                if (v == null) {
                    n = 1;
                } else {
                    Integer n2 = v;
                    Integer n3 = v = Integer.valueOf(v + 1);
                    n = n2;
                }
                return n;
            });
        }
        logger.debug("Number of events received per topic {}", eventsPerTopic);
    }

    private void processEvent(ConsumerRecord<String, byte[]> event) {
        this.changeRegistrationLock.lock();
        try {
            this.processEvent(this.topic2Signal, event, this::signalEvent);
            this.processEvent(this.topic2Message, event, this.messageSignaller);
        }
        finally {
            this.changeRegistrationLock.unlock();
        }
    }

    private void signalEvent(String deployment, String signalName, Object data) {
        this.processService.signalEvent(deployment, signalName, data);
    }

    private <T extends SignalDescBase> void processEvent(Map<String, Map<T, Collection<String>>> topic2SignalBase, ConsumerRecord<String, byte[]> event, Signaller signaller) {
        Map<T, Collection<String>> signalInfo = topic2SignalBase.get(event.topic());
        if (signalInfo != null) {
            for (Map.Entry<T, Collection<String>> entry : signalInfo.entrySet()) {
                try {
                    String signalName = ((SignalDescBase)entry.getKey()).getName();
                    for (String deploymentId : entry.getValue()) {
                        CloudEvent<?> cloudEvent = CloudEvent.read((byte[])event.value(), this.getDataClass(deploymentId, (SignalDescBase)entry.getKey()));
                        logger.debug("Sending event with name {} to deployment {} with data {}", new Object[]{signalName, deploymentId, cloudEvent.getData()});
                        signaller.signalEvent(deploymentId, signalName, cloudEvent.getData());
                    }
                }
                catch (IOException | ClassNotFoundException | ParseException e) {
                    logger.error("Error deserializing event", (Throwable)e);
                }
            }
        }
    }

    private <T extends SignalDescBase> Class<?> getDataClass(String deploymentId, T signalDesc) throws ClassNotFoundException {
        Optional<Class> dataClazz = Optional.empty();
        String className = signalDesc.getStructureRef();
        if (className != null) {
            Collection<Class<?>> deployedClasses = this.classes.get(deploymentId);
            if (deployedClasses != null) {
                dataClazz = deployedClasses.stream().filter(c -> c.getCanonicalName().equals(className) || c.getSimpleName().equals(className) || c.getTypeName().equals(className)).findAny();
            }
            if (!dataClazz.isPresent()) {
                logger.debug("Class {} has not been found in deployment {}, trying from classloader", (Object)className, (Object)deploymentId);
                dataClazz = Optional.of(Class.forName(className.contains(".") ? className : "java.lang." + className));
            }
        }
        return dataClazz.orElse(Object.class);
    }

    public void onMessage(MessageEvent event) {
        if (KafkaServerExtension.processMessages()) {
            this.sendEvent(event.getProcessInstance(), event.getMessageName(), event.getMessage());
        }
    }

    public void onSignal(SignalEvent event) {
        if (KafkaServerExtension.processSignals(event)) {
            this.sendEvent(event.getProcessInstance(), event.getSignalName(), event.getSignal());
        }
    }

    private void sendEvent(ProcessInstance processInstance, String name, Object value) {
        if (this.producerReady.compareAndSet(false, true)) {
            this.producer = this.getKafkaProducer();
        }
        try {
            this.producer.send(new ProducerRecord(KafkaServerExtension.topicFromSignal(name), (Object)CloudEvent.write(processInstance.getProcessId(), processInstance.getId(), value)), (m, e) -> {
                if (e != null) {
                    this.logError(value, e);
                }
            });
        }
        catch (Exception e2) {
            this.logError(value, e2);
        }
    }

    private static Mapping getMapping(String propName, Mapping defaultValue) {
        Mapping result = null;
        String propValue = System.getProperty(propName);
        if (propValue != null) {
            try {
                result = Mapping.valueOf(propValue.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                logger.warn("Wrong value {} for property {}, using default {}", new Object[]{propValue, propName, defaultValue});
            }
        }
        return result == null ? defaultValue : result;
    }

    private static boolean processMessages() {
        return KafkaServerExtension.getMapping(MESSAGE_MAPPING_PROPERTY, MESSAGE_MAPPING_DEFAULT) == Mapping.AUTO;
    }

    private static boolean processSignals() {
        return KafkaServerExtension.getMapping(SIGNAL_MAPPING_PROPERTY, SIGNAL_MAPPING_DEFAULT) == Mapping.AUTO;
    }

    private static boolean processSignals(SignalEvent event) {
        Mapping mapping = KafkaServerExtension.getMapping(SIGNAL_MAPPING_PROPERTY, SIGNAL_MAPPING_DEFAULT);
        return mapping == Mapping.AUTO || "##kafka".equalsIgnoreCase((String)event.getNodeInstance().getNode().getMetaData().get("implementation"));
    }

    private void logError(Object value, Exception e) {
        logger.error("Error publishing event {}", value, (Object)e);
    }

    public void serverStarted() {
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void prepareContainerUpdate(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        return Collections.emptyList();
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        return null;
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
    }

    @FunctionalInterface
    private static interface Signaller {
        public void signalEvent(String var1, String var2, Object var3);
    }

    static enum Mapping {
        AUTO,
        NONE;

    }
}

