/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jbpm.executor.AsyncJobException;
import org.jbpm.executor.entities.ErrorInfo;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.impl.ClassCacheManager;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.event.ExecutorEventSupport;
import org.jbpm.executor.impl.event.ExecutorEventSupportImpl;
import org.jbpm.process.core.async.AsyncExecutionMarker;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandCallback;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.Executor;
import org.kie.api.executor.ExecutorQueryService;
import org.kie.api.executor.ExecutorStoreService;
import org.kie.api.executor.Reoccurring;
import org.kie.api.executor.STATUS;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAvailableJobsExecutor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAvailableJobsExecutor.class);
    protected int retries = Integer.parseInt(System.getProperty("org.kie.executor.retry.count", "3"));
    protected Map<String, Object> contextData = new HashMap<String, Object>();
    protected ExecutorQueryService queryService;
    protected ClassCacheManager classCacheManager;
    protected ExecutorStoreService executorStoreService;
    protected ExecutorEventSupport eventSupport = new ExecutorEventSupportImpl();
    protected Executor executor;

    public void setEventSupport(ExecutorEventSupport eventSupport) {
        this.eventSupport = eventSupport;
    }

    public void setQueryService(ExecutorQueryService queryService) {
        this.queryService = queryService;
    }

    public void setClassCacheManager(ClassCacheManager classCacheManager) {
        this.classCacheManager = classCacheManager;
    }

    public void setExecutorStoreService(ExecutorStoreService executorStoreService) {
        this.executorStoreService = executorStoreService;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public void executeGivenJob(RequestInfo request) {
        block31: {
            Throwable exception = null;
            try {
                ClassLoader cl;
                List<CommandCallback> callbacks;
                ExecutionResults results;
                CommandContext ctx;
                Command cmd;
                boolean processReoccurring;
                block35: {
                    block33: {
                        AsyncExecutionMarker.markAsync();
                        this.eventSupport.fireBeforeJobExecuted((org.kie.api.executor.RequestInfo)request, null);
                        if (request == null) break block31;
                        processReoccurring = false;
                        cmd = null;
                        ctx = null;
                        results = null;
                        callbacks = null;
                        cl = this.getClassLoader(request.getDeploymentId());
                        logger.debug("Processing Request Id: {}, status {} command {}", new Object[]{request.getId(), request.getStatus(), request.getCommandName()});
                        byte[] reqData = request.getRequestData();
                        if (reqData != null) {
                            try (ClassLoaderObjectInputStream in = null;){
                                in = new ClassLoaderObjectInputStream(cl, (InputStream)new ByteArrayInputStream(reqData));
                                ctx = (CommandContext)in.readObject();
                            }
                        }
                        if (request.getResponseData() != null) break block33;
                        for (Map.Entry entry : this.contextData.entrySet()) {
                            ctx.setData((String)entry.getKey(), entry.getValue());
                        }
                        ctx.setData("ClassLoader", (Object)cl);
                        cmd = this.classCacheManager.findCommand(request.getCommandName(), cl);
                        request.setExecutions(request.getExecutions() + 1);
                        results = cmd.execute(ctx);
                        if (results == null) {
                            results = new ExecutionResults();
                        }
                        try {
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            ObjectOutputStream out = new ObjectOutputStream(bout);
                            out.writeObject(results);
                            byte[] respData = bout.toByteArray();
                            request.setResponseData(respData);
                        }
                        catch (IOException e) {
                            request.setResponseData(null);
                        }
                        results.setData("CompletedAt", (Object)new Date());
                        request.setStatus(STATUS.DONE);
                        this.executorStoreService.updateRequest((org.kie.api.executor.RequestInfo)request, null);
                        processReoccurring = true;
                        break block35;
                    }
                    logger.debug("Job was already successfully executed, retrying callbacks only...");
                    byte[] resData = request.getResponseData();
                    if (resData != null) {
                        try (ObjectInputStream in = null;){
                            in = new ClassLoaderObjectInputStream(cl, (InputStream)new ByteArrayInputStream(resData));
                            results = (ExecutionResults)in.readObject();
                        }
                    }
                    request.setStatus(STATUS.DONE);
                    this.executorStoreService.updateRequest((org.kie.api.executor.RequestInfo)request, null);
                    processReoccurring = true;
                }
                callbacks = this.classCacheManager.buildCommandCallback(ctx, cl);
                this.updateProcessInfoInContext(request, ctx);
                for (CommandCallback handler : callbacks) {
                    handler.onCommandDone(ctx, results);
                }
                ((ExecutorImpl)this.executor).clearExecution(request.getId());
                AsyncExecutionMarker.reset();
                this.handleCompletion(processReoccurring, cmd, ctx);
                this.eventSupport.fireAfterJobExecuted((org.kie.api.executor.RequestInfo)request, exception);
                break block31;
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break block31;
                }
                catch (Throwable e) {
                    exception = e;
                    if (callbacks == null) {
                        callbacks = this.classCacheManager.buildCommandCallback(ctx, cl);
                    }
                    processReoccurring = this.handleException(request, e, ctx, callbacks);
                    break block31;
                }
                finally {
                    ((ExecutorImpl)this.executor).clearExecution(request.getId());
                    AsyncExecutionMarker.reset();
                    this.handleCompletion(processReoccurring, cmd, ctx);
                    this.eventSupport.fireAfterJobExecuted((org.kie.api.executor.RequestInfo)request, exception);
                }
            }
            catch (Exception e) {
                logger.warn("Unexpected error while processin executor's job {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected ClassLoader getClassLoader(String deploymentId) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (deploymentId == null) {
            return cl;
        }
        InternalRuntimeManager manager = (InternalRuntimeManager)RuntimeManagerRegistry.get().getManager(deploymentId);
        if (manager != null && manager.getEnvironment().getClassLoader() != null) {
            cl = manager.getEnvironment().getClassLoader();
        }
        return cl;
    }

    public void addContextData(String name, Object data) {
        this.contextData.put(name, data);
    }

    protected boolean handleException(RequestInfo request, Throwable e, CommandContext ctx, List<CommandCallback> callbacks) {
        logger.warn("Error during command {} error message {}", new Object[]{request.getCommandName(), e.getMessage(), e});
        ErrorInfo errorInfo = new ErrorInfo(e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e.fillInStackTrace()));
        errorInfo.setRequestInfo(request);
        request.getErrorInfo().add(errorInfo);
        logger.debug("Error Number: {}", (Object)request.getErrorInfo().size());
        if (request.getRetries() > 0) {
            request.setStatus(STATUS.RETRYING);
            request.setRetries(request.getRetries() - 1);
            List retryDelay = (List)ctx.getData("retryDelay");
            if (retryDelay != null) {
                long retryAdd = 0L;
                try {
                    retryAdd = (Long)retryDelay.get(request.getExecutions() - 1);
                }
                catch (IndexOutOfBoundsException ex) {
                    retryAdd = (Long)retryDelay.get(retryDelay.size() - 1);
                }
                request.setTime(new Date(System.currentTimeMillis() + retryAdd));
                logger.info("Retrying request ( with id {}) - delay configured, next retry at {}", (Object)request.getId(), (Object)request.getTime());
            }
            logger.debug("Retrying ({}) still available!", (Object)request.getRetries());
            this.executorStoreService.updateRequest((org.kie.api.executor.RequestInfo)request, ((ExecutorImpl)this.executor).scheduleExecution(request, request.getTime()));
            return false;
        }
        logger.debug("Error no retries left!");
        request.setStatus(STATUS.ERROR);
        this.executorStoreService.updateRequest((org.kie.api.executor.RequestInfo)request, null);
        this.updateProcessInfoInContext(request, ctx);
        AsyncJobException wrappedException = new AsyncJobException(request.getId(), request.getCommandName(), e);
        if (callbacks != null) {
            for (CommandCallback handler : callbacks) {
                handler.onCommandError(ctx, (Throwable)wrappedException);
            }
        }
        return true;
    }

    protected void handleCompletion(boolean processReoccurring, Command cmd, CommandContext ctx) {
        if (processReoccurring && cmd != null && cmd instanceof Reoccurring) {
            Date current = new Date();
            Date nextScheduleTime = ((Reoccurring)cmd).getScheduleTime();
            if (nextScheduleTime != null && nextScheduleTime.after(current)) {
                String businessKey = (String)ctx.getData("businessKey");
                RequestInfo requestInfo = new RequestInfo();
                requestInfo.setCommandName(cmd.getClass().getName());
                requestInfo.setKey(businessKey);
                requestInfo.setStatus(STATUS.QUEUED);
                requestInfo.setTime(nextScheduleTime);
                requestInfo.setMessage("Rescheduled reoccurring job");
                requestInfo.setDeploymentId((String)ctx.getData("deploymentId"));
                requestInfo.setProcessInstanceId((Long)ctx.getData("processInstanceId"));
                requestInfo.setOwner((String)ctx.getData("owner"));
                if (ctx.getData("retries") != null) {
                    requestInfo.setRetries(Integer.valueOf(String.valueOf(ctx.getData("retries"))));
                } else {
                    requestInfo.setRetries(this.retries);
                }
                if (ctx != null) {
                    try {
                        ctx.getData().remove("ClassLoader");
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        ObjectOutputStream oout = new ObjectOutputStream(bout);
                        oout.writeObject(ctx);
                        requestInfo.setRequestData(bout.toByteArray());
                    }
                    catch (IOException e) {
                        logger.warn("Error serializing context data", (Throwable)e);
                        requestInfo.setRequestData(null);
                    }
                }
                this.eventSupport.fireBeforeJobScheduled((org.kie.api.executor.RequestInfo)requestInfo, null);
                this.executorStoreService.persistRequest((org.kie.api.executor.RequestInfo)requestInfo, ((ExecutorImpl)this.executor).scheduleExecution(requestInfo, requestInfo.getTime()));
                this.eventSupport.fireAfterJobScheduled((org.kie.api.executor.RequestInfo)requestInfo, null);
            }
        }
    }

    protected void updateProcessInfoInContext(RequestInfo requestInfo, CommandContext ctx) {
        if (requestInfo.getDeploymentId() != null) {
            ctx.setData("deploymentId", (Object)requestInfo.getDeploymentId());
        }
        if (requestInfo.getProcessInstanceId() != null) {
            ctx.setData("processInstanceId", (Object)requestInfo.getProcessInstanceId());
        }
    }
}

