/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.UpdateContext;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.EmptyLeftTupleSinkAdapter;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.ObjectType;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.bitmask.EmptyBitMask;

public abstract class AbstractTerminalNode
extends BaseNode
implements TerminalNode,
PathEndNode,
Externalizable {
    private LeftTupleSource tupleSource;
    private BitMask declaredMask = EmptyBitMask.get();
    private BitMask inferredMask = EmptyBitMask.get();
    private BitMask negativeMask = EmptyBitMask.get();
    private LeftTupleNode[] pathNodes;
    private transient PathEndNode[] pathEndNodes;
    private PathEndNode.PathMemSpec pathMemSpec;

    public AbstractTerminalNode() {
    }

    public AbstractTerminalNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, LeftTupleSource source, BuildContext context) {
        super(id, partitionId, partitionsEnabled);
        this.tupleSource = source;
        context.addPathEndNode(this);
        this.initMemoryId(context);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.declaredMask = (BitMask)in.readObject();
        this.inferredMask = (BitMask)in.readObject();
        this.negativeMask = (BitMask)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.tupleSource);
        out.writeObject(this.declaredMask);
        out.writeObject(this.inferredMask);
        out.writeObject(this.negativeMask);
    }

    @Override
    public PathEndNode.PathMemSpec getPathMemSpec() {
        if (this.pathMemSpec == null) {
            this.pathMemSpec = this.calculatePathMemSpec(null);
        }
        return this.pathMemSpec;
    }

    @Override
    public void resetPathMemSpec(TerminalNode removingTN) {
        this.pathMemSpec = removingTN == null ? null : this.calculatePathMemSpec(null, removingTN);
    }

    @Override
    public void setPathEndNodes(PathEndNode[] pathEndNodes) {
        this.pathEndNodes = pathEndNodes;
    }

    @Override
    public PathEndNode[] getPathEndNodes() {
        return this.pathEndNodes;
    }

    @Override
    public int getPositionInPath() {
        return this.tupleSource.getPositionInPath() + 1;
    }

    protected void initDeclaredMask(BuildContext context) {
        if (!(this.unwrapTupleSource() instanceof LeftInputAdapterNode)) {
            this.setDeclaredMask(AllSetBitMask.get());
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[0];
        ObjectType objectType = pattern.getObjectType();
        if (!(objectType instanceof ClassObjectType)) {
            this.setDeclaredMask(AllSetBitMask.get());
            return;
        }
        Class<?> objectClass = ((ClassObjectType)objectType).getClassType();
        TypeDeclaration typeDeclaration = context.getKnowledgeBase().getTypeDeclaration(objectClass);
        if (typeDeclaration == null || !typeDeclaration.isPropertyReactive()) {
            this.setDeclaredMask(AllSetBitMask.get());
        } else {
            List<String> accessibleProperties = pattern.getAccessibleProperties(context.getKnowledgeBase());
            this.setDeclaredMask(pattern.getPositiveWatchMask(accessibleProperties));
            this.setNegativeMask(pattern.getNegativeWatchMask(accessibleProperties));
        }
    }

    @Override
    public void initInferredMask() {
        LeftTupleSource leftTupleSource = this.unwrapTupleSource();
        if (leftTupleSource instanceof LeftInputAdapterNode && ((LeftInputAdapterNode)leftTupleSource).getParentObjectSource() instanceof AlphaNode) {
            AlphaNode alphaNode = (AlphaNode)((LeftInputAdapterNode)leftTupleSource).getParentObjectSource();
            this.setInferredMask(alphaNode.updateMask(this.getDeclaredMask()));
        } else {
            this.setInferredMask(this.getDeclaredMask());
        }
        this.setInferredMask(this.getInferredMask().resetAll(this.getNegativeMask()));
        if (this.getNegativeMask().isAllSet() && !this.getDeclaredMask().isAllSet()) {
            this.setInferredMask(this.getInferredMask().setAll(this.getDeclaredMask()));
        }
    }

    @Override
    public LeftTupleSource unwrapTupleSource() {
        return this.tupleSource instanceof FromNode ? this.tupleSource.getLeftTupleSource() : this.tupleSource;
    }

    @Override
    public abstract RuleImpl getRule();

    @Override
    public PathMemory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        return AbstractTerminalNode.initPathMemory(this, new PathMemory(this, wm));
    }

    public static PathMemory initPathMemory(PathEndNode pathEndNode, PathMemory pmem) {
        PathEndNode.PathMemSpec pathMemSpec = pathEndNode.getPathMemSpec();
        pmem.setAllLinkedMaskTest(pathMemSpec.allLinkedTestMask);
        pmem.setSegmentMemories(new SegmentMemory[pathMemSpec.smemCount]);
        return pmem;
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        RuleTerminalNodeLeftTuple peer = new RuleTerminalNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        this.getLeftTupleSource().removeTupleSink(this);
        this.tupleSource = null;
        return true;
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    @Override
    public BitMask getDeclaredMask() {
        return this.declaredMask;
    }

    @Override
    public BitMask getInferredMask() {
        return this.inferredMask;
    }

    @Override
    public BitMask getLeftInferredMask() {
        return this.inferredMask;
    }

    @Override
    public void setDeclaredMask(BitMask mask) {
        this.declaredMask = mask;
    }

    @Override
    public void setInferredMask(BitMask mask) {
        this.inferredMask = mask;
    }

    @Override
    public BitMask getNegativeMask() {
        return this.negativeMask;
    }

    @Override
    public void setNegativeMask(BitMask mask) {
        this.negativeMask = mask;
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.getLeftTupleSource().networkUpdated(updateContext);
    }

    @Override
    public boolean isInUse() {
        return false;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
    }

    public static LeftTupleNode[] getPathNodes(PathEndNode endNode) {
        LeftTupleNode[] pathNodes = new LeftTupleNode[endNode.getPositionInPath() + 1];
        for (LeftTupleNode node = endNode; node != null; node = node.getLeftTupleSource()) {
            pathNodes[node.getPositionInPath()] = node;
        }
        return pathNodes;
    }

    @Override
    public LeftTupleNode[] getPathNodes() {
        if (this.pathNodes == null) {
            this.pathNodes = AbstractTerminalNode.getPathNodes(this);
        }
        return this.pathNodes;
    }

    @Override
    public final boolean hasPathNode(LeftTupleNode node) {
        for (LeftTupleNode pathNode : this.getPathNodes()) {
            if (node.getId() != pathNode.getId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isTerminalNodeOf(LeftTupleNode node) {
        for (PathEndNode pathEndNode : this.getPathEndNodes()) {
            if (!pathEndNode.hasPathNode(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LeftTupleSinkPropagator getSinkPropagator() {
        return EmptyLeftTupleSinkAdapter.getInstance();
    }

    @Override
    public final void setPartitionIdWithSinks(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        return this.getLeftTupleSource().getObjectTypeNode();
    }
}

