/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.EmptyLeftTupleSinkAdapter;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RiaPathMemory;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.definition.rule.Rule;

public class RightInputAdapterNode
extends ObjectSource
implements LeftTupleSinkNode,
PathEndNode,
MemoryFactory<RiaNodeMemory> {
    private static final long serialVersionUID = 510L;
    private LeftTupleSource tupleSource;
    private LeftTupleSource startTupleSource;
    private boolean tupleMemoryEnabled;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private LeftTupleNode[] pathNodes;
    private PathEndNode[] pathEndNodes;
    private PathEndNode.PathMemSpec pathMemSpec;

    public RightInputAdapterNode() {
    }

    public RightInputAdapterNode(int id, LeftTupleSource source, LeftTupleSource startTupleSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getKnowledgeBase().getConfiguration().isMultithreadEvaluation());
        this.tupleSource = source;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.startTupleSource = startTupleSource;
        this.hashcode = this.calculateHashCode();
        this.initMemoryId(context);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.tupleMemoryEnabled = in.readBoolean();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.startTupleSource = (LeftTupleSource)in.readObject();
        this.pathEndNodes = (PathEndNode[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
        out.writeObject(this.startTupleSource);
        out.writeObject(this.pathEndNodes);
    }

    @Override
    public PathEndNode.PathMemSpec getPathMemSpec() {
        if (this.pathMemSpec == null) {
            this.pathMemSpec = this.calculatePathMemSpec(this.startTupleSource);
        }
        return this.pathMemSpec;
    }

    @Override
    public void resetPathMemSpec(TerminalNode removingTN) {
        this.pathMemSpec = removingTN == null ? null : this.calculatePathMemSpec(null, removingTN);
    }

    @Override
    public void setPathEndNodes(PathEndNode[] pathEndNodes) {
        this.pathEndNodes = pathEndNodes;
    }

    @Override
    public PathEndNode[] getPathEndNodes() {
        return this.pathEndNodes;
    }

    public LeftTupleSource getStartTupleSource() {
        return this.startTupleSource;
    }

    @Override
    public int getPositionInPath() {
        return this.tupleSource.getPositionInPath() + 1;
    }

    @Override
    public RiaNodeMemory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        RiaNodeMemory rianMem = new RiaNodeMemory();
        RiaPathMemory pmem = new RiaPathMemory(this, wm);
        PathEndNode.PathMemSpec pathMemSpec = this.getPathMemSpec();
        pmem.setAllLinkedMaskTest(pathMemSpec.allLinkedTestMask);
        pmem.setSegmentMemories(new SegmentMemory[pathMemSpec.smemCount]);
        rianMem.setRiaPathMemory(pmem);
        return rianMem;
    }

    @Override
    public SubnetworkTuple createPeer(LeftTuple original) {
        SubnetworkTuple peer = new SubnetworkTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public void attach(BuildContext context) {
        this.tupleSource.addTupleSink(this, context);
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.tupleSource.networkUpdated(updateContext);
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.tupleSource.removeTupleSink(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 71;
    }

    private int calculateHashCode() {
        return this.tupleSource.hashCode() * 17 + (this.tupleMemoryEnabled ? 1234 : 4321);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof RightInputAdapterNode && this.hashCode() == object.hashCode() && this.tupleSource.getId() == ((RightInputAdapterNode)object).tupleSource.getId() && this.tupleMemoryEnabled == ((RightInputAdapterNode)object).tupleMemoryEnabled;
    }

    @Override
    public String toString() {
        return "RightInputAdapterNode(" + this.id + ")[ tupleMemoryEnabled=" + this.tupleMemoryEnabled + ", tupleSource=" + this.tupleSource + ", source=" + this.source + ", associations=" + this.associations + ", partitionId=" + this.partitionId + "]";
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        return new SubnetworkTuple(factHandle, this, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new SubnetworkTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new SubnetworkTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new SubnetworkTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new SubnetworkTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    public void setTupleSource(LeftTupleSource tupleSource) {
        this.tupleSource = tupleSource;
    }

    @Override
    public ObjectTypeNode.Id getLeftInputOtnId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLeftInputOtnId(ObjectTypeNode.Id leftInputOtnId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitMask calculateDeclaredMask(Class modifiedClass, List<String> settableProperties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitMask getLeftInferredMask() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LeftTupleNode[] getPathNodes() {
        if (this.pathNodes == null) {
            this.pathNodes = AbstractTerminalNode.getPathNodes(this);
        }
        return this.pathNodes;
    }

    @Override
    public boolean hasPathNode(LeftTupleNode node) {
        for (LeftTupleNode pathNode : this.getPathNodes()) {
            if (node.getId() != pathNode.getId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public LeftTupleSinkPropagator getSinkPropagator() {
        return EmptyLeftTupleSinkAdapter.getInstance();
    }

    @Override
    public void addAssociation(BuildContext context, Rule rule) {
        super.addAssociation(context, rule);
        context.addPathEndNode(this);
    }

    @Override
    public boolean removeAssociation(Rule rule) {
        boolean result = this.associations.remove(rule);
        if (this.getAssociationsSize() == 0) {
            return result;
        }
        ArrayList<PathEndNode> remainingPathNodes = new ArrayList<PathEndNode>();
        for (PathEndNode pathEndNode : this.pathEndNodes) {
            if (pathEndNode.getAssociationsSize() <= 0) continue;
            remainingPathNodes.add(pathEndNode);
        }
        this.pathEndNodes = remainingPathNodes.toArray(new PathEndNode[remainingPathNodes.size()]);
        return result;
    }

    public static class RiaNodeMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Memory {
        private RiaPathMemory pathMemory;

        public RiaPathMemory getRiaPathMemory() {
            return this.pathMemory;
        }

        public void setRiaPathMemory(RiaPathMemory pathMemory) {
            this.pathMemory = pathMemory;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.pathMemory.getSegmentMemory();
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            this.pathMemory.setSegmentMemory(segmentMemory);
        }

        @Override
        public short getNodeType() {
            return 71;
        }

        @Override
        public void reset() {
            this.pathMemory.reset();
        }
    }
}

