/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.kafka;

import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.errors.WakeupException;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.model.MessageDesc;
import org.jbpm.services.api.model.SignalDesc;
import org.jbpm.services.api.model.SignalDescBase;
import org.kie.server.services.jbpm.kafka.KafkaEventProcessorFactory;
import org.kie.server.services.jbpm.kafka.KafkaServerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaServerConsumer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(KafkaServerConsumer.class);
    private Consumer<String, byte[]> consumer;
    private AtomicBoolean consumerReady = new AtomicBoolean();
    private AtomicReference<ExecutorService> notifyService = new AtomicReference();
    private ProcessService processService;
    private Map<String, ClassLoader> classLoaders = new ConcurrentHashMap<String, ClassLoader>();
    private KafkaServerRegistration registration = new KafkaServerRegistration();
    private Lock consumerLock = new ReentrantLock(true);
    private Condition isSubscribedCond = this.consumerLock.newCondition();
    private Supplier<Consumer<String, byte[]>> consumerSupplier;
    private KafkaEventProcessorFactory factory;
    private Signaller messageSignaller = (deployment, signalName, data) -> this.signalEvent(deployment, "Message-" + signalName, data);

    public KafkaServerConsumer(KafkaEventProcessorFactory factory, Supplier<Consumer<String, byte[]>> consumerSupplier, ProcessService processService) {
        this.factory = factory;
        this.consumerSupplier = consumerSupplier;
        this.processService = processService;
    }

    void addRegistration(DeploymentEvent event) {
        this.classLoaders.put(event.getDeploymentId(), ((KModuleDeploymentUnit)event.getDeployedUnit().getDeploymentUnit()).getKieContainer().getClassLoader());
        this.registrationUpdated(event, this.registration.addRegistration(event));
    }

    void removeRegistration(DeploymentEvent event) {
        this.classLoaders.remove(event.getDeploymentId());
        this.registrationUpdated(event, this.registration.removeRegistration(event));
    }

    void close(Duration duration) {
        this.registration.close();
        if (this.consumerReady.compareAndSet(true, false)) {
            this.consumer.wakeup();
            this.consumerLock.lock();
            try {
                this.isSubscribedCond.signal();
                this.consumer.unsubscribe();
                this.consumer.close(duration);
                this.consumer = null;
                ((ExecutorService)this.notifyService.getAndSet(null)).shutdownNow();
            }
            finally {
                this.consumerLock.unlock();
            }
        }
        this.classLoaders.clear();
        this.processService = null;
    }

    private void registrationUpdated(DeploymentEvent event, Set<String> topics2Register) {
        if (this.consumerReady.compareAndSet(false, true)) {
            this.consumer = this.consumerSupplier.get();
            this.consumer.subscribe(topics2Register);
            logger.debug("Created kafka consumer with these topics registered {}", topics2Register);
            this.notifyService.set(new ThreadPoolExecutor(1, Integer.getInteger("org.kie.server.jbpm-kafka.ext.maxNotifyThreads", 10), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
            new Thread(this).start();
        } else {
            this.consumer.wakeup();
            this.consumerLock.lock();
            try {
                if (topics2Register.isEmpty()) {
                    this.consumer.unsubscribe();
                } else {
                    this.consumer.subscribe(topics2Register);
                    this.isSubscribedCond.signal();
                }
            }
            finally {
                this.consumerLock.unlock();
            }
            logger.debug("Updated kafka subscription list to these topics {}", topics2Register);
        }
    }

    @Override
    public void run() {
        Duration duration = Duration.ofSeconds(Long.getLong("org.kie.server.jbpm-kafka.ext.poll.interval", 10L));
        logger.trace("Start polling kafka consumer every {} seconds", (Object)duration.getSeconds());
        while (this.consumerReady.get()) {
            ConsumerRecords<String, byte[]> events = this.pollEvents(duration);
            this.dispatchEvents(events);
        }
        logger.trace("Kafka polling stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerRecords<String, byte[]> pollEvents(Duration duration) {
        ConsumerRecords events = ConsumerRecords.empty();
        this.consumerLock.lock();
        try {
            while (this.consumerReady.get() && this.registration.isEmpty()) {
                this.isSubscribedCond.await();
            }
            if (this.consumerReady.get()) {
                events = this.consumer.poll(duration);
            }
        }
        catch (WakeupException ex) {
            logger.trace("Kafka wait interrupted");
        }
        catch (Exception ex) {
            logger.error("Error polling Kafka consumer", (Throwable)ex);
        }
        finally {
            this.consumerLock.unlock();
        }
        return events;
    }

    private void dispatchEvents(ConsumerRecords<String, byte[]> events) {
        if (this.consumerReady.get() && !events.isEmpty()) {
            if (logger.isDebugEnabled()) {
                this.printEventsLog(events);
            }
            for (ConsumerRecord event : events) {
                this.notifyService.get().submit(() -> this.processEvent((ConsumerRecord<String, byte[]>)event));
            }
        }
    }

    private void printEventsLog(ConsumerRecords<String, byte[]> events) {
        HashMap<String, Integer> eventsPerTopic = new HashMap<String, Integer>();
        for (ConsumerRecord event : events) {
            eventsPerTopic.compute(event.topic(), (k, v) -> {
                int n;
                if (v == null) {
                    n = 1;
                } else {
                    Integer n2 = v;
                    Integer n3 = v = Integer.valueOf(v + 1);
                    n = n2;
                }
                return n;
            });
        }
        logger.debug("Number of events received per topic {}", eventsPerTopic);
    }

    private void signalEvent(String deployment, String signalName, Object data) {
        this.processService.signalEvent(deployment, signalName, data);
    }

    private void processEvent(ConsumerRecord<String, byte[]> event) {
        this.registration.forEachSignal(event, this::processSignal);
        this.registration.forEachMessage(event, this::processMessage);
    }

    private void processSignal(ConsumerRecord<String, byte[]> event, String deploymentId, SignalDesc signal) {
        this.processEvent(event, deploymentId, (SignalDescBase)signal, this::signalEvent);
    }

    private void processMessage(ConsumerRecord<String, byte[]> event, String deploymentId, MessageDesc message) {
        this.processEvent(event, deploymentId, (SignalDescBase)message, this.messageSignaller);
    }

    private void processEvent(ConsumerRecord<String, byte[]> event, String deploymentId, SignalDescBase signal, Signaller signaller) {
        try {
            String signalName = signal.getName();
            ClassLoader cl = this.classLoaders.get(deploymentId);
            Class valueType = Object.class;
            String className = signal.getStructureRef();
            if (className != null) {
                valueType = cl.loadClass(className.contains(".") ? className : "java.lang." + className);
            }
            Object value = this.factory.getEventReader(event.topic(), cl).readEvent((byte[])event.value(), valueType);
            logger.debug("Sending event with name {} to deployment {} with data {}", new Object[]{signalName, deploymentId, value});
            signaller.signalEvent(deploymentId, signalName, value);
        }
        catch (ClassNotFoundException ex) {
            logger.error("Class not found in deployment id {}", (Object)deploymentId, (Object)ex);
        }
        catch (IOException | RuntimeException ex) {
            logger.error("Exception deserializing event", (Throwable)ex);
        }
    }

    @FunctionalInterface
    static interface Signaller {
        public void signalEvent(String var1, String var2, Object var3);
    }
}

