/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence;

import java.util.Set;
import javax.persistence.EntityManager;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerHelper;
import org.drools.persistence.api.TransactionSynchronization;
import org.drools.persistence.api.Transformable;
import org.kie.api.runtime.Environment;

public class TriggerUpdateTransactionSynchronization
implements TransactionSynchronization {
    private TransactionManager txm;
    private Environment environment;

    public TriggerUpdateTransactionSynchronization(TransactionManager txm, Environment environment) {
        this.txm = txm;
        this.environment = environment;
    }

    public void beforeCompletion() {
        EntityManager cmdScopedEM;
        Set toBeUpdated = TransactionManagerHelper.getUpdateableSet((TransactionManager)this.txm);
        if (!this.isValid() || toBeUpdated == null || toBeUpdated.isEmpty()) {
            return;
        }
        EntityManager appScopedEM = (EntityManager)this.environment.get("org.kie.api.persistence.jpa.AppScopedEntityManager");
        if (appScopedEM == null) {
            appScopedEM = (EntityManager)this.txm.getResource((Object)"org.kie.api.persistence.jpa.AppScopedEntityManager");
        }
        if ((cmdScopedEM = (EntityManager)this.txm.getResource((Object)"org.kie.api.persistence.jpa.CmdScopedEntityManager")) == null) {
            cmdScopedEM = (EntityManager)this.environment.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
        }
        boolean flushApp = false;
        boolean flushCmd = false;
        for (Transformable transformable : toBeUpdated) {
            if (transformable == null) continue;
            transformable.transform();
            if (appScopedEM != null && appScopedEM.contains((Object)transformable)) {
                appScopedEM.merge((Object)transformable);
                TransactionManagerHelper.removeFromUpdatableSet((TransactionManager)this.txm, (Transformable)transformable);
                flushApp = true;
                continue;
            }
            if (cmdScopedEM == null || !cmdScopedEM.contains((Object)transformable)) continue;
            cmdScopedEM.merge((Object)transformable);
            TransactionManagerHelper.removeFromUpdatableSet((TransactionManager)this.txm, (Transformable)transformable);
            flushCmd = true;
        }
        if (flushApp) {
            appScopedEM.flush();
        }
        if (flushCmd) {
            cmdScopedEM.flush();
        }
    }

    public void afterCompletion(int status) {
    }

    private boolean isValid() {
        Object appScopedEM = this.environment.get("org.kie.api.persistence.jpa.AppScopedEntityManager");
        return appScopedEM == null || appScopedEM instanceof EntityManager;
    }
}

