/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import java.util.Map;
import org.dashbuilder.dataset.def.BeanDataSetDef;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshallerExt;
import org.dashbuilder.json.Json;
import org.dashbuilder.json.JsonArray;
import org.dashbuilder.json.JsonException;
import org.dashbuilder.json.JsonObject;
import org.dashbuilder.json.JsonValue;

public class BeanDefJSONMarshaller
implements DataSetDefJSONMarshallerExt<BeanDataSetDef> {
    public static BeanDefJSONMarshaller INSTANCE = new BeanDefJSONMarshaller();
    public static final String GENERATOR_CLASS = "generatorClass";
    public static final String GENERATOR_PARAMS = "generatorParams";
    public static final String PARAM = "param";
    public static final String VALUE = "value";

    @Override
    public void fromJson(BeanDataSetDef def, JsonObject json) {
        String generator = json.getString(GENERATOR_CLASS);
        if (!DataSetDefJSONMarshaller.isBlank(generator)) {
            def.setGeneratorClass(generator);
        }
        if (json.has(GENERATOR_PARAMS)) {
            JsonArray array = json.getArray(GENERATOR_PARAMS);
            for (int i = 0; i < array.length(); ++i) {
                JsonObject param = array.getObject(i);
                String paramId = param.getString(PARAM);
                String value = param.getString(VALUE);
                if (DataSetDefJSONMarshaller.isBlank(paramId)) continue;
                def.getParamaterMap().put(paramId, value);
            }
        }
    }

    @Override
    public void toJson(BeanDataSetDef dataSetDef, JsonObject json) {
        json.put(GENERATOR_CLASS, dataSetDef.getGeneratorClass());
        Map<String, String> parameters = dataSetDef.getParamaterMap();
        if (parameters != null && !parameters.isEmpty()) {
            JsonArray array = Json.createArray();
            int idx = 0;
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                JsonObject paramObject = this.toJsonParameter(param.getKey(), param.getValue());
                array.set(idx++, (JsonValue)paramObject);
            }
            json.put(GENERATOR_PARAMS, (JsonValue)array);
        }
    }

    protected JsonObject toJsonParameter(String key, String value) throws JsonException {
        JsonObject json = Json.createObject();
        json.put(PARAM, key);
        json.put(VALUE, value);
        return json;
    }
}

