/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.kafka;

import java.util.Date;
import java.util.UUID;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.json.JSONMarshaller;
import org.kie.server.services.jbpm.kafka.CloudEvent;
import org.kie.server.services.jbpm.kafka.KafkaEventWriter;

class CloudEventWriter
implements KafkaEventWriter {
    private static final String SOURCE_FORMATTER = "/process/%s/%s";
    private Marshaller marshaller = new JSONMarshaller(true);

    CloudEventWriter() {
    }

    @Override
    public byte[] writeEvent(ProcessInstance processInstance, Object value) {
        CloudEvent<Object> event = new CloudEvent<Object>();
        event.setType(value != null ? value.getClass().getTypeName() : "empty");
        event.setSource(String.format(SOURCE_FORMATTER, processInstance.getProcessId(), processInstance.getId()));
        event.setSpecversion("1.0");
        event.setTime(new Date());
        event.setId(UUID.randomUUID().toString());
        event.setData(value);
        return this.marshaller.marshallAsBytes(event);
    }
}

