/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.kafka;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.server.services.jbpm.kafka.CloudEventReader;
import org.kie.server.services.jbpm.kafka.CloudEventWriter;
import org.kie.server.services.jbpm.kafka.KafkaEventProcessorFactory;
import org.kie.server.services.jbpm.kafka.KafkaEventReader;
import org.kie.server.services.jbpm.kafka.KafkaEventWriter;
import org.kie.server.services.jbpm.kafka.KafkaServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultEventProcessorFactory
implements KafkaEventProcessorFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEventProcessorFactory.class);
    private Map<String, Map<ClassLoader, KafkaEventReader>> topicReaderMap = new ConcurrentHashMap<String, Map<ClassLoader, KafkaEventReader>>();
    private Map<ClassLoader, KafkaEventReader> readerInstanceMap = new ConcurrentHashMap<ClassLoader, KafkaEventReader>();
    private Map<String, KafkaEventWriter> topicWriterMap = new ConcurrentHashMap<String, KafkaEventWriter>();
    private Map<String, KafkaEventWriter> writerInstanceMap = new ConcurrentHashMap<String, KafkaEventWriter>();
    private AtomicBoolean defaultWriterInitialized = new AtomicBoolean(false);
    private KafkaEventWriter defaultWriterInstance;

    DefaultEventProcessorFactory() {
    }

    @Override
    public KafkaEventReader getEventReader(String topic, ClassLoader cl) {
        return this.topicReaderMap.computeIfAbsent(topic, t -> new ConcurrentHashMap()).computeIfAbsent(cl, c -> this.buildReader(topic, cl));
    }

    @Override
    public KafkaEventWriter getEventWriter(String topic) {
        return this.topicWriterMap.computeIfAbsent(topic, this::buildWriter);
    }

    private KafkaEventReader buildReader(String topic, ClassLoader cl) {
        String className = KafkaServerUtils.getTopicProperty(topic, "eventReaderClass");
        KafkaEventReader instance = null;
        if (className != null) {
            instance = this.readerInstanceMap.computeIfAbsent(cl, c -> this.newReaderInstance(className, cl));
        }
        return instance == null ? this.buildDefaultReader(cl) : instance;
    }

    private KafkaEventWriter buildWriter(String topic) {
        String className = KafkaServerUtils.getTopicProperty(topic, "eventWriterClass");
        KafkaEventWriter instance = null;
        if (className != null) {
            instance = this.writerInstanceMap.computeIfAbsent(className, this::newWriterInstance);
        }
        if (this.defaultWriterInitialized.compareAndSet(false, true)) {
            this.defaultWriterInstance = this.buildDefaultWriter();
        }
        return instance == null ? this.defaultWriterInstance : instance;
    }

    private KafkaEventReader newReaderInstance(String className, ClassLoader cl) {
        try {
            return Class.forName(className).asSubclass(KafkaEventReader.class).getConstructor(ClassLoader.class).newInstance(cl);
        }
        catch (ClassCastException | ReflectiveOperationException ex) {
            logger.error("Error instantiating class {}", (Object)className, (Object)ex);
            return null;
        }
    }

    private KafkaEventWriter newWriterInstance(String className) {
        try {
            return Class.forName(className).asSubclass(KafkaEventWriter.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | ReflectiveOperationException ex) {
            logger.error("Error instantiating class {}", (Object)className, (Object)ex);
            return null;
        }
    }

    protected KafkaEventReader buildDefaultReader(ClassLoader cl) {
        return new CloudEventReader(cl);
    }

    protected KafkaEventWriter buildDefaultWriter() {
        return new CloudEventWriter();
    }
}

