/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.kafka;

import org.jbpm.services.api.model.SignalDescBase;
import org.kie.api.event.process.SignalEvent;
import org.kie.server.services.jbpm.kafka.DefaultEventProcessorFactory;
import org.kie.server.services.jbpm.kafka.KafkaEventProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaServerUtils {
    private static final Logger logger = LoggerFactory.getLogger(KafkaServerUtils.class);
    static final String KAFKA_EXTENSION_PREFIX = "org.kie.server.jbpm-kafka.ext.";
    static final String SIGNAL_MAPPING_PROPERTY = "org.kie.server.jbpm-kafka.ext.signals.mapping";
    static final String MESSAGE_MAPPING_PROPERTY = "org.kie.server.jbpm-kafka.ext.message.mapping";
    static final String FACTORY_PROCESSOR_CLASS_NAME = "org.kie.server.jbpm-kafka.ext.eventProcessorFactoryClass";
    static final String TOPIC_PREFIX = "org.kie.server.jbpm-kafka.ext.topics.";
    private static final Mapping SIGNAL_MAPPING_DEFAULT = Mapping.NONE;
    private static final Mapping MESSAGE_MAPPING_DEFAULT = Mapping.AUTO;

    private KafkaServerUtils() {
    }

    static boolean processMessages() {
        return KafkaServerUtils.getMapping(MESSAGE_MAPPING_PROPERTY, MESSAGE_MAPPING_DEFAULT) == Mapping.AUTO;
    }

    static boolean processSignals() {
        return KafkaServerUtils.getMapping(SIGNAL_MAPPING_PROPERTY, SIGNAL_MAPPING_DEFAULT) == Mapping.AUTO;
    }

    static boolean processSignals(SignalEvent event) {
        Mapping mapping = KafkaServerUtils.getMapping(SIGNAL_MAPPING_PROPERTY, SIGNAL_MAPPING_DEFAULT);
        return mapping == Mapping.AUTO || "##kafka".equalsIgnoreCase((String)event.getNodeInstance().getNode().getMetaData().get("implementation"));
    }

    static <T extends SignalDescBase> String topicFromSignal(T signal) {
        return KafkaServerUtils.topicFromSignal(signal.getName());
    }

    static String topicFromSignal(String name) {
        return System.getProperty(TOPIC_PREFIX + name, name);
    }

    static String getTopicProperty(String topic, String name) {
        return System.getProperty(TOPIC_PREFIX + topic + "." + name);
    }

    static KafkaEventProcessorFactory buildEventProcessorFactory() {
        String className = System.getProperty(FACTORY_PROCESSOR_CLASS_NAME);
        KafkaEventProcessorFactory instance = null;
        if (className != null) {
            try {
                instance = Class.forName(className).asSubclass(KafkaEventProcessorFactory.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                logger.warn("Error loading KafkaEventProcessorFactory for class name {}. Check value of property {}", new Object[]{className, FACTORY_PROCESSOR_CLASS_NAME, ex});
            }
        }
        if (instance == null) {
            instance = new DefaultEventProcessorFactory();
        }
        return instance;
    }

    private static Mapping getMapping(String propName, Mapping defaultValue) {
        Mapping result = null;
        String propValue = System.getProperty(propName);
        if (propValue != null) {
            try {
                result = Mapping.valueOf(propValue.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                logger.warn("Wrong value {} for property {}, using default {}", new Object[]{propValue, propName, defaultValue});
            }
        }
        return result == null ? defaultValue : result;
    }

    static enum Mapping {
        AUTO,
        NONE;

    }
}

