/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import org.jbpm.services.task.impl.model.EmailNotificationHeaderImpl;
import org.jbpm.services.task.impl.model.LanguageImpl;
import org.jbpm.services.task.impl.model.NotificationImpl;
import org.kie.internal.task.api.model.EmailNotification;
import org.kie.internal.task.api.model.EmailNotificationHeader;
import org.kie.internal.task.api.model.Language;
import org.kie.internal.task.api.model.NotificationType;

@Entity(name="Notification")
@DiscriminatorValue(value="EmailNotification")
public class EmailNotificationImpl
extends NotificationImpl
implements EmailNotification {
    @OneToMany(cascade={CascadeType.ALL})
    @MapKeyColumn(name="mapkey")
    private Map<LanguageImpl, EmailNotificationHeaderImpl> emailHeaders;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.emailHeaders != null) {
            out.writeInt(this.emailHeaders.size());
            for (EmailNotificationHeader emailNotificationHeader : this.emailHeaders.values()) {
                emailNotificationHeader.writeExternal(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int size = in.readInt();
        if (size > 0) {
            this.emailHeaders = new HashMap<LanguageImpl, EmailNotificationHeaderImpl>(size);
            for (int i = 0; i < size; ++i) {
                EmailNotificationHeaderImpl header = new EmailNotificationHeaderImpl();
                header.readExternal(in);
                this.emailHeaders.put(new LanguageImpl(header.getLanguage()), header);
            }
        }
    }

    @Override
    public NotificationType getNotificationType() {
        return NotificationType.Email;
    }

    public Map<? extends Language, ? extends EmailNotificationHeader> getEmailHeaders() {
        return this.emailHeaders;
    }

    public void setEmailHeaders(Map<? extends Language, ? extends EmailNotificationHeader> emailHeaders) {
        this.emailHeaders = emailHeaders;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.emailHeaders == null ? 0 : this.emailHeaders.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof EmailNotificationImpl)) {
            return false;
        }
        EmailNotificationImpl other = (EmailNotificationImpl)obj;
        return !(this.emailHeaders == null ? other.emailHeaders != null : !this.emailHeaders.equals(other.emailHeaders));
    }
}

