/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.ClassObjectTypeConf;
import org.drools.core.reteoo.FromNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.AsyncSend;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.index.TupleList;

public class AsyncSendNode<T extends AsyncSendMemory>
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory<T> {
    private static final long serialVersionUID = 510L;
    private String messageId;
    private DataProvider dataProvider;
    private AlphaNodeFieldConstraint[] alphaConstraints;
    private BetaConstraints betaConstraints;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private AsyncSend send;
    private boolean tupleMemoryEnabled;
    private transient ObjectTypeConf objectTypeConf;

    public AsyncSendNode() {
    }

    public AsyncSendNode(int id, DataProvider dataProvider, LeftTupleSource tupleSource, AlphaNodeFieldConstraint[] constraints, BetaConstraints binder, boolean tupleMemoryEnabled, BuildContext context, AsyncSend send) {
        super(id, context);
        this.dataProvider = dataProvider;
        this.setLeftTupleSource(tupleSource);
        this.alphaConstraints = constraints;
        this.betaConstraints = binder == null ? EmptyBetaConstraints.getInstance() : binder;
        this.betaConstraints.init(context, this.getType());
        this.tupleMemoryEnabled = tupleMemoryEnabled;
        this.send = send;
        this.messageId = send.getMessageId();
        this.initMasks(context, tupleSource);
        this.hashcode = this.calculateHashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.dataProvider = (DataProvider)in.readObject();
        this.alphaConstraints = (AlphaNodeFieldConstraint[])in.readObject();
        this.betaConstraints = (BetaConstraints)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.send = (AsyncSend)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.dataProvider);
        out.writeObject(this.alphaConstraints);
        out.writeObject(this.betaConstraints);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.send);
    }

    private int calculateHashCode() {
        int hash = 23 * this.leftInput.hashCode() + 29 * this.dataProvider.hashCode();
        if (this.send.getResultPattern() != null) {
            hash += 31 * this.send.getResultPattern().hashCode();
        }
        if (this.alphaConstraints != null) {
            hash += 37 * Arrays.hashCode(this.alphaConstraints);
        }
        if (this.betaConstraints != null) {
            hash += 41 * this.betaConstraints.hashCode();
        }
        return hash;
    }

    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public String toString() {
        return "[AsyncSendNode(" + this.id + "): messageId=" + this.messageId + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsyncSendNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        AsyncSendNode other = (AsyncSendNode)object;
        return this.leftInput.getId() == other.leftInput.getId() && this.dataProvider.equals(other.dataProvider) && ClassUtils.areNullSafeEquals(this.send.getResultPattern(), other.send.getResultPattern()) && Arrays.equals(this.alphaConstraints, other.alphaConstraints) && this.betaConstraints.equals(other.betaConstraints);
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public AlphaNodeFieldConstraint[] getAlphaConstraints() {
        return this.alphaConstraints;
    }

    public BetaConstraints getBetaConstraints() {
        return this.betaConstraints;
    }

    public Class<?> getResultClass() {
        return this.send.getResultClass();
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    public InternalFactHandle createFactHandle(Tuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, Object object) {
        InternalFactHandle handle = null;
        if (context.getReaderContext() != null) {
            handle = context.getReaderContext().createAsyncNodeHandle(leftTuple, workingMemory, object, this.getId(), this.getObjectTypeConf(workingMemory));
        }
        if (handle == null) {
            handle = workingMemory.getFactHandleFactory().newFactHandle(object, this.getObjectTypeConf(workingMemory), workingMemory, null);
        }
        return handle;
    }

    public ObjectTypeConf getObjectTypeConf(InternalWorkingMemory workingMemory) {
        if (this.objectTypeConf == null) {
            this.objectTypeConf = new ClassObjectTypeConf(workingMemory.getEntryPoint(), this.getResultClass(), workingMemory.getKnowledgeBase());
        }
        return this.objectTypeConf;
    }

    @Override
    public T createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        BetaMemory beta = new BetaMemory(new TupleList(), null, this.betaConstraints.createContext(), 151);
        return (T)new AsyncSendMemory(beta, this.dataProvider);
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        FromNodeLeftTuple peer = new FromNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 135;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(factHandle, this, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new FromNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    @Override
    public void attach(BuildContext context) {
        this.leftInput.addTupleSink(this, context);
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            return true;
        }
        return false;
    }

    public static class AsyncSendMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Serializable,
    SegmentNodeMemory {
        private static final long serialVersionUID = 510L;
        private DataProvider dataProvider;
        private final BetaMemory betaMemory;
        public Object providerContext;

        public AsyncSendMemory(BetaMemory betaMemory, DataProvider dataProvider) {
            this.betaMemory = betaMemory;
            this.dataProvider = dataProvider;
            this.providerContext = dataProvider.createContext();
        }

        @Override
        public short getNodeType() {
            return 135;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.betaMemory.getSegmentMemory();
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            this.betaMemory.setSegmentMemory(segmentMemory);
        }

        public BetaMemory getBetaMemory() {
            return this.betaMemory;
        }

        @Override
        public void reset() {
            this.betaMemory.reset();
            this.providerContext = this.dataProvider.createContext();
        }

        @Override
        public long getNodePosMaskBit() {
            return this.betaMemory.getNodePosMaskBit();
        }

        @Override
        public void setNodePosMaskBit(long segmentPos) {
            this.betaMemory.setNodePosMaskBit(segmentPos);
        }

        @Override
        public void setNodeDirtyWithoutNotify() {
            this.betaMemory.setNodeDirtyWithoutNotify();
        }

        @Override
        public void setNodeCleanWithoutNotify() {
            this.betaMemory.setNodeCleanWithoutNotify();
        }
    }
}

