/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.notification;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.websocket.EncodeException;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketNotificationSessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketNotificationSessionManager.class);
    private static final int RETRIES = 20;
    private static final WebSocketNotificationSessionManager INSTANCE = new WebSocketNotificationSessionManager();
    private final ConcurrentMap<Session, ExecutorService> executorsBySession = new ConcurrentHashMap<Session, ExecutorService>();

    public static WebSocketNotificationSessionManager getInstance() {
        return INSTANCE;
    }

    protected Map<Session, ExecutorService> getExecutorsBySession() {
        return this.executorsBySession;
    }

    public void addSession(Session session) {
        this.executorsBySession.put(session, Executors.newSingleThreadExecutor());
        LOGGER.debug("Session '" + session.getId() + "' added to Web Socket Notification manager");
    }

    public void removeSession(Session session) {
        ExecutorService service = (ExecutorService)this.executorsBySession.remove(session);
        service.shutdownNow();
        LOGGER.debug("Session '" + session.getId() + "' removed from Web Socket Notification manager");
    }

    public void broadcastObject(Object object) {
        this.executorsBySession.forEach((session, executor) -> executor.submit(() -> {
            for (int i = 0; i < 20; ++i) {
                LOGGER.debug("Sending notification to session with id: {}, open: {}", (Object)session.getId(), (Object)session.isOpen());
                try {
                    if (session.isOpen()) {
                        session.getBasicRemote().sendObject(object);
                        LOGGER.debug("Notification sent to session with id: {}", (Object)session.getId());
                        break;
                    }
                    LOGGER.debug("Notification not sent, session is closed.");
                    break;
                }
                catch (EncodeException ex) {
                    LOGGER.warn("Failed to send notification, due to encoding error: {}, skipping message", (Object)ex.getMessage(), (Object)ex);
                    break;
                }
                catch (IOException ex) {
                    LOGGER.warn("Failed to send notification, error: {}", (Object)ex.getMessage(), (Object)ex);
                    Thread.sleep(i * 500);
                    continue;
                }
            }
            return null;
        }));
    }
}

