/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.DoubleUnaryOperator;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.models.regression.model.KiePMMLRegressionTable;
import org.kie.pmml.models.regression.model.enums.REGRESSION_NORMALIZATION_METHOD;

public abstract class KiePMMLRegressionClassificationTable
extends KiePMMLRegressionTable {
    protected REGRESSION_NORMALIZATION_METHOD regressionNormalizationMethod;
    protected OP_TYPE opType;
    protected Map<String, KiePMMLRegressionTable> categoryTableMap = new LinkedHashMap<String, KiePMMLRegressionTable>();

    @Override
    public Object evaluateRegression(Map<String, Object> input) {
        LinkedHashMap<String, Double> resultMap = new LinkedHashMap<String, Double>();
        for (Map.Entry<String, KiePMMLRegressionTable> entry : this.categoryTableMap.entrySet()) {
            resultMap.put(entry.getKey(), (Double)entry.getValue().evaluateRegression(input));
        }
        LinkedHashMap<String, Double> probabilityMap = this.getProbabilityMap(resultMap);
        Map.Entry<String, Double> predictedEntry = Collections.max(probabilityMap.entrySet(), Map.Entry.comparingByValue());
        probabilityMap.put(this.targetField, (Double)predictedEntry.getValue());
        this.populateOutputFieldsMapWithResult(predictedEntry.getKey());
        this.populateOutputFieldsMapWithProbability(predictedEntry, probabilityMap);
        return predictedEntry.getKey();
    }

    public abstract boolean isBinary();

    protected abstract LinkedHashMap<String, Double> getProbabilityMap(LinkedHashMap<String, Double> var1);

    protected abstract void populateOutputFieldsMapWithProbability(Map.Entry<String, Double> var1, LinkedHashMap<String, Double> var2);

    @Override
    protected void updateResult(AtomicReference<Double> toUpdate) {
    }

    public REGRESSION_NORMALIZATION_METHOD getRegressionNormalizationMethod() {
        return this.regressionNormalizationMethod;
    }

    public OP_TYPE getOpType() {
        return this.opType;
    }

    public Map<String, KiePMMLRegressionTable> getCategoryTableMap() {
        return this.categoryTableMap;
    }

    protected LinkedHashMap<String, Double> getProbabilityMap(LinkedHashMap<String, Double> resultMap, DoubleUnaryOperator firstItemOperator, DoubleUnaryOperator secondItemOperator) {
        if (resultMap.size() != 2) {
            throw new KiePMMLException(String.format("Expected two entries, retrieved %d", resultMap.size()));
        }
        LinkedHashMap<String, Double> toReturn = new LinkedHashMap<String, Double>();
        String[] resultMapKeys = resultMap.keySet().toArray(new String[0]);
        double firstItem = firstItemOperator.applyAsDouble(resultMap.get(resultMapKeys[0]));
        double secondItem = secondItemOperator.applyAsDouble(firstItem);
        toReturn.put(resultMapKeys[0], firstItem);
        toReturn.put(resultMapKeys[1], secondItem);
        return toReturn;
    }
}

