/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.evaluator.api.container.PMMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeBaseUtils {
    private static final Logger logger = LoggerFactory.getLogger(KnowledgeBaseUtils.class);

    private KnowledgeBaseUtils() {
    }

    public static List<KiePMMLModel> getModels(KieBase knowledgeBase) {
        ArrayList<KiePMMLModel> models = new ArrayList<KiePMMLModel>();
        knowledgeBase.getKiePackages().forEach(kpkg -> {
            PMMLPackage pmmlPackage = (PMMLPackage)((InternalKnowledgePackage)kpkg).getResourceTypePackages().get(ResourceType.PMML);
            if (pmmlPackage != null) {
                models.addAll(pmmlPackage.getAllModels().values());
            }
        });
        return models;
    }

    public static Optional<KiePMMLModel> getModel(KieBase knowledgeBase, String modelName) {
        logger.trace("getModels {} {}", (Object)knowledgeBase, (Object)modelName);
        return KnowledgeBaseUtils.getModels(knowledgeBase).stream().filter(model -> Objects.equals(modelName, model.getName())).findFirst();
    }
}

