/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore;

import com.arjuna.ats.arjuna.AtomicAction;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public class BaseTransaction {
    private static final boolean _supportSubtransactions = jtaPropertyManager.getJTAEnvironmentBean().isSupportSubtransactions();
    private static final ThreadLocal<Integer> _timeouts = new ThreadLocal();
    private static final int _asyncCommitPoolSize = jtaPropertyManager.getJTAEnvironmentBean().getAsyncCommitPoolSize();
    private static final ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, _asyncCommitPoolSize, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(3));

    public void begin() throws NotSupportedException, SystemException {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"BaseTransaction.begin");
        }
        if (!_supportSubtransactions) {
            try {
                this.checkTransactionState();
            }
            catch (IllegalStateException e1) {
                NotSupportedException notSupportedException = new NotSupportedException(e1.getMessage());
                notSupportedException.initCause((Throwable)e1);
                throw notSupportedException;
            }
            catch (Exception e2) {
                SystemException systemException = new SystemException(e2.toString());
                systemException.initCause((Throwable)e2);
                throw systemException;
            }
        }
        Integer value = _timeouts.get();
        int v = 0;
        v = value != null ? value : TxControl.getDefaultTimeout();
        TransactionImple.putTransaction(new TransactionImple(v));
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImple theTransaction;
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"BaseTransaction.commit");
        }
        if ((theTransaction = TransactionImple.getTransaction()) == null) {
            throw new IllegalStateException("BaseTransaction.commit - " + jtaLogger.i18NLogger.get_transaction_arjunacore_notx());
        }
        theTransaction.commitAndDisassociate();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImple theTransaction;
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"BaseTransaction.rollback");
        }
        if ((theTransaction = TransactionImple.getTransaction()) == null) {
            throw new IllegalStateException("BaseTransaction.rollback - " + jtaLogger.i18NLogger.get_transaction_arjunacore_notx());
        }
        theTransaction.rollbackAndDisassociate();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionImple theTransaction;
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"BaseTransaction.setRollbackOnly");
        }
        if ((theTransaction = TransactionImple.getTransaction()) == null) {
            throw new IllegalStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_nosuchtx());
        }
        theTransaction.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        TransactionImple theTransaction = TransactionImple.getTransaction();
        if (theTransaction == null) {
            return 6;
        }
        return theTransaction.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds >= 0) {
            _timeouts.set(new Integer(seconds));
        }
    }

    public int getTimeout() throws SystemException {
        Integer value = _timeouts.get();
        if (value != null) {
            return value;
        }
        return 0;
    }

    public String toString() {
        TransactionImple theTransaction = TransactionImple.getTransaction();
        if (theTransaction == null) {
            return "Transaction: unknown";
        }
        return "Transaction: " + theTransaction;
    }

    public TransactionImple createSubordinate() throws NotSupportedException, SystemException {
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)"BaseTransaction.createSubordinate");
        }
        try {
            this.checkTransactionState();
        }
        catch (IllegalStateException e1) {
            NotSupportedException notSupportedException = new NotSupportedException();
            notSupportedException.initCause((Throwable)e1);
            throw notSupportedException;
        }
        catch (Exception e2) {
            SystemException systemException = new SystemException(e2.toString());
            systemException.initCause((Throwable)e2);
            throw systemException;
        }
        Integer value = _timeouts.get();
        int v = 0;
        if (value != null) {
            v = value;
        }
        return new com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.TransactionImple(v);
    }

    protected BaseTransaction() {
    }

    final void checkTransactionState() throws IllegalStateException, SystemException {
        TransactionImple theTransaction = TransactionImple.getTransaction();
        if (theTransaction == null) {
            return;
        }
        if (theTransaction.getStatus() != 6 && !_supportSubtransactions) {
            throw new IllegalStateException("BaseTransaction.checkTransactionState - " + jtaLogger.i18NLogger.get_transaction_arjunacore_alreadyassociated());
        }
    }

    public Future<Void> commitAsync() {
        final TransactionImple theTransaction = TransactionImple.getTransaction();
        if (theTransaction == null) {
            throw new IllegalStateException("BaseTransaction.commit - " + jtaLogger.i18NLogger.get_transaction_arjunacore_notx());
        }
        AtomicAction.suspend();
        return BaseTransaction.wrap(new Callable<Void>(){

            @Override
            public Void call() throws InvalidTransactionException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException {
                if (AtomicAction.suspend() != null) {
                    System.err.println("WARNING - A PREVIOUS TRANSACTION WAS ON THE THREAD UNSUSPENDED");
                }
                if (!AtomicAction.resume(theTransaction.getAtomicAction())) {
                    throw new InvalidTransactionException();
                }
                theTransaction.commitAndDisassociate();
                return null;
            }
        });
    }

    public static <T> Future<T> wrap(Callable<T> callable) {
        FutureTask<T> task = new FutureTask<T>(callable);
        tpe.execute(task);
        return task;
    }
}

