/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.DeploymentNotActiveException;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessDefinitionNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.WorkItemNotFoundException;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.VariableInstanceList;
import org.kie.server.api.model.instance.WorkItemInstance;
import org.kie.server.api.model.instance.WorkItemInstanceList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.ProcessServiceBase;
import org.kie.server.services.jbpm.RuntimeDataServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Process instances")
@Path(value="server/containers/{containerId}/processes")
public class ProcessResource {
    public static final Logger logger = LoggerFactory.getLogger(ProcessResource.class);
    private ProcessServiceBase processServiceBase;
    private RuntimeDataServiceBase runtimeDataServiceBase;
    private KieServerRegistry context;

    public ProcessResource() {
    }

    public ProcessResource(ProcessServiceBase processServiceBase, RuntimeDataServiceBase runtimeDataServiceBase, KieServerRegistry context) {
        this.processServiceBase = processServiceBase;
        this.runtimeDataServiceBase = runtimeDataServiceBase;
        this.context = context;
    }

    protected static String getRelativePath(HttpServletRequest httpRequest) {
        String url = httpRequest.getRequestURI();
        url = url.replaceAll(".*/rest", "");
        return url;
    }

    @ApiOperation(value="Starts a new process instance of a specified process.")
    @ApiResponses(value={@ApiResponse(code=201, response=Long.class, message="Process instance started", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="10"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<long-type>\n    <value>10</value>\n</long-type>")})), @ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process ID or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset")})
    @POST
    @Path(value="{processId}/instances")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response startProcess(@Context HttpHeaders headers, @ApiParam(value="container id where the process definition resides", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="process id that new instance should be created from", required=true, example="evaluation") @PathParam(value="processId") String processId, @ApiParam(value="optional map of process variables", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) @DefaultValue(value="") String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.processServiceBase.startProcess(containerId, processId, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotActiveException e) {
            return RestUtils.badRequest((String)e.getMessage(), (Variant)v, (Header[])new Header[0]);
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[0]);
        }
        catch (ProcessDefinitionNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[0]);
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unable to create response: {0}", e.getMessage()), (Variant)v, (Header[])new Header[0]);
        }
    }

    @ApiOperation(value="Starts a new process instance from the specific nodes")
    @ApiResponses(value={@ApiResponse(code=201, response=Long.class, message="Process instance created", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="10"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<long-type>\n    <value>10</value>\n</long-type>")})), @ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process ID or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset")})
    @POST
    @Path(value="{processId}/instances/fromNodes")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response startProcessFromNodeIds(@Context HttpHeaders headers, @ApiParam(value="container id where the process definition resides", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="process instance id that new instance should be created from", required=true, example="evaluation") @PathParam(value="processId") String processId, @ApiParam(value="optional map of process variables", required=false) @DefaultValue(value="") String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.processServiceBase.startProcessFromNodeIds(containerId, processId, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotActiveException e) {
            return RestUtils.badRequest((String)e.getMessage(), (Variant)v, (Header[])new Header[0]);
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[0]);
        }
        catch (ProcessDefinitionNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[0]);
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unable to create response: {0}", e.getMessage()), (Variant)v, (Header[])new Header[0]);
        }
    }

    @ApiOperation(value="Starts a new process instance from the specific nodes")
    @ApiResponses(value={@ApiResponse(code=201, response=Long.class, message="Process instance created", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="10"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<long-type>\n    <value>10</value>\n</long-type>")})), @ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process ID or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset")})
    @POST
    @Path(value="{processId}/instances/correlation/{correlationKey}/fromNodes")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response startProcessWithCorrelationKeyFromNodeIds(@Context HttpHeaders headers, @ApiParam(value="container id where the process definition resides", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="process instance id that new instance should be created from", required=true, example="evaluation") @PathParam(value="processId") String processId, @ApiParam(value="correlation key that should be used for creating the process", required=true, example="evaluation") @PathParam(value="correlationKey") String correlationKey, @ApiParam(value="start process specifications", required=false) @DefaultValue(value="") String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.processServiceBase.startProcessWithCorrelationKeyFromNodeIds(containerId, processId, correlationKey, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotActiveException e) {
            return RestUtils.badRequest((String)e.getMessage(), (Variant)v, (Header[])new Header[0]);
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[0]);
        }
        catch (ProcessDefinitionNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[0]);
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unable to create response: {0}", e.getMessage()), (Variant)v, (Header[])new Header[0]);
        }
    }

    @ApiOperation(value="Starts a new process instance of a specified process and assigns a new correlation key to the process instance.")
    @ApiResponses(value={@ApiResponse(code=201, response=Long.class, message="Process instance started", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="10"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<long-type>\n    <value>10</value>\n</long-type>")})), @ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process ID or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset")})
    @POST
    @Path(value="{processId}/instances/correlation/{correlationKey}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response startProcessWithCorrelation(@Context HttpHeaders headers, @ApiParam(value="container id where the process definition resides", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="process id that new instance should be created from", required=true, example="evaluation") @PathParam(value="processId") String processId, @ApiParam(value="correlation key to be assigned to process instance", required=true, example="john-evaluation-2019") @PathParam(value="correlationKey") String correlationKey, @ApiParam(value="optional map of process variables", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) @DefaultValue(value="") String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.processServiceBase.startProcessWithCorrelation(containerId, processId, correlationKey, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotActiveException e) {
            return RestUtils.badRequest((String)e.getMessage(), (Variant)v, (Header[])new Header[0]);
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[0]);
        }
        catch (ProcessDefinitionNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[0]);
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unable to create response: {0}", e.getMessage()), (Variant)v, (Header[])new Header[0]);
        }
    }

    @ApiOperation(value="Aborts a specified process instance in a specified KIE container.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset")})
    @DELETE
    @Path(value="instances/{processInstanceId}")
    @Produces(value={"application/json", "application/xml"})
    public Response abortProcessInstance(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance to be aborted", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processServiceBase.abortProcessInstance(containerId, (Number)processInstanceId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Aborts multiple specified process instances in a specified KIE container.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset")})
    @DELETE
    @Path(value="instances")
    @Produces(value={"application/json", "application/xml"})
    public Response abortProcessInstances(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="list of identifiers of the process instances to be aborted", required=true) @QueryParam(value="instanceId") List<Long> processInstanceIds) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processServiceBase.abortProcessInstances(containerId, processInstanceIds);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceIds), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Signals a specified process instance with a specified signal name and optional signal data.", response=Void.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset")})
    @POST
    @Path(value="instances/{processInstanceId}/signal/{signalName}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response signalProcessInstance(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance to be signaled", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="signal name to be send to process instance", required=true, example="EventReceived") @PathParam(value="signalName") String signalName, @ApiParam(value="optional event data - any type can be provided", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"Person\": {\n        \"name\": \"john\"\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<person>\n    <name>john</name>\n</person>")})) String eventPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processServiceBase.signalProcessInstance(containerId, (Number)processInstanceId, signalName, eventPayload, type);
            return RestUtils.createResponse(null, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Signals a specified process instance by correlation key with a specified signal name and optional signal data.", response=Void.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset")})
    @POST
    @Path(value="instances/correlation/{correlationKey}/signal/{signalName}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response signalProcessInstanceByCorrelationKey(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="correlation key of the process instance to be signaled", required=true, example="123") @PathParam(value="correlationKey") String correlationKey, @ApiParam(value="signal name to be sent to process instance", required=true, example="EventReceived") @PathParam(value="signalName") String signalName, @ApiParam(value="optional event data - any type can be provided", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"Person\": {\n        \"name\": \"john\"\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<person>\n    <name>john</name>\n</person>")})) String eventPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processServiceBase.signalProcessInstanceByCorrelationKey(containerId, correlationKey, signalName, eventPayload, type);
            return RestUtils.createResponse(null, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", correlationKey), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Signals multiple process instances with a specified signal name.", response=Void.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset")})
    @POST
    @Path(value="instances/signal/{signalName}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response signalProcessInstances(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="list of identifiers of the process instances to be signaled", required=false) @QueryParam(value="instanceId") List<Long> processInstanceIds, @ApiParam(value="list of correlationKeys of the process instances to be signaled", required=false) @QueryParam(value="correlationKey") List<String> correlationKeys, @ApiParam(value="signal name to be send to process instance", required=true, example="EventReceived") @PathParam(value="signalName") String signalName, @ApiParam(value="optional event data - any type can be provided", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"Person\": {\n        \"name\": \"john\"\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<person>\n    <name>john</name>\n</person>")})) String eventPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            if (processInstanceIds != null && !processInstanceIds.isEmpty()) {
                logger.debug("Signaling given process instances - {}", processInstanceIds);
                this.processServiceBase.signalProcessInstances(containerId, processInstanceIds, signalName, eventPayload, type);
            } else if (correlationKeys != null && !correlationKeys.isEmpty()) {
                logger.debug("Signaling given process instances by correlation key - {}", correlationKeys);
                this.processServiceBase.signalProcessInstancesByCorrelationKey(containerId, correlationKeys, signalName, eventPayload, type);
            } else {
                logger.debug("No process instances given, signal container..");
                this.processServiceBase.signal(containerId, signalName, eventPayload, type);
            }
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceIds), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns information about a specified process instance in a specified KIE container.", response=ProcessInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=200, response=ProcessInstance.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance-id\": 1,\n  \"process-id\": \"Employee_Rostering.Process1\",\n  \"process-name\": \"Process1\",\n  \"process-version\": \"1.0\",\n  \"process-instance-state\": 1,\n  \"container-id\": \"employee-rostering\",\n  \"initiator\": \"baAdmin\",\n  \"start-date\": {\n    \"java.util.Date\": 1539184095041\n  },\n  \"process-instance-desc\": \"Process1\",\n  \"correlation-key\": \"1\",\n  \"parent-instance-id\": -1,\n  \"sla-compliance\": 0,\n  \"sla-due-date\": null,\n  \"active-user-tasks\": null,\n  \"process-instance-variables\": {\n    \"initiator\": \"baAdmin\"\n  }\n}")}))})
    @GET
    @Path(value="instances/{processInstanceId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessInstance(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance to be fetched", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="indicates if process instance variables should be loaded or not", required=false) @QueryParam(value="withVars") boolean withVars) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.processServiceBase.getProcessInstance(containerId, (Number)processInstanceId, withVars, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[0]);
        }
    }

    @ApiOperation(value="Creates or updates a variable for a specified process instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset")})
    @PUT
    @Path(value="instances/{processInstanceId}/variable/{varName}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response setProcessVariable(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance to be updated", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="name of the variable to be set/updated", required=true, example="name") @PathParam(value="varName") String varName, @ApiParam(value="variable data - any type can be provided", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"Person\": {\n        \"name\": \"john\"\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<person>\n    <name>john</name>\n</person>")})) String variablePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processServiceBase.setProcessVariable(containerId, (Number)processInstanceId, varName, variablePayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Updates the values of one or more variable for a specified process instance. The request is a map in which the key is the variable name and the value is the new variable value.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset")})
    @POST
    @Path(value="instances/{processInstanceId}/variables")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response setProcessVariables(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance to be updated", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="variable data give as map", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String variablePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processServiceBase.setProcessVariables(containerId, (Number)processInstanceId, variablePayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns the value of a specified variable in a specified process instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset"), @ApiResponse(code=200, response=Object.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"com.myspace.mortgage_app.Application\": {\n    \"applicant\": {\n      \"com.myspace.mortgage_app.Applicant\": {\n        \"name\": \"\",\n        \"annualincome\": 0,\n        \"address\": null,\n        \"ssn\": 0,\n        \"creditrating\": null\n      }\n    },\n    \"property\": {\n      \"com.myspace.mortgage_app.Property\": {\n        \"age\": 0,\n        \"address\": \"\",\n        \"locale\": \"\",\n        \"saleprice\": 0\n      }\n    },\n    \"downpayment\": 0,\n    \"amortization\": 0,\n    \"mortgageamount\": null\n  }\n}")}))})
    @GET
    @Path(value="instances/{processInstanceId}/variable/{varName}")
    @Produces(value={"application/json", "application/xml"})
    public Object getProcessInstanceVariable(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance that variable should be retrieved from", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="variable name to be retrieved", required=true, example="person") @PathParam(value="varName") String varName) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.processServiceBase.getProcessInstanceVariable(containerId, (Number)processInstanceId, varName, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves all variables for a specified process instance as a map in which the key is the variable name and the value is the variable value.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset"), @ApiResponse(code=200, response=Map.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"application\": {\n    \"com.myspace.mortgage_app.Application\": {\n      \"applicant\": {\n        \"com.myspace.mortgage_app.Applicant\": {\n          \"name\": \"\",\n          \"annualincome\": 0,\n          \"address\": null,\n          \"ssn\": 0,\n          \"creditrating\": null\n        }\n      },\n      \"property\": {\n        \"com.myspace.mortgage_app.Property\": {\n          \"age\": 0,\n          \"address\": \"\",\n          \"locale\": \"\",\n          \"saleprice\": 0\n        }\n      },\n      \"downpayment\": 0,\n      \"amortization\": 0,\n      \"mortgageamount\": null\n    }\n  },\n  \"initiator\": \"baAdmin\"\n}")}))})
    @GET
    @Path(value="instances/{processInstanceId}/variables")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessInstanceVariables(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance that variables should be retrieved from", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.processServiceBase.getProcessInstanceVariables(containerId, (Number)processInstanceId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns all available signal names for a specified process instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset"), @ApiResponse(code=200, response=String.class, responseContainer="List", message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="[ \"wait\", \"another\"]")}))})
    @GET
    @Path(value="instances/{processInstanceId}/signals")
    @Produces(value={"application/json", "application/xml"})
    public Response getAvailableSignals(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance that signals should be collected for", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.processServiceBase.getAvailableSignals(containerId, (Number)processInstanceId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Completes a specified work item for a specified process instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance, Work Item or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset")})
    @PUT
    @Path(value="instances/{processInstanceId}/workitems/{workItemId}/completed")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response completeWorkItem(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance that work item belongs to", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="identifier of the work item to complete", required=true, example="567") @PathParam(value="workItemId") Long workItemId, @ApiParam(value="optional outcome data give as map", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String resultPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processServiceBase.completeWorkItem(containerId, (Number)processInstanceId, (Number)workItemId, resultPayload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Aborts a specified work item for a specified process instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance, Work Item or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset")})
    @PUT
    @Path(value="instances/{processInstanceId}/workitems/{workItemId}/aborted")
    @Produces(value={"application/json", "application/xml"})
    public Response abortWorkItem(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance that work item belongs to", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="identifier of the work item to abort", required=true, example="567") @PathParam(value="workItemId") Long workItemId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processServiceBase.abortWorkItem(containerId, (Number)processInstanceId, (Number)workItemId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (WorkItemNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find work item instance with id \"{0}\"", workItemId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns information about a specified work item for a specified process instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance, Work Item or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset"), @ApiResponse(code=200, response=WorkItemInstance.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"work-item-instance\": [\n    {\n      \"work-item-id\": 4,\n      \"work-item-name\": \"Human Task\",\n      \"work-item-state\": 0,\n      \"work-item-params\": {\n        \"application\": {\n          \"com.myspace.mortgage_app.Application\": {\n            \"applicant\": {\n              \"com.myspace.mortgage_app.Applicant\": {\n                \"name\": \"NewName\",\n                \"annualincome\": 0,\n                \"address\": null,\n                \"ssn\": 0,\n                \"creditrating\": null\n              }\n            },\n            \"property\": {\n              \"com.myspace.mortgage_app.Property\": {\n                \"age\": 0,\n                \"address\": \"NewAddress\",\n                \"locale\": \"\",\n                \"saleprice\": 0\n              }\n            },\n            \"downpayment\": 0,\n            \"amortization\": 0,\n            \"mortgageamount\": null\n          }\n        },\n        \"TaskName\": \"CorrectData\",\n        \"NodeName\": \"Correct Data\",\n        \"Skippable\": \"false\",\n        \"GroupId\": \"broker\"\n      },\n      \"process-instance-id\": 4,\n      \"container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n      \"node-instance-id\": 5,\n      \"node-id\": 6\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{processInstanceId}/workitems/{workItemId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getWorkItem(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance that work item belongs to", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="identifier of the work item to retrieve", required=true, example="567") @PathParam(value="workItemId") Long workItemId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.processServiceBase.getWorkItem(containerId, (Number)processInstanceId, (Number)workItemId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (WorkItemNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find work item instance with id \"{0}\"", workItemId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns all work items for a specified process instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance, Work Item or Container Id not found"), @ApiResponse(code=403, message="User does not have permission to access this asset"), @ApiResponse(code=200, response=WorkItemInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"work-item-instance\": [\n    {\n      \"work-item-id\": 4,\n      \"work-item-name\": \"Human Task\",\n      \"work-item-state\": 0,\n      \"work-item-params\": {\n        \"application\": {\n          \"com.myspace.mortgage_app.Application\": {\n            \"applicant\": {\n              \"com.myspace.mortgage_app.Applicant\": {\n                \"name\": \"NewName\",\n                \"annualincome\": 0,\n                \"address\": null,\n                \"ssn\": 0,\n                \"creditrating\": null\n              }\n            },\n            \"property\": {\n              \"com.myspace.mortgage_app.Property\": {\n                \"age\": 0,\n                \"address\": \"NewAddress\",\n                \"locale\": \"\",\n                \"saleprice\": 0\n              }\n            },\n            \"downpayment\": 0,\n            \"amortization\": 0,\n            \"mortgageamount\": null\n          }\n        },\n        \"TaskName\": \"CorrectData\",\n        \"NodeName\": \"Correct Data\",\n        \"Skippable\": \"false\",\n        \"GroupId\": \"broker\"\n      },\n      \"process-instance-id\": 4,\n      \"container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n      \"node-instance-id\": 5,\n      \"node-id\": 6\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{processInstanceId}/workitems")
    @Produces(value={"application/json", "application/xml"})
    public Response getWorkItemByProcessInstance(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance that work items belong to", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.processServiceBase.getWorkItemByProcessInstance(containerId, (Number)processInstanceId, type);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (SecurityException e) {
            return RestUtils.forbidden((String)RestUtils.errorMessage((Throwable)e, (String)e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns a list of process instances in a specified KIE container.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container Id not found"), @ApiResponse(code=200, response=ProcessInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance\": [\n    {\n      \"process-instance-id\": 1,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184095041\n      },\n      \"process-instance-desc\": \"Process1\",\n      \"correlation-key\": \"1\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    },\n    {\n      \"process-instance-id\": 2,\n      \"process-id\": \"Employee_Rostering.Process2\",\n      \"process-name\": \"Process2\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184303976\n      },\n      \"process-instance-desc\": \"Process2\",\n      \"correlation-key\": \"2\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessInstancesByDeploymentId(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="optional process instance status (active, completed, aborted) - defaults ot active (1) only", required=false, allowableValues="1,2,3") @QueryParam(value="status") List<Integer> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstancesByDeploymentId(containerId, status, page, pageSize, sort, sortOrder);
            logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
            return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns a list of process definitions in a specified KIE container.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container Id not found"), @ApiResponse(code=200, response=ProcessDefinitionList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"processes\": [\n    {\n      \"associatedEntities\": null,\n      \"serviceTasks\": null,\n      \"processVariables\": null,\n      \"reusableSubProcesses\": null,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"package\": \"employeerostering.employeerostering\",\n      \"container-id\": \"employee-rostering\",\n      \"dynamic\": false\n    }\n  ]\n}")}))})
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessesByDeploymentId(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ProcessDefinitionList processDefinitionList = this.runtimeDataServiceBase.getProcessesByDeploymentIdCheckContainer(containerId, page, pageSize, sort, sortOrder);
            logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
            return RestUtils.createCorrectVariant((Object)processDefinitionList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns node instances for the specified process instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process Instance or Container Id not found"), @ApiResponse(code=200, response=NodeInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"node-instance\": [\n    {\n      \"node-instance-id\": 1,\n      \"node-name\": \"Task\",\n      \"process-instance-id\": 2,\n      \"work-item-id\": 2,\n      \"container-id\": \"employee-rostering\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184095048\n      },\n      \"node-id\": \"_5F8EED98-433C-4E7B-97BC-0E70615F13CB\",\n      \"node-type\": \"HumanTaskNode\",\n      \"node-connection\": \"_E89FEB0F-B8E1-4138-9DF0-397C9F9A6512\",\n      \"node-completed\": false,\n      \"reference-id\": null,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{processInstanceId}/nodes/instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessInstanceHistory(@Context HttpHeaders headers, @PathParam(value="containerId") @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") String containerId, @ApiParam(value="identifier of the process instance that history should be collected for", required=true, example="123") @PathParam(value="processInstanceId") long processInstanceId, @ApiParam(value="instructs if active nodes only should be collected, defaults to false", required=false) @QueryParam(value="activeOnly") Boolean active, @ApiParam(value="instructs if completed nodes only should be collected, defaults to false", required=false) @QueryParam(value="completedOnly") Boolean completed, @ApiParam(value="entry type from the history", required=false, example="123") @QueryParam(value="processInstanceHistoryType") String processInstHistoryType, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            NodeInstanceList nodeInstanceList = null;
            nodeInstanceList = processInstHistoryType == null ? this.runtimeDataServiceBase.getProcessInstanceHistory(processInstanceId, active, completed, page, pageSize) : this.runtimeDataServiceBase.getProcessInstanceFullHistoryByType(processInstanceId, processInstHistoryType, page, pageSize);
            logger.debug("Returning result of node instances search: {}", (Object)nodeInstanceList);
            return RestUtils.createCorrectVariant((Object)nodeInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns the current variable values of a specified process instance in a specified KIE container.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process Instance or Container Id not found"), @ApiResponse(code=200, response=VariableInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"variable-instance\": [\n    {\n      \"name\": \"initiator\",\n      \"old-value\": \"\",\n      \"value\": \"baAdmin\",\n      \"process-instance-id\": 2,\n      \"modification-date\": {\n        \"java.util.Date\": 1539610491992\n      }\n    },\n    {\n      \"name\": \"application\",\n      \"old-value\": \"com.myspace.mortgage_app.Application@bd449b3\",\n      \"value\": \"com.myspace.mortgage_app.Application@bd449b3\",\n      \"process-instance-id\": 2,\n      \"modification-date\": {\n        \"java.util.Date\": 1539610492006\n      }\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{processInstanceId}/variables/instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getVariablesCurrentState(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance that variables state should be collected for", required=true, example="123") @PathParam(value="processInstanceId") long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            VariableInstanceList variableInstanceList = this.runtimeDataServiceBase.getVariablesCurrentState(processInstanceId);
            logger.debug("Returning result of variables search: {}", (Object)variableInstanceList);
            return RestUtils.createCorrectVariant((Object)variableInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns the history of a specified variable in a specified process instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process Instance or Container Id not found"), @ApiResponse(code=200, response=VariableInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"variable-instance\": [\n    {\n      \"name\": \"initiator\",\n      \"old-value\": \"\",\n      \"value\": \"baAdmin\",\n      \"process-instance-id\": 2,\n      \"modification-date\": {\n        \"java.util.Date\": 1539610491992\n      }\n    },\n    {\n      \"name\": \"application\",\n      \"old-value\": \"com.myspace.mortgage_app.Application@bd449b3\",\n      \"value\": \"com.myspace.mortgage_app.Application@bd449b3\",\n      \"process-instance-id\": 2,\n      \"modification-date\": {\n        \"java.util.Date\": 1539610492006\n      }\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{processInstanceId}/variables/instances/{varName}")
    @Produces(value={"application/json", "application/xml"})
    public Response getVariableHistory(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the process instance that variable history should be collected for", required=true, example="123") @PathParam(value="processInstanceId") long processInstanceId, @ApiParam(value="name of the variables that history should be collected for", required=true, example="person") @PathParam(value="varName") String variableName, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            VariableInstanceList variableInstanceList = this.runtimeDataServiceBase.getVariableHistory(processInstanceId, variableName, page, pageSize);
            logger.debug("Returning result of variable '{}; history search: {}", (Object)variableName, (Object)variableInstanceList);
            return RestUtils.createCorrectVariant((Object)variableInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns a list of process instances for which a specified process instance is a parent process instance")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=ProcessInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance\": [\n    {\n      \"process-instance-id\": 1,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184095041\n      },\n      \"process-instance-desc\": \"Process1\",\n      \"correlation-key\": \"1\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    },\n    {\n      \"process-instance-id\": 2,\n      \"process-id\": \"Employee_Rostering.Process2\",\n      \"process-name\": \"Process2\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184303976\n      },\n      \"process-instance-desc\": \"Process2\",\n      \"correlation-key\": \"2\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{processInstanceId}/processes")
    @Produces(value={"application/json", "application/xml"})
    public Response getProcessInstances(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the parent process instance that process instances should be collected for", required=true, example="123") @PathParam(value="processInstanceId") long parentProcessInstanceId, @ApiParam(value="optional process instance status (active, completed, aborted) - defaults ot active (1) only", required=false, allowableValues="1,2,3") @QueryParam(value="status") List<Integer> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.processServiceBase.getProcessInstancesByParent(parentProcessInstanceId, status, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }
}

