/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.jbpm.process.audit.strategy.PersistenceStrategy;
import org.jbpm.process.audit.strategy.PersistenceStrategyType;
import org.jbpm.process.audit.strategy.StandaloneJtaStrategy;
import org.jbpm.process.audit.strategy.StandaloneLocalStrategy;
import org.kie.api.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAService {
    private static final Logger logger = LoggerFactory.getLogger(JPAService.class);
    protected PersistenceStrategy persistenceStrategy;
    protected String persistenceUnitName;

    public JPAService(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
        EntityManagerFactory emf = null;
        try {
            emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
        }
        catch (Exception e) {
            logger.info("The '" + persistenceUnitName + "' peristence unit is not available, no persistence strategy set for " + this.getClass().getSimpleName());
        }
        if (emf != null) {
            this.persistenceStrategy = new StandaloneJtaStrategy(emf);
        }
    }

    public JPAService(Environment env, PersistenceStrategyType type) {
        this.persistenceStrategy = PersistenceStrategyType.getPersistenceStrategy(type, env);
    }

    public JPAService(Environment env, String persistenceUnitName) {
        EntityManagerFactory emf = (EntityManagerFactory)env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        String localTransactions = (String)env.get("org.kie.transaction.local");
        if (emf != null) {
            if (localTransactions != null) {
                if (localTransactions.equals("true")) {
                    this.persistenceStrategy = new StandaloneLocalStrategy(emf);
                }
            } else {
                this.persistenceStrategy = new StandaloneJtaStrategy(emf);
            }
        } else if (localTransactions != null) {
            if (localTransactions.equals("true")) {
                this.persistenceStrategy = new StandaloneLocalStrategy(Persistence.createEntityManagerFactory((String)persistenceUnitName));
            }
        } else {
            this.persistenceStrategy = new StandaloneJtaStrategy(Persistence.createEntityManagerFactory((String)persistenceUnitName));
        }
    }

    public JPAService(EntityManagerFactory emf) {
        this.persistenceStrategy = new StandaloneJtaStrategy(emf);
    }

    public JPAService(EntityManagerFactory emf, PersistenceStrategyType type) {
        this.persistenceStrategy = PersistenceStrategyType.getPersistenceStrategy(type, emf);
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceStrategy = new StandaloneJtaStrategy(Persistence.createEntityManagerFactory((String)persistenceUnitName));
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void dispose() {
        this.persistenceStrategy.dispose();
    }

    protected EntityManager getEntityManager() {
        return this.persistenceStrategy.getEntityManager();
    }

    protected Object joinTransaction(EntityManager em) {
        return this.persistenceStrategy.joinTransaction(em);
    }

    protected void closeEntityManager(EntityManager em, Object transaction) {
        this.persistenceStrategy.leaveTransaction(em, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> executeQuery(Query query, EntityManager em, Class<T> type) {
        List result;
        Object newTx = this.joinTransaction(em);
        try {
            result = query.getResultList();
        }
        finally {
            this.closeEntityManager(em, newTx);
        }
        return result;
    }
}

