/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.impl;

import java.net.URI;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.openapi.NamingPolicy;

public class DefaultNamingPolicy
implements NamingPolicy {
    private final String refPrefix;

    public DefaultNamingPolicy(String refPrefix) {
        this.refPrefix = refPrefix;
    }

    @Override
    public String getName(DMNType type) {
        String name = type.getName();
        DMNType belongingType = ((BaseDMNTypeImpl)type).getBelongingType();
        while (belongingType != null) {
            name = belongingType.getName() + "_" + name;
            belongingType = ((BaseDMNTypeImpl)belongingType).getBelongingType();
        }
        return name;
    }

    @Override
    public String getRef(DMNType type) {
        String namePart;
        try {
            URI uri = new URI(null, null, this.getName(type), null);
            namePart = uri.toString();
        }
        catch (Exception e) {
            namePart = type.getName();
        }
        return this.refPrefix + namePart;
    }
}

