/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SubChainChangeMove<Solution_>
extends AbstractMove<Solution_> {
    protected final SubChain subChain;
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final Object toPlanningValue;
    protected final Object oldTrailingLastEntity;
    protected final Object newTrailingEntity;

    public SubChainChangeMove(SubChain subChain, GenuineVariableDescriptor<Solution_> variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, Object toPlanningValue) {
        this.subChain = subChain;
        this.variableDescriptor = variableDescriptor;
        this.toPlanningValue = toPlanningValue;
        this.oldTrailingLastEntity = inverseVariableSupply.getInverseSingleton(subChain.getLastEntity());
        this.newTrailingEntity = toPlanningValue == null ? null : inverseVariableSupply.getInverseSingleton(toPlanningValue);
    }

    public SubChainChangeMove(SubChain subChain, GenuineVariableDescriptor<Solution_> variableDescriptor, Object toPlanningValue, Object oldTrailingLastEntity, Object newTrailingEntity) {
        this.subChain = subChain;
        this.variableDescriptor = variableDescriptor;
        this.toPlanningValue = toPlanningValue;
        this.oldTrailingLastEntity = oldTrailingLastEntity;
        this.newTrailingEntity = newTrailingEntity;
    }

    public String getVariableName() {
        return this.variableDescriptor.getVariableName();
    }

    public SubChain getSubChain() {
        return this.subChain;
    }

    public Object getToPlanningValue() {
        return this.toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        if (this.subChain.getEntityList().contains(this.toPlanningValue)) {
            return false;
        }
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return !Objects.equals(oldFirstValue, this.toPlanningValue);
    }

    @Override
    public SubChainChangeMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return new SubChainChangeMove<Solution_>(this.subChain, this.variableDescriptor, oldFirstValue, this.newTrailingEntity, this.oldTrailingLastEntity);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        Object firstEntity = this.subChain.getFirstEntity();
        Object lastEntity = this.subChain.getLastEntity();
        Object oldFirstValue = this.variableDescriptor.getValue(firstEntity);
        if (this.oldTrailingLastEntity != null) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, this.oldTrailingLastEntity, oldFirstValue);
        }
        scoreDirector.changeVariableFacade(this.variableDescriptor, firstEntity, this.toPlanningValue);
        if (this.newTrailingEntity != null) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, this.newTrailingEntity, lastEntity);
        }
    }

    @Override
    public SubChainChangeMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new SubChainChangeMove<Solution_>(this.subChain.rebase(destinationScoreDirector), this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.toPlanningValue), destinationScoreDirector.lookUpWorkingObject(this.oldTrailingLastEntity), destinationScoreDirector.lookUpWorkingObject(this.newTrailingEntity));
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return this.subChain.getEntityList();
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubChainChangeMove other = (SubChainChangeMove)o;
        return Objects.equals(this.subChain, other.subChain) && Objects.equals(this.variableDescriptor, other.variableDescriptor) && Objects.equals(this.toPlanningValue, other.toPlanningValue);
    }

    public int hashCode() {
        return Objects.hash(this.subChain, this.variableDescriptor, this.toPlanningValue);
    }

    public String toString() {
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return this.subChain.toDottedString() + " {" + oldFirstValue + " -> " + this.toPlanningValue + "}";
    }
}

