/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.admin.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.admin.ExecutionErrorInstance;
import org.kie.server.api.model.admin.ExecutionErrorInstanceList;
import org.kie.server.api.model.admin.MigrationReportInstance;
import org.kie.server.api.model.admin.MigrationReportInstanceList;
import org.kie.server.api.model.admin.ProcessNode;
import org.kie.server.api.model.admin.ProcessNodeList;
import org.kie.server.api.model.admin.TimerInstance;
import org.kie.server.api.model.admin.TimerInstanceList;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.admin.ProcessAdminServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class ProcessAdminServicesClientImpl
extends AbstractKieServicesClientImpl
implements ProcessAdminServicesClient {
    public ProcessAdminServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public ProcessAdminServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public MigrationReportInstance migrateProcessInstance(String containerId, Long processInstanceId, String targetContainerId, String targetProcessId) {
        return this.migrateProcessInstance(containerId, processInstanceId, targetContainerId, targetProcessId, new HashMap<String, String>());
    }

    @Override
    public MigrationReportInstance migrateProcessInstance(String containerId, Long processInstanceId, String targetContainerId, String targetProcessId, Map<String, String> nodeMapping) {
        MigrationReportInstance reportInstance = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String queryString = "?targetContainerId=" + targetContainerId + "&targetProcessId=" + targetProcessId;
            reportInstance = this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/processes/instances/{processInstanceId}", valuesMap) + queryString, nodeMapping, MigrationReportInstance.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "migrateProcessInstance", this.serialize(this.safeMap(nodeMapping)), this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId, targetContainerId, targetProcessId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            reportInstance = (MigrationReportInstance)response.getResult();
        }
        return reportInstance;
    }

    @Override
    public List<MigrationReportInstance> migrateProcessInstances(String containerId, List<Long> processInstancesId, String targetContainerId, String targetProcessId) {
        return this.migrateProcessInstances(containerId, processInstancesId, targetContainerId, targetProcessId, new HashMap<String, String>());
    }

    @Override
    public List<MigrationReportInstance> migrateProcessInstances(String containerId, List<Long> processInstancesId, String targetContainerId, String targetProcessId, Map<String, String> nodeMapping) {
        MigrationReportInstanceList reportInstanceList = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String queryStringBase = this.buildQueryString("processInstanceId", processInstancesId);
            String queryString = queryStringBase + "&targetContainerId=" + targetContainerId + "&targetProcessId=" + targetProcessId;
            reportInstanceList = this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/processes/instances", valuesMap) + queryString, nodeMapping, MigrationReportInstanceList.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "migrateProcessInstances", this.serialize(this.safeMap(nodeMapping)), this.marshaller.getFormat().getType(), new Object[]{containerId, processInstancesId, targetContainerId, targetProcessId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            reportInstanceList = (MigrationReportInstanceList)response.getResult();
        }
        if (reportInstanceList != null) {
            return reportInstanceList.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public MigrationReportInstance migrateProcessInstanceWithSubprocess(String containerId, Long processInstanceId, String targetContainerId, String targetProcessId) {
        return this.migrateProcessInstanceWithSubprocess(containerId, processInstanceId, targetContainerId, targetProcessId, new HashMap<String, String>());
    }

    @Override
    public MigrationReportInstance migrateProcessInstanceWithSubprocess(String containerId, Long processInstanceId, String targetContainerId, String targetProcessId, Map<String, String> nodeMapping) {
        MigrationReportInstance reportInstance;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String queryString = "?targetContainerId=" + targetContainerId + "&targetProcessId=" + targetProcessId;
            reportInstance = this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/processes/instances/{processInstanceId}/subprocess", valuesMap) + queryString, nodeMapping, MigrationReportInstance.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "migrateProcessInstanceWithAllSubprocess", this.serialize(this.safeMap(nodeMapping)), this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId, targetContainerId, targetProcessId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            reportInstance = (MigrationReportInstance)response.getResult();
        }
        return reportInstance;
    }

    @Override
    public List<ProcessNode> getProcessNodes(String containerId, Long processInstanceId) {
        ProcessNodeList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/processes/instances/{processInstanceId}/nodes", valuesMap), ProcessNodeList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "getProcessNodes", new Object[]{containerId, processInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (ProcessNodeList)response.getResult();
        }
        if (result != null && result.getItems() != null) {
            return result.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public void cancelNodeInstance(String containerId, Long processInstanceId, Long nodeInstanceId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            valuesMap.put("nodeInstanceId", nodeInstanceId);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/processes/instances/{processInstanceId}/nodeinstances/{nodeInstanceId}", valuesMap), null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "cancelNodeInstance", new Object[]{containerId, processInstanceId, nodeInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void retriggerNodeInstance(String containerId, Long processInstanceId, Long nodeInstanceId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            valuesMap.put("nodeInstanceId", nodeInstanceId);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/processes/instances/{processInstanceId}/nodeinstances/{nodeInstanceId}", valuesMap), null, null, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "retriggerNodeInstance", new Object[]{containerId, processInstanceId, nodeInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public List<NodeInstance> getActiveNodeInstances(String containerId, Long processInstanceId) {
        NodeInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/processes/instances/{processInstanceId}/nodeinstances", valuesMap), NodeInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "getActiveNodeInstances", new Object[]{containerId, processInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (NodeInstanceList)response.getResult();
        }
        if (result != null && result.getItems() != null) {
            return result.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public void updateTimer(String containerId, Long processInstanceId, long timerId, long delay, long period, int repeatLimit) {
        this.updateTimer(containerId, processInstanceId, timerId, delay, period, repeatLimit, false);
    }

    @Override
    public void updateTimerRelative(String containerId, Long processInstanceId, long timerId, long delay, long period, int repeatLimit) {
        this.updateTimer(containerId, processInstanceId, timerId, delay, period, repeatLimit, true);
    }

    @Override
    public List<TimerInstance> getTimerInstances(String containerId, Long processInstanceId) {
        TimerInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/processes/instances/{processInstanceId}/timers", valuesMap), TimerInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "getTimerInstances", new Object[]{containerId, processInstanceId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (TimerInstanceList)response.getResult();
        }
        if (result != null && result.getItems() != null) {
            return result.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public void triggerNode(String containerId, Long processInstanceId, Long nodeId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            valuesMap.put("nodeId", nodeId);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/processes/instances/{processInstanceId}/nodes/{nodeId}", valuesMap), null, null, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "triggerNode", new Object[]{containerId, processInstanceId, nodeId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void acknowledgeError(String containerId, String ... errorId) {
        ArrayList<String> errorIds = new ArrayList<String>(Arrays.asList(errorId));
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String endpoint = "errors/{errorId}";
            String queryString = "";
            if (errorIds.size() > 1) {
                endpoint = "errors";
                queryString = this.getAdditionalParams(queryString, "errorId", errorIds);
            } else {
                valuesMap.put("errorId", errorIds.get(0));
            }
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)("admin/containers/{containerId}/processes/" + endpoint), valuesMap) + queryString, "", String.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "acknowledgeError", new Object[]{containerId, this.safeList(errorIds)})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public ExecutionErrorInstance getError(String containerId, String errorId) {
        ExecutionErrorInstance result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("errorId", errorId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/processes/errors/{errorId}", valuesMap), ExecutionErrorInstance.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "getError", new Object[]{containerId, errorId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (ExecutionErrorInstance)response.getResult();
        }
        return result;
    }

    @Override
    public List<ExecutionErrorInstance> getErrors(String containerId, boolean includeAcknowledged, Integer page, Integer pageSize) {
        ExecutionErrorInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            String queryString = "?includeAck=" + includeAcknowledged;
            queryString = this.getPagingQueryString(queryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)("admin/containers/{containerId}/processes/errors" + queryString), valuesMap), ExecutionErrorInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "getExecutionErrors", new Object[]{containerId, includeAcknowledged, page, pageSize, "", true})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (ExecutionErrorInstanceList)response.getResult();
        }
        if (result != null && result.getItems() != null) {
            return result.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<ExecutionErrorInstance> getErrorsByProcessInstance(String containerId, Long processInstanceId, boolean includeAcknowledged, Integer page, Integer pageSize) {
        return this.getErrorsByProcessInstanceAndNode(containerId, processInstanceId, "", includeAcknowledged, page, pageSize);
    }

    @Override
    public List<ExecutionErrorInstance> getErrorsByProcessInstanceAndNode(String containerId, Long processInstanceId, String nodeName, boolean includeAcknowledged, Integer page, Integer pageSize) {
        ExecutionErrorInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            String queryString = "?includeAck=" + includeAcknowledged + "&node=" + nodeName;
            queryString = this.getPagingQueryString(queryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)("admin/containers/{containerId}/processes/instances/{processInstanceId}/errors" + queryString), valuesMap), ExecutionErrorInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "getExecutionErrorsByProcessInstance", new Object[]{containerId, processInstanceId, nodeName, includeAcknowledged, page, pageSize, "", true})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (ExecutionErrorInstanceList)response.getResult();
        }
        if (result != null && result.getItems() != null) {
            return result.getItems();
        }
        return Collections.emptyList();
    }

    protected void updateTimer(String containerId, Long processInstanceId, long timerId, long delay, long period, int repeatLimit, boolean relative) {
        HashMap<String, Number> timerUpdate = new HashMap<String, Number>();
        timerUpdate.put("delay", delay);
        timerUpdate.put("period", period);
        timerUpdate.put("repeatLimit", repeatLimit);
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("processInstanceId", processInstanceId);
            valuesMap.put("timerId", timerId);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/processes/instances/{processInstanceId}/timers/{timerId}", valuesMap) + "?relative=" + relative, timerUpdate, null, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ProcessAdminService", "updateTimer", this.serialize(timerUpdate), this.marshaller.getFormat().getType(), new Object[]{containerId, processInstanceId, timerId, relative})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }
}

