/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit.datasources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.IdentityObjectStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.PropagationList;
import org.drools.core.phreak.SynchronizedPropagationList;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.spi.Activation;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.bitmask.BitMask;
import org.drools.ruleunit.RuleUnit;
import org.drools.ruleunit.datasources.DataSourceFactHandle;
import org.drools.ruleunit.datasources.InternalDataSource;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;

public class CursoredDataSource<T>
implements InternalDataSource<T> {
    private InternalWorkingMemory workingMemory;
    private ObjectStore objectStore = new IdentityObjectStore();
    private Map<RuleUnit.Identity, PropagationList> propagationsMap = new HashMap<RuleUnit.Identity, PropagationList>();
    private RuleUnit.Identity currentUnit;
    private EntryPoint currentEntryPoint;
    private List<T> inserted;

    public CursoredDataSource() {
    }

    public CursoredDataSource(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        if (this.inserted != null) {
            this.inserted.forEach(this::insertIntoWm);
            this.inserted = null;
        }
    }

    @Override
    public FactHandle getFactHandleForObject(Object object) {
        if (this.objectStore != null) {
            return this.objectStore.getHandleForObject(object);
        }
        return null;
    }

    @Override
    public FactHandle insert(T object) {
        if (this.workingMemory != null) {
            return this.insertIntoWm(object);
        }
        if (this.inserted == null) {
            this.inserted = new ArrayList<T>();
        }
        this.inserted.add(object);
        return null;
    }

    private FactHandle insertIntoWm(T object) {
        FactHandleFactory fhFactory = this.workingMemory.getFactHandleFactory();
        DataSourceFactHandle factHandle = new DataSourceFactHandle(this, fhFactory.getNextId(), fhFactory.getNextRecency(), object);
        this.objectStore.addHandle((InternalFactHandle)factHandle, object);
        this.propagate(() -> new Insert(factHandle));
        return factHandle;
    }

    @Override
    public void update(FactHandle handle, T object, String ... modifiedProperties) {
        BitMask mask = modifiedProperties == null || modifiedProperties.length == 0 ? PropertySpecificUtil.allSetButTraitBitMask() : PropertySpecificUtil.calculatePositiveMask(object.getClass(), Arrays.asList(modifiedProperties), (List)PropertySpecificUtil.getAccessibleProperties((InternalKnowledgeBase)this.workingMemory.getKnowledgeBase(), object.getClass()));
        this.internalUpdate((DataSourceFactHandle)handle, object, mask, Object.class, null);
    }

    @Override
    public void update(FactHandle fh, Object obj, BitMask mask, Class<?> modifiedClass, Activation activation) {
        DataSourceFactHandle dataSourceFactHandle = (DataSourceFactHandle)((InternalFactHandle)fh).getParentHandle();
        this.internalUpdate(dataSourceFactHandle, obj, mask, modifiedClass, activation);
    }

    private void internalUpdate(DataSourceFactHandle dataSourceFactHandle, Object obj, BitMask mask, Class<?> modifiedClass, Activation activation) {
        this.propagate(() -> new Update(dataSourceFactHandle, obj, mask, modifiedClass, activation));
    }

    private void propagate(Supplier<AbstractDataSourcePropagation> s) {
        this.propagationsMap.forEach((? super K ruId, ? super V list) -> {
            if (ruId.equals(this.currentUnit)) {
                this.workingMemory.getPropagationList().addEntry((PropagationEntry)((AbstractDataSourcePropagation)((Object)((Object)s.get()))).setEntryPoint(this.currentEntryPoint));
            } else {
                list.addEntry((PropagationEntry)s.get());
            }
        });
    }

    @Override
    public void delete(FactHandle fh) {
        DataSourceFactHandle dsFh = (DataSourceFactHandle)fh;
        this.objectStore.removeHandle((InternalFactHandle)dsFh);
        this.propagate(() -> new Delete(dsFh, null));
    }

    @Override
    public void delete(Object obj) {
        this.delete((FactHandle)this.objectStore.getHandleForObject(obj));
    }

    @Override
    public void bind(RuleUnit unit, WorkingMemoryEntryPoint ep) {
        this.setWorkingMemory(ep.getInternalWorkingMemory());
        PropagationList propagationList = this.propagationsMap.get(unit.getUnitIdentity());
        if (propagationList != null) {
            this.flush((EntryPoint)ep, propagationList.takeAll());
        } else {
            Iterator fhs = this.objectStore.iterateFactHandles();
            while (fhs.hasNext()) {
                new Insert((DataSourceFactHandle)fhs.next()).execute((EntryPoint)ep);
            }
            this.propagationsMap.put(unit.getUnitIdentity(), (PropagationList)new SynchronizedPropagationList(ep.getInternalWorkingMemory()));
        }
        this.currentUnit = unit.getUnitIdentity();
        this.currentEntryPoint = ep;
    }

    private void flush(EntryPoint ep, PropagationEntry currentHead) {
        for (PropagationEntry entry = currentHead; entry != null; entry = entry.getNext()) {
            ((AbstractDataSourcePropagation)entry).execute(ep);
        }
    }

    @Override
    public void unbind(RuleUnit unit) {
        this.currentUnit = null;
        this.currentEntryPoint = null;
    }

    @Override
    public Iterator<T> iterator() {
        return this.inserted != null ? this.inserted.iterator() : this.objectStore.iterateObjects();
    }

    static class Delete
    extends AbstractDataSourcePropagation {
        private final DataSourceFactHandle dsFactHandle;
        private final Activation activation;

        Delete(DataSourceFactHandle factHandle, Activation activation) {
            this.dsFactHandle = factHandle;
            this.activation = activation;
        }

        @Override
        public void execute(EntryPoint entryPoint) {
            WorkingMemoryEntryPoint ep = (WorkingMemoryEntryPoint)entryPoint;
            ObjectTypeConf typeConf = ep.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.dsFactHandle.getObject());
            RuleUnit.Identity ruleUnitIdentity = ((RuleUnit)ep.getRuleUnit()).getUnitIdentity();
            InternalFactHandle handle = this.dsFactHandle.childHandles.get(ruleUnitIdentity);
            PropagationContextFactory pctxFactory = ((InternalWorkingMemoryEntryPoint)ep).getPctxFactory();
            PropagationContext context = pctxFactory.createPropagationContext(ep.getInternalWorkingMemory().getNextPropagationIdCounter(), PropagationContext.Type.DELETION, this.activation == null ? null : this.activation.getRule(), this.activation == null ? null : (TerminalNode)this.activation.getTuple().getTupleSink(), handle, ep.getEntryPoint());
            ep.getEntryPointNode().propagateRetract(handle, context, typeConf, ep.getInternalWorkingMemory());
        }
    }

    static class Update
    extends AbstractDataSourcePropagation {
        private final DataSourceFactHandle dsFactHandle;
        private final Object object;
        private final BitMask mask;
        private final Class<?> modifiedClass;
        private final Activation activation;

        Update(DataSourceFactHandle factHandle, Object object, BitMask mask, Class<?> modifiedClass, Activation activation) {
            this.dsFactHandle = factHandle;
            this.object = object;
            this.mask = mask;
            this.modifiedClass = modifiedClass;
            this.activation = activation;
        }

        @Override
        public void execute(EntryPoint entryPoint) {
            WorkingMemoryEntryPoint ep = (WorkingMemoryEntryPoint)entryPoint;
            ObjectTypeConf typeConf = ep.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.object);
            RuleUnit.Identity ruleUnitIdentity = ((RuleUnit)ep.getRuleUnit()).getUnitIdentity();
            InternalFactHandle handle = this.dsFactHandle.childHandles.get(ruleUnitIdentity);
            PropagationContextFactory pctxFactory = ((InternalWorkingMemoryEntryPoint)ep).getPctxFactory();
            PropagationContext context = pctxFactory.createPropagationContext(ep.getInternalWorkingMemory().getNextPropagationIdCounter(), PropagationContext.Type.MODIFICATION, this.activation == null ? null : this.activation.getRule(), this.activation == null ? null : (TerminalNode)this.activation.getTuple().getTupleSink(), handle, ep.getEntryPoint(), this.mask, this.modifiedClass, null);
            EntryPointNode.propagateModify((InternalFactHandle)handle, (PropagationContext)context, (ObjectTypeConf)typeConf, (InternalWorkingMemory)ep.getInternalWorkingMemory());
        }
    }

    static class Insert
    extends AbstractDataSourcePropagation {
        private final DataSourceFactHandle dsFactHandle;

        Insert(DataSourceFactHandle factHandle) {
            this.dsFactHandle = factHandle;
        }

        @Override
        public void execute(EntryPoint entryPoint) {
            WorkingMemoryEntryPoint ep = (WorkingMemoryEntryPoint)entryPoint;
            ObjectTypeConf typeConf = ep.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(ep.getEntryPoint(), this.dsFactHandle.getObject());
            InternalFactHandle handleForEp = this.dsFactHandle.createFactHandleFor(ep, typeConf);
            RuleUnit.Identity ruleUnitIdentity = ((RuleUnit)ep.getRuleUnit()).getUnitIdentity();
            this.dsFactHandle.childHandles.put(ruleUnitIdentity, handleForEp);
            PropagationContextFactory pctxFactory = ((InternalWorkingMemoryEntryPoint)ep).getPctxFactory();
            PropagationContext context = pctxFactory.createPropagationContext(ep.getInternalWorkingMemory().getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, null, null, handleForEp, ep.getEntryPoint());
            for (ObjectTypeNode otn : typeConf.getObjectTypeNodes()) {
                otn.propagateAssert(handleForEp, context, ep.getInternalWorkingMemory());
            }
        }
    }

    static abstract class AbstractDataSourcePropagation
    extends PropagationEntry.AbstractPropagationEntry {
        private EntryPoint ep;

        AbstractDataSourcePropagation() {
        }

        public AbstractDataSourcePropagation setEntryPoint(EntryPoint ep) {
            this.ep = ep;
            return this;
        }

        public void execute(InternalWorkingMemory wm) {
            this.execute(this.ep);
        }

        public abstract void execute(EntryPoint var1);
    }
}

