/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class ByteUtils {
    public static final ByteBuffer EMPTY_BUF = ByteBuffer.wrap(new byte[0]);

    private ByteUtils() {
    }

    public static long readUnsignedInt(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public static long readUnsignedInt(ByteBuffer buffer, int index) {
        return (long)buffer.getInt(index) & 0xFFFFFFFFL;
    }

    public static int readUnsignedIntLE(InputStream in) throws IOException {
        return in.read() | in.read() << 8 | in.read() << 16 | in.read() << 24;
    }

    public static int readUnsignedIntLE(byte[] buffer, int offset) {
        return buffer[offset] << 0 & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24;
    }

    public static void writeUnsignedInt(ByteBuffer buffer, int index, long value) {
        buffer.putInt(index, (int)(value & 0xFFFFFFFFL));
    }

    public static void writeUnsignedInt(ByteBuffer buffer, long value) {
        buffer.putInt((int)(value & 0xFFFFFFFFL));
    }

    public static void writeUnsignedIntLE(OutputStream out, int value) throws IOException {
        out.write(value);
        out.write(value >>> 8);
        out.write(value >>> 16);
        out.write(value >>> 24);
    }

    public static void writeUnsignedIntLE(byte[] buffer, int offset, int value) {
        buffer[offset] = (byte)value;
        buffer[offset + 1] = (byte)(value >>> 8);
        buffer[offset + 2] = (byte)(value >>> 16);
        buffer[offset + 3] = (byte)(value >>> 24);
    }

    public static int readUnsignedVarint(ByteBuffer buffer) {
        byte b;
        int value = 0;
        int i = 0;
        while (((b = buffer.get()) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            if ((i += 7) <= 28) continue;
            throw ByteUtils.illegalVarintException(value);
        }
        return value |= b << i;
    }

    public static int readUnsignedVarint(DataInput in) throws IOException {
        byte b;
        int value = 0;
        int i = 0;
        while (((b = in.readByte()) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            if ((i += 7) <= 28) continue;
            throw ByteUtils.illegalVarintException(value);
        }
        return value |= b << i;
    }

    public static int readVarint(ByteBuffer buffer) {
        int value = ByteUtils.readUnsignedVarint(buffer);
        return value >>> 1 ^ -(value & 1);
    }

    public static int readVarint(DataInput in) throws IOException {
        int value = ByteUtils.readUnsignedVarint(in);
        return value >>> 1 ^ -(value & 1);
    }

    public static long readVarlong(DataInput in) throws IOException {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)in.readByte()) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw ByteUtils.illegalVarlongException(value);
        }
        return (value |= b << i) >>> 1 ^ -(value & 1L);
    }

    public static long readVarlong(ByteBuffer buffer) {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)buffer.get()) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw ByteUtils.illegalVarlongException(value);
        }
        return (value |= b << i) >>> 1 ^ -(value & 1L);
    }

    public static double readDouble(DataInput in) throws IOException {
        return in.readDouble();
    }

    public static double readDouble(ByteBuffer buffer) {
        return buffer.getDouble();
    }

    public static void writeUnsignedVarint(int value, ByteBuffer buffer) {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            byte b = (byte)(value & 0x7F | 0x80);
            buffer.put(b);
            value >>>= 7;
        }
        buffer.put((byte)value);
    }

    public static void writeUnsignedVarint(int value, DataOutput out) throws IOException {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            byte b = (byte)(value & 0x7F | 0x80);
            out.writeByte(b);
            value >>>= 7;
        }
        out.writeByte((byte)value);
    }

    public static void writeVarint(int value, DataOutput out) throws IOException {
        ByteUtils.writeUnsignedVarint(value << 1 ^ value >> 31, out);
    }

    public static void writeVarint(int value, ByteBuffer buffer) {
        ByteUtils.writeUnsignedVarint(value << 1 ^ value >> 31, buffer);
    }

    public static void writeVarlong(long value, DataOutput out) throws IOException {
        long v = value << 1 ^ value >> 63;
        while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((int)v & 0x7F | 0x80);
            v >>>= 7;
        }
        out.writeByte((byte)v);
    }

    public static void writeVarlong(long value, ByteBuffer buffer) {
        long v = value << 1 ^ value >> 63;
        while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byte b = (byte)(v & 0x7FL | 0x80L);
            buffer.put(b);
            v >>>= 7;
        }
        buffer.put((byte)v);
    }

    public static void writeDouble(double value, DataOutput out) throws IOException {
        out.writeDouble(value);
    }

    public static void writeDouble(double value, ByteBuffer buffer) {
        buffer.putDouble(value);
    }

    public static int sizeOfUnsignedVarint(int value) {
        int bytes = 1;
        while ((long)(value & 0xFFFFFF80) != 0L) {
            ++bytes;
            value >>>= 7;
        }
        return bytes;
    }

    public static int sizeOfVarint(int value) {
        return ByteUtils.sizeOfUnsignedVarint(value << 1 ^ value >> 31);
    }

    public static int sizeOfVarlong(long value) {
        long v = value << 1 ^ value >> 63;
        int bytes = 1;
        while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
            ++bytes;
            v >>>= 7;
        }
        return bytes;
    }

    private static IllegalArgumentException illegalVarintException(int value) {
        throw new IllegalArgumentException("Varint is too long, the most significant bit in the 5th byte is set, converted value: " + Integer.toHexString(value));
    }

    private static IllegalArgumentException illegalVarlongException(long value) {
        throw new IllegalArgumentException("Varlong is too long, most significant bit in the 10th byte is set, converted value: " + Long.toHexString(value));
    }
}

