/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.io.Externalizable;
import java.util.Map;
import java.util.Properties;
import org.drools.core.BeliefSystemType;
import org.drools.core.ClockType;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.TimerJobFactoryType;
import org.drools.core.process.instance.WorkItemManagerFactory;
import org.drools.core.time.TimerService;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.core.util.StringUtils;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.BeliefSystemTypeOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.DirectFiringOption;
import org.kie.api.runtime.conf.KeepReferenceOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.MultiValueKieSessionOption;
import org.kie.api.runtime.conf.QueryListenerOption;
import org.kie.api.runtime.conf.SingleValueKieSessionOption;
import org.kie.api.runtime.conf.TimedRuleExecutionFilter;
import org.kie.api.runtime.conf.TimedRuleExecutionOption;
import org.kie.api.runtime.conf.TimerJobFactoryOption;
import org.kie.api.runtime.conf.WorkItemHandlerOption;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.conf.ForceEagerActivationFilter;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;

public abstract class SessionConfiguration
implements KieSessionConfiguration,
Externalizable {
    public static SessionConfiguration newInstance() {
        return new SessionConfigurationImpl();
    }

    public static SessionConfiguration newInstance(Properties properties) {
        return new SessionConfigurationImpl(properties);
    }

    public abstract void setKeepReference(boolean var1);

    public abstract boolean isKeepReference();

    public abstract void setDirectFiring(boolean var1);

    public abstract boolean isDirectFiring();

    public abstract void setForceEagerActivationFilter(ForceEagerActivationFilter var1);

    public abstract ForceEagerActivationFilter getForceEagerActivationFilter();

    public final boolean hasForceEagerActivationFilter() {
        try {
            return this.getForceEagerActivationFilter().accept(null);
        }
        catch (Exception e) {
            return true;
        }
    }

    public abstract SessionConfiguration addDefaultProperties(Properties var1);

    public abstract void setTimedRuleExecutionFilter(TimedRuleExecutionFilter var1);

    public abstract TimedRuleExecutionFilter getTimedRuleExecutionFilter();

    public abstract BeliefSystemType getBeliefSystemType();

    public abstract void setBeliefSystemType(BeliefSystemType var1);

    public abstract ClockType getClockType();

    public abstract void setClockType(ClockType var1);

    public abstract TimerJobFactoryType getTimerJobFactoryType();

    public abstract void setTimerJobFactoryType(TimerJobFactoryType var1);

    public final TimerJobFactoryManager getTimerJobFactoryManager() {
        return this.getTimerJobFactoryType().createInstance();
    }

    public abstract Map<String, WorkItemHandler> getWorkItemHandlers();

    public abstract Map<String, WorkItemHandler> getWorkItemHandlers(Map<String, Object> var1);

    public abstract WorkItemManagerFactory getWorkItemManagerFactory();

    public abstract void setWorkItemManagerFactory(WorkItemManagerFactory var1);

    public abstract String getProcessInstanceManagerFactory();

    public abstract String getSignalManagerFactory();

    public abstract ExecutableRunner getRunner(KieBase var1, Environment var2);

    public abstract TimerService newTimerService();

    public abstract QueryListenerOption getQueryListenerOption();

    public abstract void setQueryListenerOption(QueryListenerOption var1);

    public final <T extends KieSessionOption> void setOption(T option) {
        if (option instanceof ClockTypeOption) {
            this.setClockType(ClockType.resolveClockType(((ClockTypeOption)option).getClockType()));
        } else if (option instanceof TimerJobFactoryOption) {
            this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(((TimerJobFactoryOption)option).getTimerJobType()));
        } else if (option instanceof KeepReferenceOption) {
            this.setKeepReference(((KeepReferenceOption)option).isKeepReference());
        } else if (option instanceof DirectFiringOption) {
            this.setDirectFiring(((DirectFiringOption)option).isDirectFiring());
        } else if (option instanceof ForceEagerActivationOption) {
            this.setForceEagerActivationFilter(((ForceEagerActivationOption)option).getFilter());
        } else if (option instanceof TimedRuleExecutionOption) {
            this.setTimedRuleExecutionFilter(((TimedRuleExecutionOption)option).getFilter());
        } else if (option instanceof WorkItemHandlerOption) {
            this.getWorkItemHandlers().put(((WorkItemHandlerOption)option).getName(), ((WorkItemHandlerOption)option).getHandler());
        } else if (option instanceof QueryListenerOption) {
            this.setQueryListenerOption((QueryListenerOption)option);
        } else if (option instanceof BeliefSystemTypeOption) {
            this.setBeliefSystemType(BeliefSystemType.resolveBeliefSystemType(((BeliefSystemTypeOption)option).getBeliefSystemType()));
        }
    }

    public final <T extends SingleValueKieSessionOption> T getOption(Class<T> option) {
        if (ClockTypeOption.class.equals(option)) {
            return (T)ClockTypeOption.get((String)this.getClockType().toExternalForm());
        }
        if (KeepReferenceOption.class.equals(option)) {
            return (T)(this.isKeepReference() ? KeepReferenceOption.YES : KeepReferenceOption.NO);
        }
        if (DirectFiringOption.class.equals(option)) {
            return (T)(this.isDirectFiring() ? DirectFiringOption.YES : DirectFiringOption.NO);
        }
        if (TimerJobFactoryOption.class.equals(option)) {
            return (T)TimerJobFactoryOption.get((String)this.getTimerJobFactoryType().toExternalForm());
        }
        if (QueryListenerOption.class.equals(option)) {
            return (T)this.getQueryListenerOption();
        }
        if (BeliefSystemTypeOption.class.equals(option)) {
            return (T)BeliefSystemTypeOption.get((String)this.getBeliefSystemType().getId());
        }
        return null;
    }

    public final <T extends MultiValueKieSessionOption> T getOption(Class<T> option, String key) {
        if (WorkItemHandlerOption.class.equals(option)) {
            return (T)WorkItemHandlerOption.get((String)key, (WorkItemHandler)this.getWorkItemHandlers().get(key));
        }
        return null;
    }

    public final void setProperty(String name, String value) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return;
        }
        if (name.equals("drools.keepReference")) {
            this.setKeepReference(StringUtils.isEmpty(value) || Boolean.parseBoolean(value));
        } else if (name.equals("drools.directFiring")) {
            this.setDirectFiring(!StringUtils.isEmpty(value) && Boolean.parseBoolean(value));
        } else if (name.equals("drools.forceEagerActivation")) {
            this.setForceEagerActivationFilter(ForceEagerActivationOption.resolve((String)(StringUtils.isEmpty(value) ? "false" : value)).getFilter());
        } else if (name.equals("drools.timedRuleExecution")) {
            this.setTimedRuleExecutionFilter(TimedRuleExecutionOption.resolve((String)(StringUtils.isEmpty(value) ? "false" : value)).getFilter());
        } else if (name.equals("drools.clockType")) {
            this.setClockType(ClockType.resolveClockType(StringUtils.isEmpty(value) ? "realtime" : value));
        } else if (name.equals("drools.timerJobFactory")) {
            this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(StringUtils.isEmpty(value) ? "default" : value));
        } else if (name.equals("drools.queryListener")) {
            String property = StringUtils.isEmpty(value) ? QueryListenerOption.STANDARD.getAsString() : value;
            this.setQueryListenerOption(QueryListenerOption.determineQueryListenerClassOption((String)property));
        } else if (name.equals("drools.beliefSystem")) {
            this.setBeliefSystemType(StringUtils.isEmpty(value) ? BeliefSystemType.SIMPLE : BeliefSystemType.resolveBeliefSystemType(value));
        }
    }

    public final String getProperty(String name) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return null;
        }
        if (name.equals("drools.keepReference")) {
            return Boolean.toString(this.isKeepReference());
        }
        if (name.equals("drools.directFiring")) {
            return Boolean.toString(this.isDirectFiring());
        }
        if (name.equals("drools.clockType")) {
            return this.getClockType().toExternalForm();
        }
        if (name.equals("drools.timerJobFactory")) {
            return this.getTimerJobFactoryType().toExternalForm();
        }
        if (name.equals("drools.queryListener")) {
            return this.getQueryListenerOption().getAsString();
        }
        if (name.equals("drools.beliefSystem")) {
            return this.getBeliefSystemType().getId();
        }
        return null;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionConfiguration that = (SessionConfiguration)o;
        return this.isKeepReference() == that.isKeepReference() && this.getBeliefSystemType() == that.getBeliefSystemType() && this.getClockType() == that.getClockType() && this.getTimerJobFactoryType() == that.getTimerJobFactoryType();
    }

    public final int hashCode() {
        int result = this.isKeepReference() ? 1 : 0;
        result = 31 * result + this.getClockType().hashCode();
        result = 31 * result + this.getBeliefSystemType().hashCode();
        result = 31 * result + this.getTimerJobFactoryType().hashCode();
        return result;
    }
}

