/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.common.ActivationGroupImpl;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationsFilter;
import org.drools.core.common.AgendaGroupFactory;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.TruthMaintenanceSystemHelper;
import org.drools.core.concurrent.RuleEvaluator;
import org.drools.core.concurrent.SequentialRuleEvaluator;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.phreak.ExecutableEntry;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.PropagationList;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.SynchronizedBypassPropagationList;
import org.drools.core.phreak.SynchronizedPropagationList;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.QueryImpl;
import org.drools.core.spi.Activation;
import org.drools.core.spi.AgendaGroup;
import org.drools.core.spi.ConsequenceExceptionHandler;
import org.drools.core.spi.InternalActivationGroup;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.RuleFlowGroup;
import org.drools.core.spi.Tuple;
import org.drools.core.util.LinkedList;
import org.drools.core.util.StringUtils;
import org.drools.core.util.index.TupleList;
import org.drools.reflective.ComponentsFactory;
import org.kie.api.event.rule.MatchCancelledCause;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAgenda
implements Externalizable,
InternalAgenda {
    public static final String ON_BEFORE_ALL_FIRES_CONSEQUENCE_NAME = "$onBeforeAllFire$";
    public static final String ON_AFTER_ALL_FIRES_CONSEQUENCE_NAME = "$onAfterAllFire$";
    public static final String ON_DELETE_MATCH_CONSEQUENCE_NAME = "$onDeleteMatch$";
    protected static final transient Logger log = LoggerFactory.getLogger(DefaultAgenda.class);
    private static final long serialVersionUID = 510L;
    protected InternalWorkingMemory workingMemory;
    private Map<String, InternalAgendaGroup> agendaGroups;
    private Map<String, InternalActivationGroup> activationGroups;
    private java.util.LinkedList<AgendaGroup> focusStack;
    private InternalAgendaGroup mainAgendaGroup;
    private final LinkedList<RuleAgendaItem> eager = new LinkedList();
    private final Map<QueryImpl, RuleAgendaItem> queries = new ConcurrentHashMap<QueryImpl, RuleAgendaItem>();
    private AgendaGroupFactory agendaGroupFactory;
    private ConsequenceExceptionHandler legacyConsequenceExceptionHandler;
    private org.kie.api.runtime.rule.ConsequenceExceptionHandler consequenceExceptionHandler;
    protected int activationCounter;
    private boolean declarativeAgenda;
    private boolean sequential;
    private ObjectTypeConf activationObjectTypeConf;
    private ActivationsFilter activationsFilter;
    private volatile List<PropagationContext> expirationContexts = new ArrayList<PropagationContext>();
    private RuleEvaluator ruleEvaluator;
    private PropagationList propagationList;
    private ExecutionStateMachine executionStateMachine;

    public DefaultAgenda() {
    }

    public DefaultAgenda(InternalKnowledgeBase kBase) {
        this(kBase, true);
    }

    public DefaultAgenda(InternalKnowledgeBase kBase, boolean initMain) {
        this(kBase, initMain, new ExecutionStateMachine());
    }

    DefaultAgenda(InternalKnowledgeBase kBase, boolean initMain, ExecutionStateMachine executionStateMachine) {
        Object object;
        this.agendaGroups = new HashMap<String, InternalAgendaGroup>();
        this.activationGroups = new HashMap<String, InternalActivationGroup>();
        this.focusStack = new java.util.LinkedList();
        this.agendaGroupFactory = kBase.getConfiguration().getAgendaGroupFactory();
        this.executionStateMachine = executionStateMachine;
        if (initMain) {
            this.mainAgendaGroup = this.agendaGroupFactory.createAgendaGroup("MAIN", kBase);
            this.agendaGroups.put("MAIN", this.mainAgendaGroup);
            this.focusStack.add(this.mainAgendaGroup);
        }
        if ((object = ComponentsFactory.createConsequenceExceptionHandler((String)kBase.getConfiguration().getConsequenceExceptionHandler(), (ClassLoader)kBase.getConfiguration().getClassLoader())) instanceof ConsequenceExceptionHandler) {
            this.legacyConsequenceExceptionHandler = (ConsequenceExceptionHandler)object;
        } else {
            this.consequenceExceptionHandler = (org.kie.api.runtime.rule.ConsequenceExceptionHandler)object;
        }
        this.declarativeAgenda = kBase.getConfiguration().isDeclarativeAgenda();
        this.sequential = kBase.getConfiguration().isSequential();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setWorkingMemory((InternalWorkingMemory)in.readObject());
        this.agendaGroups = (Map)in.readObject();
        this.activationGroups = (Map)in.readObject();
        this.focusStack = (java.util.LinkedList)in.readObject();
        this.mainAgendaGroup = (InternalAgendaGroup)in.readObject();
        this.agendaGroupFactory = (AgendaGroupFactory)in.readObject();
        this.legacyConsequenceExceptionHandler = (ConsequenceExceptionHandler)in.readObject();
        this.declarativeAgenda = in.readBoolean();
        this.sequential = in.readBoolean();
        this.executionStateMachine = new ExecutionStateMachine();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
        out.writeObject(this.agendaGroups);
        out.writeObject(this.activationGroups);
        out.writeObject(this.focusStack);
        out.writeObject(this.mainAgendaGroup);
        out.writeObject(this.agendaGroupFactory);
        out.writeObject(this.legacyConsequenceExceptionHandler);
        out.writeBoolean(this.declarativeAgenda);
        out.writeBoolean(this.sequential);
    }

    @Override
    public RuleAgendaItem createRuleAgendaItem(int salience, PathMemory rs, TerminalNode rtn) {
        String agendaGroupName = rtn.getRule().getAgendaGroup();
        String ruleFlowGroupName = rtn.getRule().getRuleFlowGroup();
        RuleAgendaItem lazyAgendaItem = !StringUtils.isEmpty(ruleFlowGroupName) ? new RuleAgendaItem(this.activationCounter++, null, salience, null, rs, rtn, this.isDeclarativeAgenda(), (InternalAgendaGroup)this.getAgendaGroup(ruleFlowGroupName)) : new RuleAgendaItem(this.activationCounter++, null, salience, null, rs, rtn, this.isDeclarativeAgenda(), (InternalAgendaGroup)((Object)this.getRuleFlowGroup(agendaGroupName)));
        return lazyAgendaItem;
    }

    @Override
    public AgendaItem createAgendaItem(RuleTerminalNodeLeftTuple rtnLeftTuple, int salience, PropagationContext context, RuleAgendaItem ruleAgendaItem, InternalAgendaGroup agendaGroup) {
        rtnLeftTuple.init(this.activationCounter++, salience, context, ruleAgendaItem, agendaGroup);
        rtnLeftTuple.setContextObject(rtnLeftTuple);
        return rtnLeftTuple;
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.mainAgendaGroup = (InternalAgendaGroup)this.getAgendaGroup("MAIN");
        this.ruleEvaluator = new SequentialRuleEvaluator(this);
        this.propagationList = this.createPropagationList();
    }

    private PropagationList createPropagationList() {
        return this.workingMemory.getSessionConfiguration().hasForceEagerActivationFilter() ? new SynchronizedBypassPropagationList(this.workingMemory) : new SynchronizedPropagationList(this.workingMemory);
    }

    @Override
    public PropagationList getPropagationList() {
        return this.propagationList;
    }

    @Override
    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public void addEagerRuleAgendaItem(RuleAgendaItem item) {
        if (this.sequential) {
            return;
        }
        if (item.isInList(this.eager)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Added {} to eager evaluation list.", (Object)item.getRule().getName());
        }
        this.eager.add(item);
    }

    @Override
    public void removeEagerRuleAgendaItem(RuleAgendaItem item) {
        if (!item.isInList(this.eager)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Removed {} from eager evaluation list.", (Object)item.getRule().getName());
        }
        this.eager.remove(item);
    }

    @Override
    public void addQueryAgendaItem(RuleAgendaItem item) {
        this.queries.put((QueryImpl)item.getRule(), item);
        if (log.isTraceEnabled()) {
            log.trace("Added {} to query evaluation list.", (Object)item.getRule().getName());
        }
    }

    @Override
    public void removeQueryAgendaItem(RuleAgendaItem item) {
        this.queries.remove(item.getRule());
        if (log.isTraceEnabled()) {
            log.trace("Removed {} from query evaluation list.", (Object)item.getRule().getName());
        }
    }

    @Override
    public void addItemToActivationGroup(AgendaItem item) {
        if (item.isRuleAgendaItem()) {
            throw new UnsupportedOperationException("defensive programming, making sure this isn't called, before removing");
        }
        String group = item.getRule().getActivationGroup();
        if (group != null && group.length() > 0) {
            InternalActivationGroup actgroup = this.getActivationGroup(group);
            if (actgroup.getTriggeredForRecency() != 0L && actgroup.getTriggeredForRecency() >= item.getPropagationContext().getFactHandle().getRecency()) {
                return;
            }
            actgroup.addActivation(item);
        }
    }

    @Override
    public void insertAndStageActivation(AgendaItem activation) {
        if (this.activationObjectTypeConf == null) {
            EntryPointId ep = this.workingMemory.getEntryPoint();
            this.activationObjectTypeConf = this.workingMemory.getWorkingMemoryEntryPoint(ep.getEntryPointId()).getObjectTypeConfigurationRegistry().getObjectTypeConf(activation);
        }
        InternalFactHandle factHandle = this.workingMemory.getFactHandleFactory().newFactHandle(activation, this.activationObjectTypeConf, this.workingMemory, this.workingMemory);
        this.workingMemory.getEntryPointNode().assertActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
        activation.setActivationFactHandle(factHandle);
    }

    @Override
    public boolean isDeclarativeAgenda() {
        return this.declarativeAgenda;
    }

    @Override
    public void modifyActivation(AgendaItem activation, boolean previouslyActive) {
        InternalFactHandle factHandle = activation.getActivationFactHandle();
        if (factHandle != null) {
            this.workingMemory.getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
        }
    }

    @Override
    public void addAgendaGroup(AgendaGroup agendaGroup) {
        this.agendaGroups.put(agendaGroup.getName(), (InternalAgendaGroup)agendaGroup);
    }

    @Override
    public boolean isRuleActiveInRuleFlowGroup(String ruleflowGroupName, String ruleName, long processInstanceId) {
        return this.isRuleInstanceAgendaItem(ruleflowGroupName, ruleName, processInstanceId);
    }

    @Override
    public void cancelActivation(Activation activation) {
        AgendaItem item = (AgendaItem)activation;
        item.removeAllBlockersAndBlocked(this);
        this.workingMemory.cancelActivation(activation, this.isDeclarativeAgenda());
        if (this.isDeclarativeAgenda()) {
            if (activation.getActivationFactHandle() == null) {
                return;
            }
            if (activation.getActivationGroupNode() != null) {
                activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
            }
        }
        if (activation.isQueued()) {
            if (activation.getActivationGroupNode() != null) {
                activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
            }
            ((Tuple)((Object)activation)).decreaseActivationCountForEvents();
            this.workingMemory.getAgendaEventSupport().fireActivationCancelled(activation, this.workingMemory, MatchCancelledCause.WME_MODIFY);
        }
        if (item.getRuleAgendaItem() != null) {
            item.getRuleAgendaItem().getRuleExecutor().fireConsequenceEvent(this.workingMemory, this, item, ON_DELETE_MATCH_CONSEQUENCE_NAME);
        }
        this.workingMemory.getRuleEventSupport().onDeleteMatch(item);
        TruthMaintenanceSystemHelper.removeLogicalDependencies(activation, (Tuple)((Object)activation), activation.getRule());
    }

    @Override
    public boolean setFocus(AgendaGroup agendaGroup) {
        if (this.focusStack.getLast() != agendaGroup) {
            ((InternalAgendaGroup)this.focusStack.getLast()).setActive(false);
            this.focusStack.add(agendaGroup);
            InternalAgendaGroup igroup = (InternalAgendaGroup)agendaGroup;
            igroup.setActive(true);
            igroup.setActivatedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            InternalWorkingMemory eventsupport = this.workingMemory;
            eventsupport.getAgendaEventSupport().fireAgendaGroupPushed(agendaGroup, this.workingMemory);
            return true;
        }
        return false;
    }

    @Override
    public void setFocus(String name) {
        this.setFocus(null, name);
    }

    public void setFocus(PropagationContext ctx, String name) {
        AgendaGroup agendaGroup = this.getAgendaGroup(name);
        agendaGroup.setAutoFocusActivator(ctx);
        this.setFocus(agendaGroup);
    }

    @Override
    public AgendaGroup getFocus() {
        return this.focusStack.getLast();
    }

    @Override
    public InternalAgendaGroup getNextFocus() {
        InternalAgendaGroup agendaGroup;
        if (this.focusStack.isEmpty()) {
            return null;
        }
        while ((agendaGroup = (InternalAgendaGroup)this.focusStack.getLast()).isAutoDeactivate()) {
            boolean empty = agendaGroup.isEmpty();
            if (empty && this.focusStack.size() > 1) {
                agendaGroup.setActive(false);
                this.removeLast();
                if (agendaGroup.isAutoDeactivate() && !agendaGroup.getNodeInstances().isEmpty()) {
                    this.workingMemory.getAgendaEventSupport().fireBeforeRuleFlowGroupDeactivated((InternalRuleFlowGroup)agendaGroup, this.workingMemory);
                    this.innerDeactiveRuleFlowGroup((InternalRuleFlowGroup)agendaGroup);
                    this.workingMemory.getAgendaEventSupport().fireAfterRuleFlowGroupDeactivated((InternalRuleFlowGroup)agendaGroup, this.workingMemory);
                }
                InternalWorkingMemory eventsupport = this.workingMemory;
                eventsupport.getAgendaEventSupport().fireAgendaGroupPopped(agendaGroup, this.workingMemory);
                continue;
            }
            agendaGroup = empty ? null : agendaGroup;
            break;
        }
        if (agendaGroup != null && !agendaGroup.isActive()) {
            agendaGroup.setActivatedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            agendaGroup.setActive(true);
        }
        return agendaGroup;
    }

    private void removeLast() {
        ((InternalAgendaGroup)this.focusStack.removeLast()).visited();
    }

    private boolean removeGroup(InternalAgendaGroup group) {
        boolean existed = this.focusStack.remove(group);
        group.visited();
        return existed;
    }

    private void clearFocusStack() {
        for (AgendaGroup group : this.focusStack) {
            ((InternalAgendaGroup)group).visited();
        }
        this.focusStack.clear();
    }

    @Override
    public RuleAgendaItem peekNextRule() {
        return (RuleAgendaItem)((InternalAgendaGroup)this.focusStack.peekLast()).peek();
    }

    @Override
    public AgendaGroup getAgendaGroup(String name) {
        return this.getAgendaGroup(name, this.workingMemory == null ? null : this.workingMemory.getKnowledgeBase());
    }

    @Override
    public AgendaGroup getAgendaGroup(String name, InternalKnowledgeBase kBase) {
        String groupName = name == null || name.length() == 0 ? "MAIN" : name;
        InternalAgendaGroup agendaGroup = this.agendaGroups.get(groupName);
        if (agendaGroup == null) {
            agendaGroup = this.agendaGroupFactory.createAgendaGroup(name, kBase);
            this.addAgendaGroup(agendaGroup);
        }
        agendaGroup.setWorkingMemory(this.getWorkingMemory());
        return agendaGroup;
    }

    @Override
    public AgendaGroup[] getAgendaGroups() {
        return this.agendaGroups.values().toArray(new AgendaGroup[this.agendaGroups.size()]);
    }

    @Override
    public Map<String, InternalAgendaGroup> getAgendaGroupsMap() {
        return this.agendaGroups;
    }

    @Override
    public AgendaGroup[] getStack() {
        return this.focusStack.toArray(new AgendaGroup[this.focusStack.size()]);
    }

    @Override
    public java.util.LinkedList<AgendaGroup> getStackList() {
        return this.focusStack;
    }

    @Override
    public void addAgendaGroupOnStack(AgendaGroup agendaGroup) {
        if (this.focusStack.isEmpty() || this.focusStack.getLast() != agendaGroup) {
            this.focusStack.add(agendaGroup);
        }
    }

    @Override
    public Map<String, InternalActivationGroup> getActivationGroupsMap() {
        return this.activationGroups;
    }

    @Override
    public InternalActivationGroup getActivationGroup(String name) {
        return this.activationGroups.computeIfAbsent(name, k -> new ActivationGroupImpl(this, (String)k));
    }

    @Override
    public RuleFlowGroup getRuleFlowGroup(String name) {
        return (RuleFlowGroup)((Object)this.getAgendaGroup(name));
    }

    @Override
    public void activateRuleFlowGroup(String name) {
        InternalRuleFlowGroup group = (InternalRuleFlowGroup)this.getRuleFlowGroup(name);
        this.activateRuleFlowGroup(group, (Object)-1, null);
    }

    @Override
    public void activateRuleFlowGroup(String name, long processInstanceId, String nodeInstanceId) {
        InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)this.getRuleFlowGroup(name);
        this.activateRuleFlowGroup(ruleFlowGroup, (Object)processInstanceId, nodeInstanceId);
    }

    public void activateRuleFlowGroup(InternalRuleFlowGroup group, Object processInstanceId, String nodeInstanceId) {
        this.workingMemory.getAgendaEventSupport().fireBeforeRuleFlowGroupActivated(group, this.workingMemory);
        group.setActive(true);
        group.hasRuleFlowListener(true);
        if (!StringUtils.isEmpty(nodeInstanceId)) {
            group.addNodeInstance(processInstanceId, nodeInstanceId);
            group.setActive(true);
        }
        group.setFocus();
        this.workingMemory.getAgendaEventSupport().fireAfterRuleFlowGroupActivated(group, this.workingMemory);
        this.propagationList.notifyWaitOnRest();
    }

    @Override
    public void deactivateRuleFlowGroup(String name) {
        this.deactivateRuleFlowGroup((InternalRuleFlowGroup)this.getRuleFlowGroup(name));
    }

    public void deactivateRuleFlowGroup(InternalRuleFlowGroup group) {
        if (!group.isRuleFlowListener()) {
            return;
        }
        this.workingMemory.getAgendaEventSupport().fireBeforeRuleFlowGroupDeactivated(group, this.workingMemory);
        while (this.removeGroup(group)) {
        }
        group.setActive(false);
        this.innerDeactiveRuleFlowGroup(group);
        this.workingMemory.getAgendaEventSupport().fireAfterRuleFlowGroupDeactivated(group, this.workingMemory);
    }

    private void innerDeactiveRuleFlowGroup(InternalRuleFlowGroup group) {
        group.hasRuleFlowListener(false);
        group.getNodeInstances().clear();
    }

    @Override
    public int focusStackSize() {
        int size = 0;
        for (AgendaGroup group : this.focusStack) {
            size += group.size();
        }
        return size;
    }

    @Override
    public int agendaSize() {
        int size = 0;
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            size += internalAgendaGroup.size();
        }
        return size;
    }

    @Override
    public Activation[] getActivations() {
        ArrayList<Activation> list = new ArrayList<Activation>();
        for (InternalAgendaGroup group : this.agendaGroups.values()) {
            list.addAll(Arrays.asList(group.getActivations()));
        }
        return list.toArray(new Activation[0]);
    }

    public void clear() {
        this.clearFocusStack();
        this.focusStack.add(this.mainAgendaGroup);
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            internalAgendaGroup.setClearedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            internalAgendaGroup.reset();
        }
        for (InternalActivationGroup internalActivationGroup : this.activationGroups.values()) {
            internalActivationGroup.setTriggeredForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            internalActivationGroup.reset();
        }
        this.propagationList.reset();
    }

    @Override
    public void reset() {
        this.clearFocusStack();
        this.focusStack.add(this.mainAgendaGroup);
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            internalAgendaGroup.reset();
        }
        for (InternalActivationGroup internalActivationGroup : this.activationGroups.values()) {
            internalActivationGroup.setTriggeredForRecency(this.workingMemory.getFactHandleFactory().getRecency());
            internalActivationGroup.reset();
        }
        this.eager.clear();
        this.activationCounter = 0;
        this.executionStateMachine.reset();
        this.propagationList.reset();
    }

    @Override
    public void clearAndCancel() {
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            this.clearAndCancelAgendaGroup(internalAgendaGroup);
        }
        for (InternalActivationGroup group : this.activationGroups.values()) {
            this.clearAndCancelActivationGroup(group);
        }
    }

    @Override
    public void clearAndCancelAgendaGroup(String name) {
        InternalAgendaGroup agendaGroup = this.agendaGroups.get(name);
        if (agendaGroup != null) {
            this.clearAndCancelAgendaGroup(agendaGroup);
        }
    }

    @Override
    public void clearAndCancelAgendaGroup(InternalAgendaGroup agendaGroup) {
        for (Activation activation : agendaGroup.getActivations()) {
            ((RuleAgendaItem)activation).getRuleExecutor().reEvaluateNetwork(this);
        }
        InternalWorkingMemory eventsupport = this.workingMemory;
        agendaGroup.setClearedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
        ArrayList<RuleAgendaItem> lazyItems = new ArrayList<RuleAgendaItem>();
        for (Activation aQueueable : agendaGroup.getAndClear()) {
            AgendaItem item = (AgendaItem)aQueueable;
            if (item.isRuleAgendaItem()) {
                lazyItems.add((RuleAgendaItem)item);
                ((RuleAgendaItem)item).getRuleExecutor().cancel(this.workingMemory, eventsupport);
                continue;
            }
            item.setQueued(false);
            if (item.getActivationGroupNode() != null) {
                item.getActivationGroupNode().getActivationGroup().removeActivation(item);
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled(item, this.workingMemory, MatchCancelledCause.CLEAR);
        }
        for (RuleAgendaItem lazyItem : lazyItems) {
            agendaGroup.add(lazyItem);
        }
    }

    @Override
    public void clearAndCancelActivationGroup(String name) {
        InternalActivationGroup activationGroup = this.activationGroups.get(name);
        if (activationGroup != null) {
            this.clearAndCancelActivationGroup(activationGroup);
        }
    }

    @Override
    public void clearAndCancelActivationGroup(InternalActivationGroup activationGroup) {
        InternalWorkingMemory eventsupport = this.workingMemory;
        activationGroup.setTriggeredForRecency(this.workingMemory.getFactHandleFactory().getRecency());
        Iterator it = activationGroup.iterator();
        while (it.hasNext()) {
            ActivationGroupNode node = (ActivationGroupNode)it.next();
            Activation activation = node.getActivation();
            activation.setActivationGroupNode(null);
            if (!activation.isQueued()) continue;
            activation.setQueued(false);
            activation.remove();
            RuleExecutor ruleExec = ((RuleTerminalNodeLeftTuple)activation).getRuleAgendaItem().getRuleExecutor();
            ruleExec.removeLeftTuple((LeftTuple)((Object)activation));
            eventsupport.getAgendaEventSupport().fireActivationCancelled(activation, this.workingMemory, MatchCancelledCause.CLEAR);
        }
        activationGroup.reset();
    }

    @Override
    public void clearAndCancelRuleFlowGroup(String name) {
        this.clearAndCancelAgendaGroup(this.agendaGroups.get(name));
    }

    @Override
    public int fireNextItem(AgendaFilter filter, int fireCount, int fireLimit) {
        boolean tryagain;
        int localFireCount = 0;
        do {
            tryagain = false;
            this.evaluateEagerList();
            InternalAgendaGroup group = this.getNextFocus();
            if (group == null || (localFireCount = this.ruleEvaluator.evaluateAndFire(filter, fireCount, fireLimit, group)) != 0) continue;
            tryagain = true;
            this.propagationList.flush();
        } while (tryagain);
        return localFireCount;
    }

    @Override
    public void evaluateEagerList() {
        while (!this.eager.isEmpty()) {
            RuleAgendaItem item = this.eager.removeFirst();
            if (!item.isRuleInUse()) continue;
            this.evaluateQueriesForRule(item);
            RuleExecutor ruleExecutor = item.getRuleExecutor();
            ruleExecutor.evaluateNetwork(this);
        }
    }

    public void evaluateQueriesForRule(RuleAgendaItem item) {
        RuleImpl rule = item.getRule();
        if (!rule.isQuery()) {
            for (QueryImpl query : rule.getDependingQueries()) {
                RuleAgendaItem queryAgendaItem = this.queries.remove(query);
                if (queryAgendaItem == null) continue;
                queryAgendaItem.getRuleExecutor().evaluateNetwork(this);
            }
        }
    }

    @Override
    public int sizeOfRuleFlowGroup(String name) {
        InternalAgendaGroup group = this.agendaGroups.get(name);
        if (group == null) {
            return 0;
        }
        int count = 0;
        for (Activation item : group.getActivations()) {
            if (((RuleAgendaItem)item).getRuleExecutor().getLeftTupleList().isEmpty()) continue;
            count += ((RuleAgendaItem)item).getRuleExecutor().getLeftTupleList().size();
        }
        return count;
    }

    @Override
    public boolean isRuleInstanceAgendaItem(String ruleflowGroupName, String ruleName, long processInstanceId) {
        return this.isRuleInstanceAgendaItem(ruleflowGroupName, ruleName, (Object)processInstanceId);
    }

    protected boolean isRuleInstanceAgendaItem(String ruleflowGroupName, String ruleName, Object processInstanceId) {
        Activation[] matches;
        this.propagationList.flush();
        RuleFlowGroup systemRuleFlowGroup = this.getRuleFlowGroup(ruleflowGroupName);
        for (Activation match : matches = ((InternalAgendaGroup)((Object)systemRuleFlowGroup)).getActivations()) {
            Activation act = match;
            if (act.isRuleAgendaItem()) {
                RuleExecutor ruleExecutor = ((RuleAgendaItem)act).getRuleExecutor();
                ruleExecutor.evaluateNetwork(this);
                TupleList list = ruleExecutor.getLeftTupleList();
                for (RuleTerminalNodeLeftTuple lt = (RuleTerminalNodeLeftTuple)list.getFirst(); lt != null; lt = (RuleTerminalNodeLeftTuple)lt.getNext()) {
                    if (!ruleName.equals(lt.getRule().getName()) || !this.checkProcessInstance(lt, processInstanceId)) continue;
                    return true;
                }
                continue;
            }
            if (!ruleName.equals(act.getRule().getName()) || !this.checkProcessInstance(act, processInstanceId)) continue;
            return true;
        }
        return false;
    }

    private boolean checkProcessInstance(Activation activation, Object processInstanceId) {
        Map<String, Declaration> declarations = activation.getSubRule().getOuterDeclarations();
        for (Declaration declaration : declarations.values()) {
            Object value;
            if (!"processInstance".equals(declaration.getIdentifier()) && !"org.kie.api.runtime.process.WorkflowProcessInstance".equals(declaration.getTypeName()) || !((value = declaration.getValue(this.workingMemory, activation.getTuple())) instanceof ProcessInstance)) continue;
            return this.sameProcessInstance(processInstanceId, (ProcessInstance)value);
        }
        return true;
    }

    protected boolean sameProcessInstance(Object processInstanceId, ProcessInstance value) {
        return processInstanceId.equals(value.getId());
    }

    @Override
    public String getFocusName() {
        return this.getFocus().getName();
    }

    @Override
    public void stageLeftTuple(RuleAgendaItem ruleAgendaItem, AgendaItem justified) {
        if (!ruleAgendaItem.isQueued()) {
            ruleAgendaItem.getRuleExecutor().getPathMemory().queueRuleAgendaItem(this);
        }
        ruleAgendaItem.getRuleExecutor().addLeftTuple(justified.getTuple());
    }

    @Override
    public void fireUntilHalt() {
        this.fireUntilHalt(null);
    }

    @Override
    public void fireUntilHalt(AgendaFilter agendaFilter) {
        if (log.isTraceEnabled()) {
            log.trace("Starting Fire Until Halt");
        }
        if (this.executionStateMachine.toFireUntilHalt()) {
            this.internalFireUntilHalt(agendaFilter, true);
        }
        if (log.isTraceEnabled()) {
            log.trace("Ending Fire Until Halt");
        }
    }

    void internalFireUntilHalt(AgendaFilter agendaFilter, boolean isInternalFire) {
        this.propagationList.setFiringUntilHalt(true);
        try {
            this.fireLoop(agendaFilter, -1, RestHandler.FIRE_UNTIL_HALT, isInternalFire);
        }
        finally {
            this.propagationList.setFiringUntilHalt(false);
        }
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        if (!this.executionStateMachine.toFireAllRules()) {
            return 0;
        }
        if (log.isTraceEnabled()) {
            log.trace("Starting Fire All Rules");
        }
        int fireCount = this.internalFireAllRules(agendaFilter, fireLimit, true);
        if (log.isTraceEnabled()) {
            log.trace("Ending Fire All Rules");
        }
        return fireCount;
    }

    int internalFireAllRules(AgendaFilter agendaFilter, int fireLimit, boolean isInternalFire) {
        return this.fireLoop(agendaFilter, fireLimit, RestHandler.FIRE_ALL_RULES, isInternalFire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fireLoop(AgendaFilter agendaFilter, int fireLimit, RestHandler restHandler, boolean isInternalFire) {
        int fireCount = 0;
        try {
            boolean limitReached;
            PropagationEntry head = this.propagationList.takeAll();
            boolean bl = limitReached = fireLimit == 0;
            while (this.isFiring()) {
                int returnedFireCount;
                if (head != null) {
                    this.propagationList.flush(head);
                    head = null;
                }
                if (!this.isFiring()) break;
                this.evaluateEagerList();
                InternalAgendaGroup group = this.getNextFocus();
                if (group != null && !limitReached) {
                    returnedFireCount = this.ruleEvaluator.evaluateAndFire(agendaFilter, fireCount, fireLimit, group);
                    limitReached = fireLimit > 0 && (fireCount += returnedFireCount) >= fireLimit;
                    head = this.propagationList.takeAll();
                } else {
                    returnedFireCount = 0;
                    group = null;
                }
                if (returnedFireCount != 0 || head != null || group != null && (!group.isEmpty() || group.isAutoDeactivate()) || this.flushExpirations()) continue;
                head = restHandler.handleRest(this, isInternalFire);
                if (isInternalFire || head != null) continue;
                break;
            }
            if (this.focusStack.size() == 1 && this.mainAgendaGroup.isEmpty()) {
                this.mainAgendaGroup.setActive(false);
            }
        }
        finally {
            if (isInternalFire) {
                this.executionStateMachine.immediateHalt(this.propagationList);
            }
        }
        return fireCount;
    }

    @Override
    public boolean isFiring() {
        return this.executionStateMachine.isFiring();
    }

    @Override
    public void executeTask(ExecutableEntry executable) {
        if (!this.executionStateMachine.toExecuteTask(executable)) {
            return;
        }
        try {
            executable.execute();
        }
        finally {
            this.executionStateMachine.immediateHalt(this.propagationList);
        }
    }

    @Override
    public void executeFlush() {
        if (!this.executionStateMachine.toExecuteTaskState()) {
            return;
        }
        try {
            this.flushPropagations();
        }
        finally {
            this.executionStateMachine.immediateHalt(this.propagationList);
        }
    }

    @Override
    public void activate() {
        this.executionStateMachine.activate(this, this.propagationList);
    }

    @Override
    public void deactivate() {
        this.executionStateMachine.deactivate();
    }

    @Override
    public boolean tryDeactivate() {
        return this.executionStateMachine.tryDeactivate();
    }

    @Override
    public synchronized void halt() {
        if (this.isFiring()) {
            this.propagationList.addEntry(new Halt(this.executionStateMachine));
        }
    }

    @Override
    public boolean dispose(InternalWorkingMemory wm) {
        this.propagationList.dispose();
        return this.executionStateMachine.dispose(wm);
    }

    @Override
    public boolean isAlive() {
        return this.executionStateMachine.isAlive();
    }

    public void internalHalt() {
        this.executionStateMachine.internalHalt();
    }

    @Override
    public void setActivationsFilter(ActivationsFilter filter) {
        this.activationsFilter = filter;
    }

    @Override
    public ActivationsFilter getActivationsFilter() {
        return this.activationsFilter;
    }

    @Override
    public void handleException(InternalWorkingMemory wm, Activation activation, Exception e) {
        if (this.legacyConsequenceExceptionHandler != null) {
            this.legacyConsequenceExceptionHandler.handleException(activation, wm, e);
        } else if (this.consequenceExceptionHandler != null) {
            this.consequenceExceptionHandler.handleException((Match)activation, (RuleRuntime)wm.getKnowledgeRuntime(), e);
        } else {
            throw new RuntimeException(e);
        }
    }

    @Override
    public KnowledgeHelper getKnowledgeHelper() {
        return this.ruleEvaluator.getKnowledgeHelper();
    }

    @Override
    public void addPropagation(PropagationEntry propagationEntry) {
        this.propagationList.addEntry(propagationEntry);
    }

    @Override
    public void flushPropagations() {
        this.propagationList.flush();
    }

    @Override
    public void notifyWaitOnRest() {
        this.propagationList.notifyWaitOnRest();
    }

    @Override
    public Iterator<PropagationEntry> getActionsIterator() {
        return this.propagationList.iterator();
    }

    @Override
    public boolean hasPendingPropagations() {
        return !this.propagationList.isEmpty();
    }

    @Override
    public void registerExpiration(PropagationContext ectx) {
        this.expirationContexts.add(ectx);
    }

    private boolean flushExpirations() {
        if (this.expirationContexts.isEmpty() || this.propagationList.hasEntriesDeferringExpiration()) {
            return false;
        }
        for (PropagationContext ectx : this.expirationContexts) {
            this.doRetract(ectx);
        }
        this.expirationContexts.clear();
        return true;
    }

    protected void doRetract(PropagationContext ectx) {
        InternalFactHandle factHandle = ectx.getFactHandle();
        ObjectTypeNode.retractLeftTuples(factHandle, ectx, this.workingMemory);
        ObjectTypeNode.retractRightTuples(factHandle, ectx, this.workingMemory);
        if (factHandle.isPendingRemoveFromStore()) {
            String epId = factHandle.getEntryPointName();
            ((InternalWorkingMemoryEntryPoint)this.workingMemory.getEntryPoint(epId)).removeFromObjectStore(factHandle);
        }
    }

    @Override
    public boolean isParallelAgenda() {
        return false;
    }

    static class ExecutionStateMachine {
        private volatile ExecutionState currentState = ExecutionState.INACTIVE;
        private volatile boolean wasFiringUntilHalt = false;
        private final Object stateMachineLock = new Object();

        ExecutionStateMachine() {
        }

        public boolean isFiring() {
            return this.currentState.isFiring();
        }

        public void reset() {
            this.currentState = ExecutionState.INACTIVE;
            this.wasFiringUntilHalt = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean toFireAllRules() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (this.currentState.isFiring() || !this.currentState.isAlive()) {
                    return false;
                }
                this.waitAndEnterExecutionState(ExecutionState.FIRING_ALL_RULES);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean toFireUntilHalt() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (this.currentState == ExecutionState.FIRING_UNTIL_HALT || this.currentState == ExecutionState.HALTING) {
                    return false;
                }
                this.waitAndEnterExecutionState(ExecutionState.FIRING_UNTIL_HALT);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean toExecuteTask(ExecutableEntry executable) {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (this.isFiring()) {
                    executable.enqueue();
                    return false;
                }
                if (this.currentState != ExecutionState.EXECUTING_TASK) {
                    this.waitAndEnterExecutionState(ExecutionState.EXECUTING_TASK);
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean toExecuteTaskState() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (!this.currentState.isAlive() || this.currentState.isFiring()) {
                    return false;
                }
                this.waitAndEnterExecutionState(ExecutionState.EXECUTING_TASK);
                return true;
            }
        }

        private void waitAndEnterExecutionState(ExecutionState newState) {
            this.waitInactive();
            this.setCurrentState(newState);
        }

        private void waitInactive() {
            while (this.currentState != ExecutionState.INACTIVE && this.currentState != ExecutionState.INACTIVE_ON_FIRING_UNTIL_HALT && this.currentState != ExecutionState.DISPOSED) {
                try {
                    this.stateMachineLock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void setCurrentState(ExecutionState state) {
            if (log.isDebugEnabled()) {
                log.debug("State was {} is now {}", (Object)this.currentState, (Object)state);
            }
            if (this.currentState != ExecutionState.DISPOSED) {
                this.currentState = state;
            }
        }

        public void activate(DefaultAgenda agenda, PropagationList propagationList) {
            if (this.currentState.isAlive()) {
                this.immediateHalt(propagationList);
                if (this.wasFiringUntilHalt) {
                    this.wasFiringUntilHalt = false;
                    agenda.fireUntilHalt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deactivate() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                this.pauseFiringUntilHalt();
                if (this.currentState != ExecutionState.DEACTIVATED && this.currentState.isAlive()) {
                    this.waitAndEnterExecutionState(ExecutionState.DEACTIVATED);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryDeactivate() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (!this.currentState.isAlive()) {
                    return true;
                }
                this.pauseFiringUntilHalt();
                if (this.currentState == ExecutionState.INACTIVE || this.currentState == ExecutionState.INACTIVE_ON_FIRING_UNTIL_HALT) {
                    this.setCurrentState(ExecutionState.DEACTIVATED);
                    return true;
                }
            }
            return false;
        }

        private void pauseFiringUntilHalt() {
            if (this.currentState == ExecutionState.FIRING_UNTIL_HALT) {
                this.wasFiringUntilHalt = true;
                this.setCurrentState(ExecutionState.HALTING);
                this.waitInactive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void immediateHalt(PropagationList propagationList) {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (this.currentState != ExecutionState.INACTIVE) {
                    this.setCurrentState(ExecutionState.INACTIVE);
                    this.stateMachineLock.notifyAll();
                    propagationList.onEngineInactive();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void inactiveOnFireUntilHalt() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (this.currentState != ExecutionState.INACTIVE && this.currentState != ExecutionState.INACTIVE_ON_FIRING_UNTIL_HALT) {
                    this.setCurrentState(ExecutionState.INACTIVE_ON_FIRING_UNTIL_HALT);
                    this.stateMachineLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void internalHalt() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (this.isFiring()) {
                    this.setCurrentState(ExecutionState.HALTING);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean dispose(InternalWorkingMemory workingMemory) {
            Object object = this.stateMachineLock;
            synchronized (object) {
                if (!this.currentState.isAlive()) {
                    return false;
                }
                if (this.currentState.isFiring() && this.currentState != ExecutionState.INACTIVE_ON_FIRING_UNTIL_HALT) {
                    this.setCurrentState(ExecutionState.DISPOSING);
                    workingMemory.notifyWaitOnRest();
                }
                this.waitAndEnterExecutionState(ExecutionState.DISPOSED);
                this.stateMachineLock.notifyAll();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isAlive() {
            Object object = this.stateMachineLock;
            synchronized (object) {
                return this.currentState.isAlive();
            }
        }

        public static enum ExecutionState {
            INACTIVE(false, true),
            FIRING_ALL_RULES(true, true),
            FIRING_UNTIL_HALT(true, true),
            INACTIVE_ON_FIRING_UNTIL_HALT(true, true),
            HALTING(false, true),
            EXECUTING_TASK(false, true),
            DEACTIVATED(false, true),
            DISPOSING(false, false),
            DISPOSED(false, false);

            private final boolean firing;
            private final boolean alive;

            private ExecutionState(boolean firing, boolean alive) {
                this.firing = firing;
                this.alive = alive;
            }

            public boolean isFiring() {
                return this.firing;
            }

            public boolean isAlive() {
                return this.alive;
            }
        }
    }

    static class Halt
    extends PropagationEntry.AbstractPropagationEntry {
        private final ExecutionStateMachine executionStateMachine;

        protected Halt(ExecutionStateMachine executionStateMachine) {
            this.executionStateMachine = executionStateMachine;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            this.executionStateMachine.internalHalt();
        }

        public String toString() {
            return "Halt";
        }
    }

    static interface RestHandler {
        public static final RestHandler FIRE_ALL_RULES = new FireAllRulesRestHandler();
        public static final RestHandler FIRE_UNTIL_HALT = new FireUntilHaltRestHandler();

        public PropagationEntry handleRest(DefaultAgenda var1, boolean var2);

        public static class FireUntilHaltRestHandler
        implements RestHandler {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PropagationEntry handleRest(DefaultAgenda agenda, boolean isInternalFire) {
                PropagationEntry head;
                boolean deactivated = false;
                if (isInternalFire && agenda.executionStateMachine.currentState == ExecutionStateMachine.ExecutionState.FIRING_UNTIL_HALT) {
                    agenda.executionStateMachine.inactiveOnFireUntilHalt();
                    deactivated = true;
                }
                PropagationList propagationList = agenda.propagationList;
                synchronized (propagationList) {
                    head = agenda.propagationList.takeAll();
                    if (head == null && (agenda.executionStateMachine.currentState == ExecutionStateMachine.ExecutionState.FIRING_UNTIL_HALT || agenda.executionStateMachine.currentState == ExecutionStateMachine.ExecutionState.INACTIVE_ON_FIRING_UNTIL_HALT)) {
                        agenda.propagationList.waitOnRest();
                        head = agenda.propagationList.takeAll();
                    }
                }
                if (deactivated) {
                    agenda.executionStateMachine.toFireUntilHalt();
                }
                return head;
            }
        }

        public static class FireAllRulesRestHandler
        implements RestHandler {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PropagationEntry handleRest(DefaultAgenda agenda, boolean isInternalFire) {
                Object object = agenda.executionStateMachine.stateMachineLock;
                synchronized (object) {
                    PropagationEntry head = agenda.propagationList.takeAll();
                    if (isInternalFire && head == null) {
                        agenda.internalHalt();
                    }
                    return head;
                }
            }
        }
    }
}

