/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.tri;

import java.util.Objects;
import java.util.function.Function;
import org.drools.model.Variable;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupBy;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupByAccumulator;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriGroupBy;
import org.optaplanner.core.impl.score.stream.tri.DefaultTriConstraintCollector;

public class DroolsTriGroupByAccumulator<A, B, C, NewA, NewB, NewC>
extends DroolsAbstractGroupByAccumulator<TriTuple<A, B, C>> {
    private final TriFunction<A, B, C, NewA> groupKeyAMapping;
    private final TriFunction<A, B, C, NewB> groupKeyBMapping;
    private final TriConstraintCollector<A, B, C, ?, NewC> collector;
    private final Variable<A> aVariable;
    private final Variable<B> bVariable;
    private final Variable<C> cVariable;

    public DroolsTriGroupByAccumulator(TriFunction<A, B, C, NewA> groupKeyAMapping, TriFunction<A, B, C, NewB> groupKeyBMapping, TriConstraintCollector<A, B, C, ?, NewC> collector, Variable<A> aVariable, Variable<B> bVariable, Variable<C> cVariable) {
        this.groupKeyAMapping = Objects.requireNonNull(groupKeyAMapping);
        this.groupKeyBMapping = Objects.requireNonNull(groupKeyBMapping);
        this.collector = collector != null ? collector : DefaultTriConstraintCollector.noop();
        this.aVariable = Objects.requireNonNull(aVariable);
        this.bVariable = Objects.requireNonNull(bVariable);
        this.cVariable = Objects.requireNonNull(cVariable);
    }

    @Override
    protected DroolsAbstractGroupBy<TriTuple<A, B, C>, ?> newContext() {
        return new DroolsTriGroupBy<A, B, C, NewA, NewB, NewC>(this.groupKeyAMapping, this.groupKeyBMapping, this.collector);
    }

    @Override
    protected <X> TriTuple<A, B, C> createInput(Function<Variable<X>, X> valueFinder) {
        A a = DroolsTriGroupByAccumulator.materialize(this.aVariable, valueFinder);
        B b = DroolsTriGroupByAccumulator.materialize(this.bVariable, valueFinder);
        C c = DroolsTriGroupByAccumulator.materialize(this.cVariable, valueFinder);
        return new TriTuple<A, B, C>(a, b, c);
    }
}

