/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.casemgmt;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.api.model.cases.CaseMigrationReportInstance;
import org.kie.server.remote.rest.casemgmt.AbstractCaseResource;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.CaseAdminServiceBase;
import org.kie.server.services.casemgmt.CaseManagementRuntimeDataServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Case instance administration")
@Path(value="server/admin")
public class CaseAdminResource
extends AbstractCaseResource {
    private static final Logger logger = LoggerFactory.getLogger(CaseAdminResource.class);
    private CaseAdminServiceBase caseAdminServiceBase;

    public CaseAdminResource() {
    }

    public CaseAdminResource(CaseManagementRuntimeDataServiceBase caseManagementRuntimeDataServiceBase, CaseAdminServiceBase caseAdminServiceBase, KieServerRegistry context) {
        super(caseManagementRuntimeDataServiceBase, context);
        this.caseAdminServiceBase = caseAdminServiceBase;
    }

    @ApiOperation(value="Returns case instances without authentication checks.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, response=CaseInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"instances\": [\n    {\n      \"case-id\": \"IT-0000000006\",\n      \"case-description\": \"Order for IT hardware\",\n      \"case-owner\": \"baAdmin\",\n      \"case-status\": 1,\n      \"case-definition-id\": \"itorders.orderhardware\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT\",\n      \"case-started-at\": 1540474204152,\n      \"case-completed-at\": null,\n      \"case-completion-msg\": \"\",\n      \"case-sla-compliance\": 0,\n      \"case-sla-due-date\": null,\n      \"case-file\": null,\n      \"case-milestones\": null,\n      \"case-stages\": null,\n      \"case-roles\": null\n    },\n    {\n      \"case-id\": \"IT-0000000011\",\n      \"case-description\": \"Order for IT hardware\",\n      \"case-owner\": \"baAdmin\",\n      \"case-status\": 1,\n      \"case-definition-id\": \"itorders.orderhardware\",\n      \"container-id\": \"itorders_1.0.0-SNAPSHOT6\",\n      \"case-started-at\": 1540496734746,\n      \"case-completed-at\": null,\n      \"case-completion-msg\": \"\",\n      \"case-sla-compliance\": 0,\n      \"case-sla-due-date\": null,\n      \"case-file\": null,\n      \"case-milestones\": null,\n      \"case-stages\": null,\n      \"case-roles\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="cases/instances")
    @Produces(value={"application/json", "application/xml"})
    public Response getCaseInstances(@Context HttpHeaders headers, @ApiParam(value="optional case instance status (open, closed, canceled) - defaults ot open (1) only", required=false, allowableValues="open,closed,cancelled") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder, @ApiParam(value="optional flag to load data when loading case instance", required=false) @QueryParam(value="withData") @DefaultValue(value="false") boolean withData) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            CaseInstanceList responseObject = null;
            logger.debug("About to look for case instances with status {}", (Object)status);
            responseObject = this.caseManagementRuntimeDataServiceBase.getCaseInstances(status, page, pageSize, sort, sortOrder, withData);
            logger.debug("Returning OK response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])customHeaders);
        });
    }

    @ApiOperation(value="Migrates a specified case instance to another KIE container and case definition.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case instance or Container Id not found"), @ApiResponse(code=201, response=CaseMigrationReportInstance.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"case-id\": \"IT-0000000006\",\n  \"case-migration-successful\": true,\n  \"case-migration-start\": {\n    \"java.util.Date\": 1540526940760\n  },\n  \"case-migration-end\": {\n    \"java.util.Date\": 1540526940867\n  },\n  \"case-migration-reports\": [\n    {\n      \"migration-successful\": true,\n      \"migration-start\": {\n        \"java.util.Date\": 1540526940760\n      },\n      \"migration-end\": {\n        \"java.util.Date\": 1540526940863\n      },\n      \"migration-logs\": [\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Variable instances updated = 2 for process instance id 27\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Node instances updated = 4 for process instance id 27\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Process instances updated = 1 for process instance id 27\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Task variables updated = 6 for process instance id 27\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Task audit updated = 1 for process instance id 27\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Tasks updated = 1 for process instance id 27\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Context info updated = 1 for process instance id 27\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Mapping: Node instance logs to be updated  = [0]\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Mapping: Node instance logs updated = 1 for node instance id 0\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Mapping: Task audit updated = 1 for task id 33\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Mapping: Task updated = 1 for task id 33\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Mapping: Node instance logs to be updated  = [1]\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Mapping: Node instance logs updated = 1 for node instance id 1\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Mapping: Node instance logs to be updated  = [2]\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Mapping: Node instance logs updated = 1 for node instance id 2\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Mapping: Node instance logs to be updated  = [3]\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Mapping: Node instance logs updated = 1 for node instance id 3\",\n        \"INFO Fri Oct 26 00:09:00 EDT 2018 Migration of process instance (27) completed successfully to process itorders.orderhardware2\"\n      ],\n      \"migration-process-instance\": 27\n    }\n  ]\n}")}))})
    @PUT
    @Path(value="containers/{containerId}/cases/instances/{caseId}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response migrateCaseInstance(@Context HttpHeaders headers, @ApiParam(value="container id that case instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of case instance to be migrated", required=true, example="CASE-000000001") @PathParam(value="caseId") String caseId, @ApiParam(value="container id that new case definition should be migrated to to", required=true) @QueryParam(value="targetContainerId") String targetContainerId, @ApiParam(value="process and node mapping - unique ids of old definition to new definition given as Map of Maps - ProcessMapping should provide map of process definitions (mandatory), NodeMapping should provide map of node mappings (optional)", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"NodeMapping\" : { },\n  \"ProcessMapping\" : {\n    \"insurance-claims.CarInsuranceClaimCase\" : \"insurance-claims.CarInsuranceClaimCase2\"\n  }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>ProcessMapping</key>\n            <value xsi:type=\"jaxbMap\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <entries>\n                    <entry>\n                        <key>insurance-claims.CarInsuranceClaimCase</key>\n                        <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">insurance-claims.CarInsuranceClaimCase2</value>\n                    </entry>\n                </entries>\n            </value>\n        </entry>\n        <entry>\n            <key>NodeMapping</key>\n            <value xsi:type=\"jaxbMap\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <entries/>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        return this.invokeCaseOperation(headers, "", null, (v, type, customHeaders) -> {
            CaseMigrationReportInstance responseObject = this.caseAdminServiceBase.migrateCaseInstance(containerId, caseId, targetContainerId, payload, type);
            logger.debug("Returning CREATED response with content '{}'", (Object)responseObject);
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])customHeaders);
        });
    }
}

