/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.jbpm.services.api.model.DeployedUnit;
import org.kie.internal.runtime.manager.RuntimeManagerIdFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentIdResolver
implements RuntimeManagerIdFilter {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentIdResolver.class);

    public static String matchAndReturnLatest(String deploymentId, Collection<String> availableDeployments) {
        try {
            Collection<String> matched;
            GAVInfo gav = new GAVInfo(deploymentId);
            if (deploymentId != null && gav.getVersion().equalsIgnoreCase("latest") && (matched = DeploymentIdResolver.matchDeployments(deploymentId, availableDeployments)) != null && !matched.isEmpty()) {
                return DeploymentIdResolver.findLatest(matched);
            }
        }
        catch (Exception e) {
            logger.debug("Unable to resolve latest version of deployment {} due to {}", (Object)deploymentId, (Object)e.getMessage());
        }
        return deploymentId;
    }

    public static Collection<String> matchDeployments(String deploymentId, Collection<String> availableDeployments) {
        Collection matched = CollectionUtils.select(availableDeployments, (Predicate)new GroupAndArtifactMatchPredicate(deploymentId));
        return matched;
    }

    public static String findLatest(Collection<String> deploymentIds) {
        ArrayList<ComparableVersion> comparableVersions = new ArrayList<ComparableVersion>();
        HashMap<String, String> versionToIdentifier = new HashMap<String, String>();
        for (String deploymentId : deploymentIds) {
            GAVInfo gav = new GAVInfo(deploymentId);
            comparableVersions.add(new ComparableVersion(gav.getVersion()));
            versionToIdentifier.put(gav.getVersion(), deploymentId);
        }
        ComparableVersion latest = (ComparableVersion)Collections.max(comparableVersions);
        return (String)versionToIdentifier.get(latest.toString());
    }

    public Collection<String> filter(String pattern, Collection<String> identifiers) {
        ArrayList<String> filtered = new ArrayList<String>();
        String found = DeploymentIdResolver.matchAndReturnLatest(pattern, identifiers);
        if (found != null && !found.equals(pattern)) {
            filtered.add(found);
        }
        return filtered;
    }

    private static class GAVInfo {
        private String groupId;
        private String artifactId;
        private String version;

        GAVInfo(String deploymentId) {
            String[] details = deploymentId.split(":");
            this.groupId = details[0];
            this.artifactId = details[1];
            this.version = details[2];
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }
    }

    private static class GroupAndArtifactMatchPredicate
    implements Predicate {
        private GAVInfo gavInfo;
        private String groupArtifact;

        private GroupAndArtifactMatchPredicate(String deploymentId) {
            this.gavInfo = new GAVInfo(deploymentId);
            this.groupArtifact = this.gavInfo.getGroupId() + ":" + this.gavInfo.getArtifactId();
        }

        public boolean evaluate(Object object) {
            String identifier;
            return object instanceof String ? ((String)object).startsWith(this.groupArtifact) : object instanceof DeployedUnit && (identifier = ((DeployedUnit)object).getDeploymentUnit().getIdentifier()).startsWith(this.groupArtifact);
        }
    }
}

