/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.StartNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeType;

public class EventSubProcessNode
extends CompositeContextNode {
    private static final long serialVersionUID = 2200928773922042238L;
    private List<String> events = new ArrayList<String>();
    private List<EventTypeFilter> eventTypeFilters = new ArrayList<EventTypeFilter>();
    private boolean keepActive = true;

    public EventSubProcessNode() {
        super(NodeType.EVENT_SUBPROCESS);
    }

    public void addEvent(EventTypeFilter filter) {
        String type = filter.getType();
        this.events.add(type);
        this.eventTypeFilters.add(filter);
    }

    public List<String> getEvents() {
        return this.events;
    }

    public boolean isKeepActive() {
        return this.keepActive;
    }

    public void setKeepActive(boolean triggerOnActivation) {
        this.keepActive = triggerOnActivation;
    }

    public StartNode findStartNode() {
        for (Node node : this.getNodes()) {
            if (!(node instanceof StartNode)) continue;
            StartNode startNode = (StartNode)node;
            return startNode;
        }
        return null;
    }

    @Override
    public void addTimer(Timer timer, DroolsAction action) {
        super.addTimer(timer, action);
        if (timer.getTimeType() == 2) {
            this.setKeepActive(false);
        }
    }

    @Override
    public boolean acceptsEvent(String type, Object event) {
        for (EventTypeFilter filter : this.eventTypeFilters) {
            if (!filter.acceptsEvent(type, event)) continue;
            return true;
        }
        return super.acceptsEvent(type, event);
    }

    @Override
    public boolean acceptsEvent(String type, Object event, Function<String, String> resolver) {
        if (resolver == null) {
            return this.acceptsEvent(type, event);
        }
        for (EventTypeFilter filter : this.eventTypeFilters) {
            if (!filter.acceptsEvent(type, event, resolver)) continue;
            return true;
        }
        return super.acceptsEvent(type, event);
    }
}

