/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.configuration.support;

import java.util.Properties;
import org.powermock.configuration.Configuration;
import org.powermock.configuration.ConfigurationFactory;
import org.powermock.configuration.support.ConfigurationBuilder;
import org.powermock.utils.Asserts;

public class ConfigurationFactoryImpl
implements ConfigurationFactory {
    private static final String USER_CONFIGURATION = "org/powermock/extensions/configuration.properties";
    private static final String DEFAULT_CONFIGURATION = "org/powermock/default.properties";
    private final String userConfigurationLocation;
    private final String defaultConfigurationLocation;

    public ConfigurationFactoryImpl() {
        this(USER_CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    ConfigurationFactoryImpl(String userConfigurationLocation, String defaultConfigurationLocation) {
        this.userConfigurationLocation = userConfigurationLocation;
        this.defaultConfigurationLocation = defaultConfigurationLocation;
    }

    ConfigurationFactoryImpl(String defaultConfigurationLocation) {
        this(USER_CONFIGURATION, defaultConfigurationLocation);
    }

    @Override
    public <T extends Configuration<T>> T create(Class<T> configurationType) {
        T environmentConfiguration = this.readEnvironmentConfiguration(configurationType);
        T configuration = this.readUserConfiguration(configurationType);
        T defaultConfiguration = this.readDefault(configurationType);
        return defaultConfiguration.merge(configuration.merge(environmentConfiguration));
    }

    private <T extends Configuration<T>> T readEnvironmentConfiguration(Class<T> configurationType) {
        Properties properties = new Properties();
        properties.putAll(System.getenv());
        return ConfigurationBuilder.createConfigurationFor(configurationType).fromProperties(properties);
    }

    private <T extends Configuration> T readDefault(Class<T> configurationType) {
        T configuration = ConfigurationBuilder.createConfigurationFor(configurationType).fromFile(this.getDefaultConfigurationLocation());
        Asserts.internalAssertNotNull(configuration, "Default configuration is null.");
        return configuration;
    }

    private <T extends Configuration> T readUserConfiguration(Class<T> configurationType) {
        return ConfigurationBuilder.createConfigurationFor(configurationType).fromFile(this.getUserConfigurationLocation());
    }

    private String getDefaultConfigurationLocation() {
        return this.defaultConfigurationLocation;
    }

    private String getUserConfigurationLocation() {
        return this.userConfigurationLocation;
    }
}

