/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.TextIndex;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtils;
import org.kie.pmml.compiler.commons.utils.ModelUtils;

public class DefineFunctionUtils {
    private DefineFunctionUtils() {
    }

    static Map<String, MethodDeclaration> getDefineFunctionsMethodMap(List<DefineFunction> defineFunctions) {
        HashMap<String, MethodDeclaration> toReturn = new HashMap<String, MethodDeclaration>();
        defineFunctions.forEach(defineFunction -> toReturn.put(defineFunction.getName(), DefineFunctionUtils.getDefineFunctionMethodDeclaration(defineFunction)));
        return toReturn;
    }

    static MethodDeclaration getDefineFunctionMethodDeclaration(DefineFunction defineFunction) {
        Expression expression = defineFunction.getExpression();
        if (expression != null) {
            return DefineFunctionUtils.getExpressionMethodDeclaration(defineFunction.getName(), expression, defineFunction.getDataType(), defineFunction.getParameterFields());
        }
        throw new KiePMMLException("Define Function without Expression are not supported, yet");
    }

    static MethodDeclaration getExpressionMethodDeclaration(String methodName, Expression expression, DataType dataType, List<ParameterField> parameterFields) {
        ClassOrInterfaceType returnedType = StaticJavaParser.parseClassOrInterfaceType((String)ModelUtils.getBoxedClassName(dataType));
        LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap = new LinkedHashMap<String, ClassOrInterfaceType>(ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        parameterNameTypeMap.putAll(DefineFunctionUtils.getNameClassOrInterfaceTypeMap(parameterFields));
        if (expression instanceof Aggregate) {
            return DefineFunctionUtils.getAggregatedMethodDeclaration(methodName, (Aggregate)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof Apply) {
            return DefineFunctionUtils.getApplyMethodDeclaration(methodName, (Apply)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof Constant) {
            return DefineFunctionUtils.getConstantMethodDeclaration(methodName, (Constant)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof Discretize) {
            return DefineFunctionUtils.getDiscretizeMethodDeclaration(methodName, (Discretize)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof FieldRef) {
            return DefineFunctionUtils.getFieldRefMethodDeclaration(methodName, (FieldRef)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof Lag) {
            return DefineFunctionUtils.getLagMethodDeclaration(methodName, (Lag)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof MapValues) {
            return DefineFunctionUtils.getMapValuesMethodDeclaration(methodName, (MapValues)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof NormContinuous) {
            return DefineFunctionUtils.getNormContinuousMethodDeclaration(methodName, (NormContinuous)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof NormDiscrete) {
            return DefineFunctionUtils.getNormDiscreteMethodDeclaration(methodName, (NormDiscrete)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof TextIndex) {
            return DefineFunctionUtils.getTextIndexMethodDeclaration(methodName, (TextIndex)expression, returnedType, parameterNameTypeMap);
        }
        throw new IllegalArgumentException(String.format("Expression %s not managed", expression.getClass()));
    }

    static MethodDeclaration getAggregatedMethodDeclaration(String methodName, Aggregate aggregate, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Aggregate not managed, yet");
    }

    static MethodDeclaration getApplyMethodDeclaration(String methodName, Apply apply, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        return ExpressionFunctionUtils.getApplyExpressionMethodDeclaration(methodName, apply, returnedType, parameterNameTypeMap);
    }

    static MethodDeclaration getConstantMethodDeclaration(String methodName, Constant constant, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        return ExpressionFunctionUtils.getConstantExpressionMethodDeclaration(methodName, constant, returnedType, parameterNameTypeMap);
    }

    static MethodDeclaration getDiscretizeMethodDeclaration(String methodName, Discretize discretize, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Discretize not managed, yet");
    }

    static MethodDeclaration getFieldRefMethodDeclaration(String methodName, FieldRef fieldRef, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        return ExpressionFunctionUtils.getFieldRefExpressionMethodDeclaration(methodName, fieldRef, returnedType, parameterNameTypeMap);
    }

    static MethodDeclaration getLagMethodDeclaration(String methodName, Lag lag, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Lag not managed, yet");
    }

    static MethodDeclaration getMapValuesMethodDeclaration(String methodName, MapValues mapValues, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("MapValues not managed, yet");
    }

    static MethodDeclaration getNormContinuousMethodDeclaration(String methodName, NormContinuous normContinuous, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("NormContinuous not managed, yet");
    }

    static MethodDeclaration getNormDiscreteMethodDeclaration(String methodName, NormDiscrete normDiscrete, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("NormDiscrete not managed, yet");
    }

    static MethodDeclaration getTextIndexMethodDeclaration(String methodName, TextIndex textIndex, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("TextIndex not managed, yet");
    }

    static LinkedHashMap<String, ClassOrInterfaceType> getNameClassOrInterfaceTypeMap(List<ParameterField> parameterNameTypeMap) {
        LinkedHashMap<String, ClassOrInterfaceType> toReturn = new LinkedHashMap<String, ClassOrInterfaceType>();
        if (parameterNameTypeMap != null) {
            parameterNameTypeMap.forEach(parameterField -> toReturn.put(parameterField.getName().toString(), StaticJavaParser.parseClassOrInterfaceType((String)ModelUtils.getBoxedClassName(parameterField))));
        }
        return toReturn;
    }
}

